/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityPlayerTransformer
extends TransformerBase {
    private String entityPlayerClassName;
    private String inventoryClassName;
    private String itemStackClassName;
    private String entityClassName;
    private String potionClassName;
    private String potionEffectClassName;
    private String entityLivingClassName;
    private String dataWatcherClassName;
    private String playerInventoryFieldName;
    private String potionDigSpeedField;
    private String potionDigSlowField;
    private String playerDataWatcherField;
    private String onItemFinishMethodName;
    private String onItemFinishMethodDesc;
    private String setCurrentItemArmourMethodName;
    private String setCurrentItemArmourMethodDesc;
    private String playerPotionActiveMethodName;
    private String playerPotionActiveMethodDesc;
    private String playerGetActivePotionMethodName;
    private String playerGetActivePotionMethodDesc;
    private String potionEffectGetAmpMethodName;
    private String playerUpdateArmSwingMethodName;
    private String dataWatcherAddObjectMethodName;
    private String dataWatcherAddObjectMethodDesc;
    private String playerInitMethodName;
    private String playerInitMethodDesc;
    private String itemStackGetItemMethodName;
    private String itemStackGetItemMethodDesc;
    private String dataWatcherGetByteMethodName;
    private String dataWatcherGetByteMethodDesc;
    private String dataWatcherUpdateObjectMethodName;
    private String dataWatcherUpdateObjectMethodDesc;

    public EntityPlayerTransformer() {
        super("net.minecraft.entity.player.EntityPlayer");
    }

    @Override
    void addInterface(List<String> interfaces) {
        interfaces.add(Type.getInternalName(IBattlePlayer.class));
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        System.out.println("\tAdding new fields to EntityPlayer");
        fields.add(fields.size(), new FieldNode(1, "offHandSwingProgress", "F", null, (Object)Float.valueOf(0.0f)));
        fields.add(fields.size(), new FieldNode(1, "prevOffHandSwingProgress", "F", null, (Object)Float.valueOf(0.0f)));
        fields.add(fields.size(), new FieldNode(1, "offHandSwingProgressInt", "I", null, (Object)0));
        fields.add(fields.size(), new FieldNode(1, "isOffHandSwingInProgress", "Z", null, (Object)false));
        fields.add(fields.size(), new FieldNode(1, "specialActionTimer", "I", null, (Object)0));
        for (FieldNode fn : fields) {
            if (!fn.name.equals(this.playerInventoryFieldName) || !fn.desc.equals("L" + this.inventoryClassName + ";")) continue;
            System.out.println("M&B - Marking field inventory as final in EntityPlayer");
            fn.access = 17;
            return true;
        }
        return false;
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode mn : methods) {
            if (mn.name.equals("<init>")) {
                System.out.println("\tPatching constructor in EntityPlayer");
                for (AbstractInsnNode insn : mn.instructions) {
                    if (insn instanceof TypeInsnNode) {
                        if (!((TypeInsnNode)insn).desc.equals(this.inventoryClassName)) continue;
                        ((TypeInsnNode)insn).desc = "mods/battlegear2/api/core/InventoryPlayerBattle";
                        continue;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals(this.inventoryClassName)) continue;
                    ((MethodInsnNode)insn).owner = "mods/battlegear2/api/core/InventoryPlayerBattle";
                }
                ++found;
                continue;
            }
            if (mn.name.equals(this.onItemFinishMethodName) && mn.desc.equals(this.onItemFinishMethodDesc)) {
                this.sendPatchLog("onItemUseFinish");
                EntityPlayerTransformer.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, mn.maxStack, mn.maxLocals);
                ++found;
                continue;
            }
            if (mn.name.equals(this.setCurrentItemArmourMethodName) && mn.desc.equals(this.setCurrentItemArmourMethodDesc)) {
                this.sendPatchLog("setCurrentItemOrArmor");
                EntityPlayerTransformer.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, mn.maxStack, mn.maxLocals);
                ++found;
                continue;
            }
            if (!mn.name.equals(this.playerInitMethodName) || !mn.desc.equals(this.playerInitMethodDesc)) continue;
            this.sendPatchLog("entityInit");
            InsnList newList = new InsnList();
            for (AbstractInsnNode next : mn.instructions) {
                if (next instanceof InsnNode && next.getOpcode() == 177) {
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
                    newList.add((AbstractInsnNode)new VarInsnNode(16, 25));
                    newList.add((AbstractInsnNode)new InsnNode(3));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
                    newList.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherAddObjectMethodName, this.dataWatcherAddObjectMethodDesc));
                }
                newList.add(next);
            }
            mn.instructions = newList;
            ++found;
        }
        System.out.println("\tCreating new methods in EntityPlayer");
        methods.add(methods.size(), this.generateAttackOffhandMethod());
        methods.add(methods.size(), this.generateSwingOffhand());
        methods.add(methods.size(), this.generateGetOffSwingMethod());
        methods.add(methods.size(), this.generateSwingAnimationEnd2());
        methods.add(methods.size(), this.generateUpdateSwingArm());
        methods.add(methods.size(), this.generateIsBattleMode());
        methods.add(methods.size(), this.generateIsBlockingWithShield());
        methods.add(methods.size(), this.generateSetBlockingWithShield());
        methods.add(methods.size(), EntityPlayerTransformer.generateGetter(this.entityPlayerClassName, "getSpecialActionTimer", "specialActionTimer", "I"));
        methods.add(methods.size(), EntityPlayerTransformer.generateSetter(this.entityPlayerClassName, "setSpecialActionTimer", "specialActionTimer", "I"));
        return found == 4;
    }

    private MethodNode generateIsBlockingWithShield() {
        MethodNode mn = new MethodNode(262144, 1, "isBlockingWithShield", "()Z", null, null);
        LabelNode L1 = new LabelNode();
        LabelNode L3 = new LabelNode();
        LabelNode L4 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/api/core/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/api/core/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(198, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/api/core/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/api/core/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClassName, this.itemStackGetItemMethodName, this.itemStackGetItemMethodDesc));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(193, "mods/battlegear2/api/shield/IShield"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(16, 25));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherGetByteMethodName, this.dataWatcherGetByteMethodDesc));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(158, L3));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, L4));
        mn.instructions.add((AbstractInsnNode)L3);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)L4);
        mn.instructions.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{Opcodes.INTEGER}));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.instructions.add((AbstractInsnNode)L1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.maxStack = 2;
        mn.maxLocals = 1;
        return mn;
    }

    private MethodNode generateSetBlockingWithShield() {
        MethodNode mn = new MethodNode(262144, 1, "setBlockingWithShield", "(Z)V", null, null);
        LabelNode L1 = new LabelNode();
        LabelNode L3 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/api/core/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/api/core/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(198, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/api/core/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/api/core/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClassName, this.itemStackGetItemMethodName, this.itemStackGetItemMethodDesc));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(193, "mods/battlegear2/api/shield/IShield"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(16, 25));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherUpdateObjectMethodName, this.dataWatcherUpdateObjectMethodDesc));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, L3));
        mn.instructions.add((AbstractInsnNode)L1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(16, 25));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherUpdateObjectMethodName, this.dataWatcherUpdateObjectMethodDesc));
        mn.instructions.add((AbstractInsnNode)L3);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 2;
        return mn;
    }

    private MethodNode generateAttackOffhandMethod() {
        MethodNode mn = new MethodNode(262144, 1, "attackTargetEntityWithCurrentOffItem", "(L" + this.entityClassName + ";)V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "attackTargetEntityWithCurrentOffItem", "(L" + this.entityPlayerClassName + ";L" + this.entityClassName + ";)V"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 2;
        return mn;
    }

    private MethodNode generateSwingOffhand() {
        MethodNode mn = new MethodNode(262144, 1, "swingOffItem", "()V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.entityPlayerClassName, "getArmSwingAnimationEndCopy", "()I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(5));
        mn.instructions.add((AbstractInsnNode)new InsnNode(108));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(162, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        LabelNode l1 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(156, l1));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(2));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        mn.instructions.add((AbstractInsnNode)l1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 1;
        return mn;
    }

    private MethodNode generateGetOffSwingMethod() {
        MethodNode mn = new MethodNode(262144, 1, "getOffSwingProgress", "(F)F", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "prevOffHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(102));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(56, 2));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        mn.instructions.add((AbstractInsnNode)new InsnNode(11));
        mn.instructions.add((AbstractInsnNode)new InsnNode(150));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(156, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        mn.instructions.add((AbstractInsnNode)new InsnNode(12));
        mn.instructions.add((AbstractInsnNode)new InsnNode(98));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(56, 2));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{Opcodes.FLOAT}, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "prevOffHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
        mn.instructions.add((AbstractInsnNode)new InsnNode(106));
        mn.instructions.add((AbstractInsnNode)new InsnNode(98));
        mn.instructions.add((AbstractInsnNode)new InsnNode(174));
        mn.maxLocals = 3;
        mn.maxStack = 3;
        return mn;
    }

    private MethodNode generateSwingAnimationEnd2() {
        MethodNode mn = new MethodNode(262144, 2, "getArmSwingAnimationEndCopy", "()I", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSpeedField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerPotionActiveMethodName, this.playerPotionActiveMethodDesc));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l0));
        mn.instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSpeedField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerGetActivePotionMethodName, this.playerGetActivePotionMethodDesc));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.potionEffectClassName, this.potionEffectGetAmpMethodName, "()I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new InsnNode(104));
        mn.instructions.add((AbstractInsnNode)new InsnNode(100));
        LabelNode l1 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, l1));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSlowField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerPotionActiveMethodName, "(L" + this.potionClassName + ";)Z"));
        LabelNode l2 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l2));
        mn.instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSlowField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerGetActivePotionMethodName, "(L" + this.potionClassName + ";)L" + this.potionEffectClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.potionEffectClassName, this.potionEffectGetAmpMethodName, "()I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new InsnNode(5));
        mn.instructions.add((AbstractInsnNode)new InsnNode(104));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, l1));
        mn.instructions.add((AbstractInsnNode)l2);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
        mn.instructions.add((AbstractInsnNode)l1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{Opcodes.INTEGER}));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.maxStack = 4;
        mn.maxLocals = 1;
        return mn;
    }

    private MethodNode generateUpdateSwingArm() {
        MethodNode mn = new MethodNode(262144, 4, this.playerUpdateArmSwingMethodName, "()V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.entityLivingClassName, this.playerUpdateArmSwingMethodName, "()V"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "prevOffHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.entityPlayerClassName, "getArmSwingAnimationEndCopy", "()I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(54, 1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(89));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        LabelNode l1 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(161, l1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, l1));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)l1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(134));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        mn.instructions.add((AbstractInsnNode)new InsnNode(134));
        mn.instructions.add((AbstractInsnNode)new InsnNode(110));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 2;
        return mn;
    }

    private MethodNode generateIsBattleMode() {
        MethodNode mn = new MethodNode(262144, 1, "isBattlemode", "()Z", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/api/core/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/api/core/InventoryPlayerBattle", "isBattlemode", "()Z"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.maxStack = 1;
        mn.maxLocals = 1;
        return mn;
    }

    @Override
    void setupMappings() {
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.inventoryClassName = BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer");
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.entityClassName = BattlegearTranslator.getMapedClassName("entity.Entity");
        this.potionClassName = BattlegearTranslator.getMapedClassName("potion.Potion");
        this.potionEffectClassName = BattlegearTranslator.getMapedClassName("potion.PotionEffect");
        this.entityLivingClassName = BattlegearTranslator.getMapedClassName("entity.EntityLivingBase");
        this.dataWatcherClassName = BattlegearTranslator.getMapedClassName("entity.DataWatcher");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by", "inventory");
        this.potionDigSpeedField = BattlegearTranslator.getMapedFieldName("Potion", "field_76422_e", "digSpeed");
        this.potionDigSlowField = BattlegearTranslator.getMapedFieldName("Potion", "field_76419_f", "digSlowdown");
        this.playerDataWatcherField = BattlegearTranslator.getMapedFieldName("Entity", "field_70180_af", "dataWatcher");
        this.onItemFinishMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_71036_o", "onItemUseFinish");
        this.onItemFinishMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_71036_o", "()V");
        this.setCurrentItemArmourMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_70062_b", "setCurrentItemOrArmor");
        this.setCurrentItemArmourMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_70062_b", "(IL" + this.itemStackClassName + ";)V");
        this.playerPotionActiveMethodName = BattlegearTranslator.getMapedMethodName("EntityLivingBase", "func_70644_a", "isPotionActive");
        this.playerPotionActiveMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityLivingBase", "func_70644_a", "(L" + this.potionClassName + ";)Z");
        this.playerGetActivePotionMethodName = BattlegearTranslator.getMapedMethodName("EntityLivingBase", "func_70660_b", "getActivePotionEffect");
        this.playerGetActivePotionMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityLivingBase", "func_70660_b", "(L" + this.potionClassName + ";)L" + this.potionEffectClassName + ";");
        this.potionEffectGetAmpMethodName = BattlegearTranslator.getMapedMethodName("PotionEffect", "func_76458_c", "getAmplifier");
        this.playerUpdateArmSwingMethodName = BattlegearTranslator.getMapedMethodName("EntityLivingBase", "func_82168_bl", "updateArmSwingProgress");
        this.dataWatcherAddObjectMethodName = BattlegearTranslator.getMapedMethodName("DataWatcher", "func_75682_a", "addObject");
        this.dataWatcherAddObjectMethodDesc = BattlegearTranslator.getMapedMethodDesc("DataWatcher", "func_75682_a", "(ILjava/lang/Object;)V");
        this.playerInitMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_70088_a", "entityInit");
        this.playerInitMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_70088_a", "()V");
        this.itemStackGetItemMethodName = BattlegearTranslator.getMapedMethodName("ItemStack", "func_77973_b", "getItem");
        this.itemStackGetItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemStack", "func_77973_b", "()Lnet/minecraft/item/Item;");
        this.dataWatcherGetByteMethodName = BattlegearTranslator.getMapedMethodName("DataWatcher", "func_75683_a", "getWatchableObjectByte");
        this.dataWatcherGetByteMethodDesc = BattlegearTranslator.getMapedMethodDesc("DataWatcher", "func_75683_a", "(I)B");
        this.dataWatcherUpdateObjectMethodName = BattlegearTranslator.getMapedMethodName("DataWatcher", "func_75692_b", "updateObject");
        this.dataWatcherUpdateObjectMethodDesc = BattlegearTranslator.getMapedMethodDesc("DataWatcher", "func_75692_b", "(ILjava/lang/Object;)V");
    }
}

