/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerMethodProcess;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityTrackerTransformer
extends TransformerMethodProcess {
    private String entityPlayerClassName;
    private String entityPlayerMPClassName;
    private String netServerHandlerClasName;
    private String packetClassName;
    private String playerMPplayerNetServerHandlerField;
    private String sendPacketToPlayerMethodName;
    private String sendPacketToPlayerMethodDesc;
    private static final String syncPacket = "mods/battlegear2/packet/BattlegearSyncItemPacket";

    public EntityTrackerTransformer() {
        super("net.minecraft.entity.EntityTrackerEntry", "func_73117_b", new String[]{"tryStartWachingThis", "(Lnet/minecraft/entity/player/EntityPlayerMP;)V"});
    }

    @Override
    void processMethod(MethodNode method) {
        this.sendPatchLog("tryStartTrackingEntity");
        InsnList newList = new InsnList();
        ListIterator insn = method.instructions.iterator();
        boolean done = false;
        while (insn.hasNext()) {
            AbstractInsnNode next = (AbstractInsnNode)insn.next();
            if (!done && next instanceof TypeInsnNode && next.getOpcode() == 192 && ((TypeInsnNode)next).desc.equals(this.entityPlayerClassName)) {
                newList.add(next);
                newList.add((AbstractInsnNode)insn.next());
                newList.add((AbstractInsnNode)insn.next());
                newList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerMPClassName, this.playerMPplayerNetServerHandlerField, "L" + this.netServerHandlerClasName + ";"));
                newList.add((AbstractInsnNode)new TypeInsnNode(187, syncPacket));
                newList.add((AbstractInsnNode)new InsnNode(89));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 10));
                newList.add((AbstractInsnNode)new MethodInsnNode(183, syncPacket, "<init>", "(L" + this.entityPlayerClassName + ";)V"));
                newList.add((AbstractInsnNode)new MethodInsnNode(182, syncPacket, "generatePacket", "()L" + this.packetClassName + ";"));
                newList.add((AbstractInsnNode)new MethodInsnNode(182, this.netServerHandlerClasName, this.sendPacketToPlayerMethodName, this.sendPacketToPlayerMethodDesc));
                done = true;
                continue;
            }
            newList.add(next);
        }
        method.instructions = newList;
    }

    @Override
    void setupMappings() {
        super.setupMappings();
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.entityPlayerMPClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayerMP");
        this.netServerHandlerClasName = BattlegearTranslator.getMapedClassName("network.NetHandlerPlayServer");
        this.packetClassName = BattlegearTranslator.getMapedClassName("network.Packet");
        this.playerMPplayerNetServerHandlerField = BattlegearTranslator.getMapedFieldName("EntityPlayerMP", "field_71135_a", "playerNetServerHandler");
        this.sendPacketToPlayerMethodName = BattlegearTranslator.getMapedMethodName("NetHandlerPlayServer", "func_147359_a", "sendPacket");
        this.sendPacketToPlayerMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetHandlerPlayServer", "func_147359_a", "(L" + this.packetClassName + ";)V");
    }
}

