/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.IOffhandRender;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemRendererTransformer
extends TransformerBase {
    private String itemStackClass;
    private String itemRendererClass;
    private String minecraftClass;
    private String itemRendererMinecraftField;
    private String itemRendereriteToRenderField;
    private String renderItem1stPersonMethodName;
    private String renderItem1stPersonMethodDesc;
    private String updateEquippedItemMethodName;
    private String updateEquippedItemMethodDesc;

    public ItemRendererTransformer() {
        super("net.minecraft.client.renderer.ItemRenderer");
    }

    @Override
    void addInterface(List<String> interfaces) {
        interfaces.add(Type.getInternalName(IOffhandRender.class));
    }

    private void processUpdateEquippedMethod(MethodNode mn) {
        this.sendPatchLog("updateEquippedItem");
        InsnList newList = new InsnList();
        for (AbstractInsnNode insn : mn.instructions) {
            if (insn.getOpcode() == 177) {
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, this.itemRendererMinecraftField, "L" + this.minecraftClass + ";"));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, this.itemRendereriteToRenderField, "L" + this.itemStackClass + ";"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearRenderHelper", "updateEquippedItem", "(L" + this.itemRendererClass + ";L" + this.minecraftClass + ";L" + this.itemStackClass + ";)V"));
            }
            newList.add(insn);
        }
        mn.instructions = newList;
    }

    private void processRenderItemMethod(MethodNode mn) {
        this.sendPatchLog("renderItemInFirstPerson");
        InsnList newList = new InsnList();
        for (AbstractInsnNode insn : mn.instructions) {
            if (insn.getOpcode() == 177) {
                newList.add((AbstractInsnNode)new VarInsnNode(23, 1));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, this.itemRendererMinecraftField, "L" + this.minecraftClass + ";"));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, "offHandItemToRender", "L" + this.itemStackClass + ";"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearRenderHelper", "renderItemInFirstPerson", "(FL" + this.minecraftClass + ";L" + this.itemRendererClass + ";L" + this.itemStackClass + ";)V"));
            }
            newList.add(insn);
        }
        mn.instructions = newList;
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode mn : methods) {
            if (mn.name.equals(this.renderItem1stPersonMethodName) && mn.desc.equals(this.renderItem1stPersonMethodDesc)) {
                this.processRenderItemMethod(mn);
                ++found;
                continue;
            }
            if (!mn.name.equals(this.updateEquippedItemMethodName) || !mn.desc.equals(this.updateEquippedItemMethodDesc)) continue;
            this.processUpdateEquippedMethod(mn);
            ++found;
        }
        methods.add(methods.size(), ItemRendererTransformer.generateSetter(this.itemRendererClass, "setItemToRender", "offHandItemToRender", "L" + this.itemStackClass + ";"));
        methods.add(methods.size(), ItemRendererTransformer.generateSetter(this.itemRendererClass, "setEquippedItemSlot", "equippedItemOffhandSlot", "I"));
        methods.add(methods.size(), ItemRendererTransformer.generateSetter(this.itemRendererClass, "setEquippedProgress", "equippedOffHandProgress", "F"));
        methods.add(methods.size(), ItemRendererTransformer.generateSetter(this.itemRendererClass, "setPrevEquippedProgress", "prevEquippedOffHandProgress", "F"));
        methods.add(methods.size(), ItemRendererTransformer.generateGetter(this.itemRendererClass, "getItemToRender", "offHandItemToRender", "L" + this.itemStackClass + ";"));
        methods.add(methods.size(), ItemRendererTransformer.generateGetter(this.itemRendererClass, "getEquippedItemSlot", "equippedItemOffhandSlot", "I"));
        methods.add(methods.size(), ItemRendererTransformer.generateGetter(this.itemRendererClass, "getEquippedProgress", "equippedOffHandProgress", "F"));
        methods.add(methods.size(), ItemRendererTransformer.generateGetter(this.itemRendererClass, "getPrevEquippedProgress", "prevEquippedOffHandProgress", "F"));
        return found == 2;
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        System.out.println("\tAdding new fields to ItemRenderer");
        fields.add(fields.size(), new FieldNode(1, "offHandItemToRender", "L" + this.itemStackClass + ";", null, null));
        fields.add(fields.size(), new FieldNode(1, "equippedItemOffhandSlot", "I", null, (Object)0));
        fields.add(fields.size(), new FieldNode(1, "equippedOffHandProgress", "F", null, (Object)Float.valueOf(0.0f)));
        fields.add(fields.size(), new FieldNode(1, "prevEquippedOffHandProgress", "F", null, (Object)Float.valueOf(0.0f)));
        return true;
    }

    @Override
    void setupMappings() {
        this.itemStackClass = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.itemRendererClass = BattlegearTranslator.getMapedClassName("client.renderer.ItemRenderer");
        this.minecraftClass = BattlegearTranslator.getMapedClassName("client.Minecraft");
        this.itemRendererMinecraftField = BattlegearTranslator.getMapedFieldName("ItemRenderer", "field_78455_a", "mc");
        this.itemRendereriteToRenderField = BattlegearTranslator.getMapedFieldName("ItemRenderer", "field_78453_b", "itemToRender");
        this.renderItem1stPersonMethodName = BattlegearTranslator.getMapedMethodName("ItemRenderer", "func_78440_a", "renderItemInFirstPerson");
        this.renderItem1stPersonMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemRenderer", "func_78440_a", "(F)V");
        this.updateEquippedItemMethodName = BattlegearTranslator.getMapedMethodName("ItemRenderer", "func_78441_a", "updateEquippedItem");
        this.updateEquippedItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemRenderer", "func_78441_a", "()V");
    }
}

