/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.IDyable;
import mods.battlegear2.api.IEnchantable;
import mods.battlegear2.api.ISheathed;
import mods.battlegear2.api.shield.IArrowCatcher;
import mods.battlegear2.api.shield.IArrowDisplay;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.shield.ShieldType;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.items.ItemWeapon;
import mods.battlegear2.packet.BattlegearShieldFlashPacket;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemShield
extends Item
implements IShield,
IDyable,
IEnchantable,
ISheathed,
IArrowCatcher,
IArrowDisplay {
    public ShieldType enumShield;
    private IIcon backIcon;
    private IIcon trimIcon;
    public static final float[] arrowX = new float[64];
    public static final float[] arrowY = new float[64];
    public static final float[] arrowDepth = new float[64];
    public static final float[] pitch = new float[64];
    public static final float[] yaw = new float[64];

    public ItemShield(ShieldType enumShield) {
        this.func_77637_a(BattlegearConfig.customTab);
        this.enumShield = enumShield;
        this.func_77655_b("battlegear2:shield." + enumShield.getName());
        this.func_111206_d("battlegear2:shield/shield." + enumShield.getName());
        this.func_77656_e(enumShield.getMaxDamage());
        this.func_77625_d(1);
        this.func_77627_a(false);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        this.backIcon = par1IconRegister.func_94245_a("battlegear2:shield/shield." + this.enumShield.getName() + ".back");
        this.trimIcon = par1IconRegister.func_94245_a("battlegear2:shield/shield." + this.enumShield.getName() + ".trim");
    }

    @Override
    public boolean catchArrow(ItemStack shield, EntityPlayer player, IProjectile arrow) {
        if (arrow instanceof EntityArrow) {
            this.setArrowCount(shield, this.getArrowCount(shield) + 1);
            player.func_85034_r(player.func_85035_bI() - 1);
            ((EntityArrow)arrow).func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public int getArrowCount(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("arrows")) {
            return stack.func_77978_p().func_74765_d("arrows");
        }
        return 0;
    }

    @Override
    public void setArrowCount(ItemStack stack, int count) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
        }
        stack.func_77978_p().func_74777_a("arrows", (short)count);
    }

    public IIcon getBackIcon() {
        return this.backIcon;
    }

    public IIcon getTrimIcon() {
        return this.trimIcon;
    }

    @Override
    public float getDecayRate(ItemStack shield) {
        int use = EnchantmentHelper.func_77506_a((int)BaseEnchantment.shieldUsage.field_77352_x, (ItemStack)shield);
        return this.enumShield.getDecayRate() * (1.0f - (float)use * 0.1f);
    }

    @Override
    public float getRecoveryRate(ItemStack shield) {
        int recover = EnchantmentHelper.func_77506_a((int)BaseEnchantment.shieldRecover.field_77352_x, (ItemStack)shield);
        return 0.01f * (1.0f + (float)recover * 0.2f);
    }

    @Override
    public boolean canBlock(ItemStack shield, DamageSource source) {
        return !source.func_76363_c();
    }

    @Override
    public void blockAnimation(EntityPlayer player, float dmg) {
        Battlegear.packetHandler.sendPacketAround((Entity)player, 32.0, new BattlegearShieldFlashPacket(player, dmg).generatePacket());
        player.field_70170_p.func_72956_a((Entity)player, "battlegear2:shield", 1.0f, 1.0f);
    }

    @Override
    public float getDamageReduction(ItemStack shield, DamageSource source) {
        return 0.0f;
    }

    @Override
    public float getDamageDecayRate(ItemStack shield, float amount) {
        return this.enumShield.getDamageDecay() * amount;
    }

    @Override
    public float getBlockAngle(ItemStack shield) {
        return 60.0f;
    }

    @Override
    public int getBashTimer(ItemStack shield) {
        return 10;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        par3List.add("");
        par3List.add(EnumChatFormatting.DARK_GREEN + ItemWeapon.decimal_format.format(1.0f / this.enumShield.getDecayRate() / 20.0f) + StatCollector.func_74838_a((String)"attribute.shield.block.time"));
        int arrowCount = this.getArrowCount(par1ItemStack);
        if (arrowCount > 0) {
            par3List.add(String.format("%s%s %s", EnumChatFormatting.GOLD, arrowCount, StatCollector.func_74838_a((String)"attribute.shield.arrow.count")));
        }
    }

    @Override
    public boolean hasColor(ItemStack par1ItemStack) {
        return par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("display") && par1ItemStack.func_77978_p().func_74775_l("display").func_74764_b("color");
    }

    @Override
    public int getColor(ItemStack par1ItemStack) {
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound == null) {
            return this.getDefaultColor(par1ItemStack);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        return nbttagcompound1 == null ? this.getDefaultColor(par1ItemStack) : (nbttagcompound1.func_74764_b("color") ? nbttagcompound1.func_74762_e("color") : this.getDefaultColor(par1ItemStack));
    }

    @Override
    public void removeColor(ItemStack par1ItemStack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    @Override
    public int getDefaultColor(ItemStack par1ItemStack) {
        return this.enumShield.getDefaultRGB();
    }

    @Override
    public void setColor(ItemStack par1ItemStack, int par2) {
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            par1ItemStack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_74764_b("display")) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", par2);
    }

    @Override
    public boolean isEnchantable(Enchantment baseEnchantment, ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return this.enumShield.getEnchantability();
    }

    @Override
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            double r = Math.random() * 5.0;
            double theta = Math.random() * Math.PI * 2.0;
            ItemShield.arrowX[i] = (float)(r * Math.cos(theta));
            ItemShield.arrowY[i] = (float)(r * Math.sin(theta));
            ItemShield.arrowDepth[i] = (float)(Math.random() * 0.5 + 0.5);
            ItemShield.pitch[i] = (float)(Math.random() * 50.0 - 25.0);
            ItemShield.yaw[i] = (float)(Math.random() * 50.0 - 25.0);
        }
    }
}

