/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.tile.ExplosionWhitelist;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.util.ItemStackWrapper;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExplosionIC2
extends Explosion {
    private final Random ExplosionRNG = new Random();
    private final World worldObj;
    private final int mapHeight;
    private final float power;
    private final float explosionDropRate;
    private final Type type;
    private final int radiationRange;
    private final EntityLivingBase igniter;
    private final List<Map.Entry<Integer, Entity>> entitiesInRange = new ArrayList<Map.Entry<Integer, Entity>>();
    private final Map<ChunkPosition, Boolean> destroyedBlockPositions = new HashMap<ChunkPosition, Boolean>();
    private ChunkCache chunkCache;
    private static final double dropPowerLimit = 8.0;
    private static final double damageAtDropPowerLimit = 32.0;
    private static final double accelerationAtDropPowerLimit = 0.7;
    private static final double motionLimit = 60.0;
    private static final int secondaryRayCount = 5;

    public ExplosionIC2(World world, Entity entity, double x, double y, double z, float power1, float drop) {
        this(world, entity, x, y, z, power1, drop, Type.Normal);
    }

    public ExplosionIC2(World world, Entity entity, double x, double y, double z, float power1, float drop, Type type1) {
        this(world, entity, x, y, z, power1, drop, type1, null, 0);
    }

    public ExplosionIC2(World world, Entity entity, double x, double y, double z, float power1, float drop, Type type1, EntityLivingBase igniter1, int radiationRange1) {
        super(world, entity, x, y, z, power1);
        this.worldObj = world;
        this.mapHeight = IC2.getWorldHeight(world);
        this.field_77283_e = entity;
        this.power = power1;
        this.explosionDropRate = drop;
        this.field_77284_b = x;
        this.field_77285_c = y;
        this.field_77282_d = z;
        this.type = type1;
        this.igniter = igniter1;
        this.radiationRange = radiationRange1;
    }

    public void doExplosion() {
        boolean entitiesAreInRange;
        if (this.power <= 0.0f) {
            return;
        }
        double maxDistance = (double)this.power / 0.4;
        int maxDistanceInt = (int)Math.ceil(maxDistance);
        this.chunkCache = new ChunkCache(this.worldObj, (int)this.field_77284_b - maxDistanceInt, (int)this.field_77285_c - maxDistanceInt, (int)this.field_77282_d - maxDistanceInt, (int)this.field_77284_b + maxDistanceInt, (int)this.field_77285_c + maxDistanceInt, (int)this.field_77282_d + maxDistanceInt, 0);
        List entities = this.worldObj.func_72839_b(null, AxisAlignedBB.func_72332_a().func_72299_a(this.field_77284_b - maxDistance, this.field_77285_c - maxDistance, this.field_77282_d - maxDistance, this.field_77284_b + maxDistance, this.field_77285_c + maxDistance, this.field_77282_d + maxDistance));
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase) && !(entity instanceof EntityItem)) continue;
            this.entitiesInRange.add(new AbstractMap.SimpleEntry<Integer, Entity>((int)((entity.field_70165_t - this.field_77284_b) * (entity.field_70165_t - this.field_77284_b) + (entity.field_70163_u - this.field_77285_c) * (entity.field_70163_u - this.field_77285_c) + (entity.field_70161_v - this.field_77282_d) * (entity.field_70161_v - this.field_77282_d)), entity));
        }
        boolean bl = entitiesAreInRange = !this.entitiesInRange.isEmpty();
        if (entitiesAreInRange) {
            Collections.sort(this.entitiesInRange, new Comparator<Map.Entry<Integer, Entity>>(){

                @Override
                public int compare(Map.Entry<Integer, Entity> a, Map.Entry<Integer, Entity> b) {
                    return a.getKey() - b.getKey();
                }
            });
        }
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / maxDistance));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double d = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                this.shootRay(this.field_77284_b, this.field_77285_c, this.field_77282_d, d, theta, this.power, entitiesAreInRange && phi_n % 8 == 0 && theta_n % 8 == 0);
            }
        }
        for (Map.Entry<Integer, Entity> entry : this.entitiesInRange) {
            Entity entity = entry.getValue();
            double motionSq = entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y;
            if (!(motionSq > 3600.0)) continue;
            double reduction = Math.sqrt(3600.0 / motionSq);
            entity.field_70159_w *= reduction;
            entity.field_70181_x *= reduction;
            entity.field_70179_y *= reduction;
        }
        if (this.isNuclear() && this.radiationRange >= 1) {
            for (EntityLiving entity : this.worldObj.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a(this.field_77284_b - (double)this.radiationRange, this.field_77285_c - (double)this.radiationRange, this.field_77282_d - (double)this.radiationRange, this.field_77284_b + (double)this.radiationRange, this.field_77285_c + (double)this.radiationRange, this.field_77282_d + (double)this.radiationRange))) {
                if (ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)entity)) continue;
                double d = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d);
                int hungerLength = (int)(120.0 * ((double)this.radiationRange - d));
                int poisonLength = (int)(80.0 * ((double)(this.radiationRange / 3) - d));
                if (hungerLength >= 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, hungerLength, 0));
                }
                if (poisonLength < 0) continue;
                IC2Potion.radiation.applyTo((EntityLivingBase)entity, poisonLength, 0);
            }
        }
        IC2.network.get().initiateExplosionEffect(this.worldObj, this.field_77284_b, this.field_77285_c, this.field_77282_d);
        HashMap blocksToDrop = new HashMap();
        for (Map.Entry<ChunkPosition, Boolean> entry : this.destroyedBlockPositions.entrySet()) {
            int x = entry.getKey().field_151329_a;
            int y = entry.getKey().field_151327_b;
            int z = entry.getKey().field_151328_c;
            Block block = this.chunkCache.func_147439_a(x, y, z);
            if (entry.getValue().booleanValue()) {
                double effectX = (float)x + this.worldObj.field_73012_v.nextFloat();
                double effectY = (float)y + this.worldObj.field_73012_v.nextFloat();
                double effectZ = (float)z + this.worldObj.field_73012_v.nextFloat();
                double d3 = effectX - this.field_77284_b;
                double d4 = effectY - this.field_77285_c;
                double d5 = effectZ - this.field_77282_d;
                double effectDistance = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= effectDistance;
                d4 /= effectDistance;
                d5 /= effectDistance;
                double d7 = 0.5 / (effectDistance / (double)this.power + 0.1);
                this.worldObj.func_72869_a("explode", (effectX + this.field_77284_b) / 2.0, (effectY + this.field_77285_c) / 2.0, (effectZ + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                this.worldObj.func_72869_a("smoke", effectX, effectY, effectZ, d3, d4, d5);
                int meta = this.worldObj.func_72805_g(x, y, z);
                for (ItemStack itemStack : block.getDrops(this.worldObj, x, y, z, meta, 0)) {
                    ItemStackWrapper isw;
                    Map map;
                    if (!(this.worldObj.field_73012_v.nextFloat() <= this.explosionDropRate)) continue;
                    XZposition xZposition = new XZposition(x / 2, z / 2);
                    if (!blocksToDrop.containsKey(xZposition)) {
                        blocksToDrop.put(xZposition, new HashMap());
                    }
                    if (!(map = (Map)blocksToDrop.get(xZposition)).containsKey(isw = new ItemStackWrapper(itemStack))) {
                        map.put(isw, new DropData(itemStack.field_77994_a, y));
                        continue;
                    }
                    map.put(isw, ((DropData)map.get(isw)).add(itemStack.field_77994_a, y));
                }
            }
            this.worldObj.func_147468_f(x, y, z);
            block.func_149723_a(this.worldObj, x, y, z, (Explosion)this);
        }
        for (Map.Entry<Object, Boolean> entry : blocksToDrop.entrySet()) {
            XZposition xZposition = (XZposition)entry.getKey();
            for (Map.Entry entry2 : ((Map)((Object)entry.getValue())).entrySet()) {
                int stackSize;
                ItemStackWrapper isw = (ItemStackWrapper)entry2.getKey();
                for (int count = ((DropData)entry2.getValue()).n; count > 0; count -= stackSize) {
                    stackSize = Math.min(count, 64);
                    EntityItem entityitem = new EntityItem(this.worldObj, (double)((float)xZposition.x + this.worldObj.field_73012_v.nextFloat()) * 2.0, (double)((DropData)entry2.getValue()).maxY + 0.5, (double)((float)xZposition.z + this.worldObj.field_73012_v.nextFloat()) * 2.0, StackUtil.copyWithSize(isw.stack, stackSize));
                    entityitem.field_145804_b = 10;
                    this.worldObj.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    public void destroy(int x, int y, int z) {
        ChunkPosition position = new ChunkPosition(x, y, z);
        if (!this.destroyedBlockPositions.containsKey(position)) {
            this.destroyedBlockPositions.put(position, true);
        }
    }

    private void shootRay(double x, double y, double z, double phi, double theta, double power1, boolean killEntities) {
        int blockY;
        double deltaX = Math.sin(theta) * Math.cos(phi);
        double deltaY = Math.cos(theta);
        double deltaZ = Math.sin(theta) * Math.sin(phi);
        int step = 0;
        while ((blockY = Util.roundToNegInf(y)) >= 0 && blockY < this.mapHeight) {
            int blockZ;
            int blockX = Util.roundToNegInf(x);
            Block block = this.chunkCache.func_147439_a(blockX, blockY, blockZ = Util.roundToNegInf(z));
            double absorption = this.getAbsorption(block, blockX, blockY, blockZ);
            if (absorption > 1000.0 && !ExplosionWhitelist.isBlockWhitelisted(block)) {
                absorption = 0.5;
            } else {
                if (absorption > power1) break;
                if (!block.isAir((IBlockAccess)this.worldObj, blockX, blockY, blockZ)) {
                    ChunkPosition position = new ChunkPosition(blockX, blockY, blockZ);
                    if (power1 > 8.0) {
                        this.destroyedBlockPositions.put(position, false);
                    } else if (!this.destroyedBlockPositions.containsKey(position)) {
                        this.destroyedBlockPositions.put(position, true);
                    }
                }
            }
            if (killEntities && (step + 4) % 8 == 0 && !this.entitiesInRange.isEmpty() && power1 >= 0.25) {
                int index;
                if (step != 4) {
                    int distanceMin = step * step - 25;
                    int indexStart = 0;
                    int indexEnd = this.entitiesInRange.size() - 1;
                    do {
                        int distance;
                        if ((distance = this.entitiesInRange.get(index = (indexStart + indexEnd) / 2).getKey().intValue()) < distanceMin) {
                            indexStart = index + 1;
                            continue;
                        }
                        indexEnd = distance > distanceMin ? index - 1 : index;
                    } while (indexStart < indexEnd);
                } else {
                    index = 0;
                }
                int distanceMax = step * step + 25;
                for (int i = index; i < this.entitiesInRange.size() && this.entitiesInRange.get(index).getKey() < distanceMax; ++i) {
                    Entity entity = this.entitiesInRange.get(index).getValue();
                    if (!((entity.field_70165_t - x) * (entity.field_70165_t - x) + (entity.field_70163_u - y) * (entity.field_70163_u - y) + (entity.field_70161_v - z) * (entity.field_70161_v - z) <= 25.0)) continue;
                    entity.func_70097_a(this.getDamageSource(), (float)((int)(32.0 * power1 / 8.0)));
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer entityPlayer = (EntityPlayer)entity;
                        if (this.isNuclear() && this.igniter != null && entityPlayer == this.igniter && entityPlayer.func_110143_aJ() <= 0.0f) {
                            IC2.achievements.issueAchievement(entityPlayer, "dieFromOwnNuke");
                        }
                    }
                    double dx = entity.field_70165_t - this.field_77284_b;
                    double dy = entity.field_70163_u - this.field_77285_c;
                    double dz = entity.field_70161_v - this.field_77282_d;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    entity.field_70159_w += dx / distance * 0.7 * power1 / 8.0;
                    entity.field_70181_x += dy / distance * 0.7 * power1 / 8.0;
                    entity.field_70179_y += dz / distance * 0.7 * power1 / 8.0;
                    if (entity.func_70089_S()) continue;
                    this.entitiesInRange.remove(i);
                    --i;
                }
            }
            if (absorption > 10.0) {
                for (int i = 0; i < 5; ++i) {
                    this.shootRay(x, y, z, this.ExplosionRNG.nextDouble() * 2.0 * Math.PI, this.ExplosionRNG.nextDouble() * Math.PI, absorption * 0.4, false);
                }
            }
            power1 -= absorption;
            x += deltaX;
            y += deltaY;
            z += deltaZ;
            ++step;
        }
    }

    private double getAbsorption(Block block, int x, int y, int z) {
        double ret = 0.5;
        if (block.isAir((IBlockAccess)this.worldObj, x, y, z)) {
            return ret;
        }
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && this.type != Type.Normal) {
            ret += 1.0;
        } else {
            double extra = (double)(block.getExplosionResistance(this.field_77283_e, this.worldObj, x, y, z, this.field_77284_b, this.field_77285_c, this.field_77282_d) + 4.0f) * 0.3;
            ret = this.type != Type.Heat ? (ret += extra) : (ret += extra * 6.0);
        }
        return ret;
    }

    public EntityLivingBase func_94613_c() {
        return this.igniter;
    }

    private DamageSource getDamageSource() {
        if (this.isNuclear()) {
            return IC2DamageSource.setNukeSource(this);
        }
        return DamageSource.func_94539_a((Explosion)this);
    }

    private boolean isNuclear() {
        return this.type == Type.Nuclear;
    }

    public static enum Type {
        Normal,
        Heat,
        Nuclear;

    }

    private static class DropData {
        int n;
        int maxY;

        DropData(int n1, int y) {
            this.n = n1;
            this.maxY = y;
        }

        public DropData add(int n1, int y) {
            this.n += n1;
            if (y > this.maxY) {
                this.maxY = y;
            }
            return this;
        }
    }

    private static class XZposition {
        int x;
        int z;

        XZposition(int x1, int z1) {
            this.x = x1;
            this.z = z1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XZposition) {
                XZposition xZposition = (XZposition)obj;
                return xZposition.x == this.x && xZposition.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return this.x * 31 ^ this.z;
        }
    }
}

