/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.WorldData;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.item.tool.ItemNanoSaber;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.world.World;

public class TickHandler {
    public TickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.START) {
            IC2.platform.profilerStartSection("Wind");
            WorldData.get((World)world).windSim.updateWind();
            IC2.platform.profilerEndStartSection("TickCallbacks");
            TickHandler.processTickCallbacks(world);
            if (IC2.disableEnderChest && IC2.platform.isSimulating()) {
                IC2.platform.profilerEndStartSection("EnderChestCheck");
                for (int i = 0; i < world.field_147482_g.size(); ++i) {
                    TileEntity te = (TileEntity)world.field_147482_g.get(i);
                    if (!(te instanceof TileEntityEnderChest) || te.func_145837_r() || !world.func_72899_e(te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
                    world.func_147468_f(te.field_145851_c, te.field_145848_d, te.field_145849_e);
                    IC2.log.info("Removed vanilla ender chest at " + te.field_145851_c + "/" + te.field_145848_d + "/" + te.field_145849_e + " (dim " + world.field_73011_w.field_76574_g + ").");
                }
            }
            IC2.platform.profilerEndSection();
        } else {
            IC2.platform.profilerStartSection("EnergyNet");
            EnergyNetGlobal.onTickEnd(world);
            IC2.platform.profilerEndStartSection("Networking");
            IC2.network.get().onTickEnd(world);
            IC2.platform.profilerEndSection();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++IC2.textureIndex.t;
            ++ItemNanoSaber.ticker;
            IC2.getInstance().tickrateTracker.onTickStart();
        } else {
            IC2.getInstance().tickrateTracker.onTickEnd();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IC2.platform.profilerStartSection("Keyboard");
            IC2.keyboard.sendKeyUpdate();
            IC2.platform.profilerEndStartSection("AudioManager");
            IC2.audioManager.onTick();
            IC2.platform.profilerEndStartSection("TickCallbacks");
            if (IC2.platform.getPlayerInstance() != null && IC2.platform.getPlayerInstance().field_70170_p != null) {
                TickHandler.processTickCallbacks(IC2.platform.getPlayerInstance().field_70170_p);
            }
            IC2.platform.profilerEndSection();
            IC2.platform.jr();
        }
    }

    public void addSingleTickCallback(World world, ITickCallback tickCallback) {
        WorldData worldData = WorldData.get(world);
        worldData.singleTickCallbacks.add(tickCallback);
    }

    public void addContinuousTickCallback(World world, ITickCallback tickCallback) {
        WorldData worldData = WorldData.get(world);
        if (!worldData.continuousTickCallbacksInUse) {
            worldData.continuousTickCallbacks.add(tickCallback);
        } else {
            worldData.continuousTickCallbacksToRemove.remove(tickCallback);
            worldData.continuousTickCallbacksToAdd.add(tickCallback);
        }
    }

    public void removeContinuousTickCallback(World world, ITickCallback tickCallback) {
        WorldData worldData = WorldData.get(world);
        if (!worldData.continuousTickCallbacksInUse) {
            worldData.continuousTickCallbacks.remove(tickCallback);
        } else {
            worldData.continuousTickCallbacksToAdd.remove(tickCallback);
            worldData.continuousTickCallbacksToRemove.add(tickCallback);
        }
    }

    private static void processTickCallbacks(World world) {
        WorldData worldData = WorldData.get(world);
        IC2.platform.profilerStartSection("SingleTickCallback");
        ITickCallback tickCallback = worldData.singleTickCallbacks.poll();
        while (tickCallback != null) {
            IC2.platform.profilerStartSection(tickCallback.getClass().getName());
            tickCallback.tickCallback(world);
            IC2.platform.profilerEndSection();
            tickCallback = worldData.singleTickCallbacks.poll();
        }
        IC2.platform.profilerEndStartSection("ContTickCallback");
        worldData.continuousTickCallbacksInUse = true;
        for (ITickCallback tickCallback2 : worldData.continuousTickCallbacks) {
            IC2.platform.profilerStartSection(tickCallback2.getClass().getName());
            tickCallback2.tickCallback(world);
            IC2.platform.profilerEndSection();
        }
        worldData.continuousTickCallbacksInUse = false;
        worldData.continuousTickCallbacks.addAll(worldData.continuousTickCallbacksToAdd);
        worldData.continuousTickCallbacksToAdd.clear();
        worldData.continuousTickCallbacks.removeAll(worldData.continuousTickCallbacksToRemove);
        worldData.continuousTickCallbacksToRemove.clear();
        IC2.platform.profilerEndSection();
    }
}

