/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.registry.GameData;
import ic2.core.IC2;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockWall;
import ic2.core.block.IObscurable;
import ic2.core.block.TileEntityBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityWall
extends TileEntityBlock
implements IObscurable {
    public Block[] retextureRef;
    public int[] retextureRefMeta;
    public int[] retextureRefSide;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        String[] parts;
        super.func_145839_a(nbttagcompound);
        String retextureRefStr = nbttagcompound.func_74779_i("retextureRef");
        if (!retextureRefStr.isEmpty() && (parts = retextureRefStr.split(":")).length == 6) {
            this.retextureRef = new Block[6];
            for (int i = 0; i < 6; ++i) {
                if (parts[i].isEmpty()) continue;
                this.retextureRef[i] = (Block)GameData.blockRegistry.func_82594_a(parts[i]);
            }
            this.retextureRefMeta = nbttagcompound.func_74759_k("retextureRefMeta");
            this.retextureRefSide = nbttagcompound.func_74759_k("retextureRefSide");
        }
        if (this.retextureRef.length != 6) {
            this.retextureRef = null;
        }
        if (this.retextureRefMeta.length != 6) {
            this.retextureRefMeta = null;
        }
        if (this.retextureRefSide.length != 6) {
            this.retextureRefSide = null;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.retextureRef != null) {
            StringBuilder sb = new StringBuilder();
            for (Block block : this.retextureRef) {
                if (block != null) {
                    sb.append(GameData.blockRegistry.func_148750_c((Object)block));
                }
                sb.append(':');
            }
            nbttagcompound.func_74778_a("retextureRef", sb.substring(0, sb.length() - 1));
            nbttagcompound.func_74783_a("retextureRefMeta", this.retextureRefMeta);
            nbttagcompound.func_74783_a("retextureRefSide", this.retextureRefSide);
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("retextureRef");
        ret.add("retextureRefMeta");
        ret.add("retextureRefSide");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("retextureRef") || field.equals("retextureRefMeta") || field.equals("retextureRefSide")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public boolean retexture(int side, Block referencedBlock, int referencedMeta, int referencedSide) {
        boolean ret = false;
        boolean updateAll = false;
        if (this.retextureRef == null) {
            this.retextureRef = new Block[6];
            this.retextureRefMeta = new int[6];
            this.retextureRefSide = new int[6];
            updateAll = true;
        }
        if (this.retextureRef[side] != referencedBlock || updateAll) {
            this.retextureRef[side] = referencedBlock;
            IC2.network.get().updateTileEntityField(this, "retextureRef");
            ret = true;
        }
        if (this.retextureRefMeta[side] != referencedMeta || updateAll) {
            this.retextureRefMeta[side] = referencedMeta;
            IC2.network.get().updateTileEntityField(this, "retextureRefMeta");
            ret = true;
        }
        if (this.retextureRefSide[side] != referencedSide || updateAll) {
            this.retextureRefSide[side] = referencedSide;
            IC2.network.get().updateTileEntityField(this, "retextureRefSide");
            ret = true;
        }
        return ret;
    }

    @Override
    public Block getReferencedBlock(int side) {
        if (this.retextureRef != null && this.retextureRef[side] != null && this.retextureRefMeta != null && this.retextureRefSide != null) {
            return this.retextureRef[side];
        }
        return null;
    }

    @Override
    public void setColorMultiplier(int colorMultiplier) {
        ((BlockWall)this.func_145838_q()).colorMultiplier = colorMultiplier;
    }

    @Override
    public void setRenderMask(int mask) {
        ((BlockMultiID)this.func_145838_q()).renderMask = mask;
    }
}

