/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.ContainerAdvMiner;
import ic2.core.block.machine.gui.GuiAdvMiner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.item.IUpgradeItem;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityAdvMiner
extends TileEntityElectricMachine
implements IHasGui,
INetworkClientTileEntityEventListener,
IUpgradableBlock {
    private int workTick = 1;
    public final int defaultTier;
    public final int defaultworkTick;
    public boolean blacklist = true;
    public int energyConsume = 512;
    private int xcounter = -1;
    private int zcounter = -1;
    private int minelayer = -1;
    private int minetargetX = -1;
    private int minetargetZ = -1;
    private short ticker = 0;
    public final InvSlotConsumableId scannerSlot = new InvSlotConsumableId((TileEntityInventory)this, "scanner", 1, InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.odScanner.func_77973_b(), Ic2Items.ovScanner.func_77973_b());
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
    public final InvSlot ListSlot = new InvSlot(this, "list", 8, null, 15);

    public TileEntityAdvMiner() {
        super(4000000, 2, 0);
        this.defaultTier = 2;
        this.defaultworkTick = 20;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            if (this.minelayer < 0) {
                this.minelayer = this.field_145848_d - 1;
            }
            this.setUpgradestat();
        }
    }

    private void chargeTool() {
        if (!this.scannerSlot.isEmpty()) {
            this.energy -= (double)ElectricItem.manager.charge(this.scannerSlot.get(), (int)this.energy, 2, false, false);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.chargeTool();
        if (this.work()) {
            this.func_70296_d();
            if (!this.getActive()) {
                this.setActive(true);
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
    }

    private boolean work() {
        if (this.energy < (double)this.energyConsume) {
            return false;
        }
        if (!this.isRedstonePowered()) {
            return false;
        }
        if (this.minelayer == 0) {
            return false;
        }
        if (this.scannerSlot.isEmpty()) {
            return false;
        }
        if (this.scannerSlot.get().func_77973_b() instanceof ItemScanner && !((ItemScanner)this.scannerSlot.get().func_77973_b()).haveChargeforScan(this.scannerSlot.get())) {
            return false;
        }
        int range = 0;
        if (this.ticker == this.workTick) {
            Block block;
            if (this.scannerSlot.get().func_77973_b() == Ic2Items.odScanner.func_77973_b()) {
                range = 16;
            }
            if (this.scannerSlot.get().func_77973_b() == Ic2Items.ovScanner.func_77973_b()) {
                range = 32;
            }
            if (this.xcounter == -1) {
                this.xcounter = range;
            }
            if (this.zcounter == -1) {
                this.zcounter = range;
            }
            if (this.xcounter > 0) {
                if (this.zcounter > 0) {
                    this.minetargetX = this.field_145851_c - range / 2 + this.xcounter;
                    this.minetargetZ = this.field_145849_e - range / 2 + this.zcounter;
                    --this.zcounter;
                } else {
                    this.minetargetX = this.field_145851_c - range / 2 + this.xcounter;
                    this.minetargetZ = this.field_145849_e - range / 2 + this.zcounter;
                    --this.xcounter;
                    this.zcounter = range;
                }
            } else {
                --this.minelayer;
                this.xcounter = range;
            }
            if (this.scannerSlot.get().func_77973_b() instanceof ItemScanner) {
                ((ItemScanner)this.scannerSlot.get().func_77973_b()).discharge(this.scannerSlot.get(), 32);
            }
            if ((block = this.field_145850_b.func_147439_a(this.minetargetX, this.minelayer, this.minetargetZ)).isAir((IBlockAccess)this.field_145850_b, this.minetargetX, this.minelayer, this.minetargetZ) && this.canMine(this.minetargetX, this.minelayer, this.minetargetZ, block)) {
                this.doMine(block);
            }
            this.ticker = 0;
        } else {
            this.ticker = (short)(this.ticker + 1);
        }
        return true;
    }

    public void doMine(Block block) {
        StackUtil.distributeDrop(this, block.getDrops(this.field_145850_b, this.minetargetX, this.minelayer, this.minetargetZ, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ), 0));
        this.field_145850_b.func_147468_f(this.minetargetX, this.minelayer, this.minetargetZ);
        this.energy -= (double)this.energyConsume;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMine(int x, int y, int z, Block block) {
        if (block instanceof IFluidBlock) {
            return false;
        }
        if (block.func_149712_f(this.field_145850_b, x, y, z) < 0.0f) {
            return false;
        }
        ArrayList itemstack = block.getDrops(this.field_145850_b, this.minetargetX, this.minelayer, this.minetargetZ, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ), 0);
        if (itemstack.isEmpty()) return false;
        if (this.blacklist) {
            for (int i = 0; i < this.ListSlot.size(); ++i) {
                if (this.ListSlot.get(i) == null || !StackUtil.isStackEqual((ItemStack)itemstack.get(0), this.ListSlot.get(i))) continue;
                return false;
            }
            return true;
        } else {
            for (int i = 0; i < this.ListSlot.size(); ++i) {
                if (this.ListSlot.get(i) == null || !StackUtil.isStackEqual((ItemStack)itemstack.get(0), this.ListSlot.get(i))) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.minelayer = nbtTagCompound.func_74762_e("minelayer");
        this.xcounter = nbtTagCompound.func_74762_e("xcounter");
        this.zcounter = nbtTagCompound.func_74762_e("zcounter");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("minelayer", this.minelayer);
        nbtTagCompound.func_74768_a("xcounter", this.xcounter);
        nbtTagCompound.func_74768_a("zcounter", this.zcounter);
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                if (this.getActive()) break;
                this.minelayer = this.field_145848_d - 1;
                this.xcounter = -1;
                this.zcounter = -1;
                break;
            }
            case 1: {
                if (this.getActive()) break;
                this.blacklist = !this.blacklist;
            }
        }
    }

    public void setUpgradestat() {
        int extraTier = 0;
        double processTimeMultiplier = 1.0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(stack, this), stack.field_77994_a);
        }
        this.setTier(TileEntityAdvMiner.applyModifier(this.defaultTier, extraTier, 1.0));
        this.workTick = Math.round((double)this.defaultworkTick * processTimeMultiplier) < 1L ? 1 : (int)Math.round((double)this.defaultworkTick * processTimeMultiplier);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerAdvMiner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiAdvMiner(new ContainerAdvMiner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public int getOutputSize() {
        return 0;
    }

    @Override
    public ItemStack getOutput(int index) {
        return null;
    }

    @Override
    public void setOutput(int index, ItemStack stack) {
    }

    @Override
    public String func_145825_b() {
        return "AdvMiner";
    }

    public int getminelayer() {
        return this.minelayer;
    }
}

