/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.block.invslot.InvSlotProcessableSmelting;
import ic2.core.block.machine.ContainerInduction;
import ic2.core.block.machine.gui.GuiInduction;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityInduction
extends TileEntityElectricMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(64);
    public static short maxHeat = (short)10000;
    public short heat = 0;
    public short progress = 0;
    public final InvSlotProcessable inputSlotA = new InvSlotProcessableSmelting(this, "inputA", 0, 1);
    public final InvSlotProcessable inputSlotB = new InvSlotProcessableSmelting(this, "inputB", 1, 1);
    public final InvSlotOutput outputSlotA = new InvSlotOutput(this, "outputA", 3, 1);
    public final InvSlotOutput outputSlotB = new InvSlotOutput(this, "outputB", 4, 1);

    public TileEntityInduction() {
        super(maxHeat, 2, 2);
    }

    @Override
    public String func_145825_b() {
        if (IC2.platform.isRendering()) {
            return "Induction Furnace";
        }
        return "InductionFurnace";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74765_d("heat");
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("heat", this.heat);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public String getHeat() {
        return "" + this.heat * 100 / maxHeat + "%";
    }

    public int gaugeProgressScaled(int i) {
        return i * this.progress / 4000;
    }

    public int gaugeFuelScaled(int i) {
        return (int)((double)i * Math.min(this.energy, (double)this.maxEnergy) / (double)this.maxEnergy);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean newActive = this.getActive();
        if (this.heat == 0) {
            newActive = false;
        }
        if (this.progress >= 4000) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
        }
        boolean canOperate = this.canOperate();
        if (this.energy > 0.0 && (canOperate || this.isRedstonePowered())) {
            this.energy -= 1.0;
            if (this.heat < maxHeat) {
                this.heat = (short)(this.heat + 1);
            }
            newActive = true;
        } else {
            this.heat = (short)(this.heat - Math.min(this.heat, 4));
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= 15.0) {
                    newActive = true;
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < 15.0) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive && canOperate) {
            this.progress = (short)(this.progress + this.heat / 30);
            this.energy -= 15.0;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void operate() {
        this.operate(this.inputSlotA, this.outputSlotA);
        this.operate(this.inputSlotB, this.outputSlotB);
    }

    public void operate(InvSlotProcessable inputSlot, InvSlotOutput outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        outputSlot.add(inputSlot.process().items);
        inputSlot.consume();
    }

    public boolean canOperate() {
        return this.canOperate(this.inputSlotA, this.outputSlotA) || this.canOperate(this.inputSlotB, this.outputSlotB);
    }

    public boolean canOperate(InvSlotProcessable inputSlot, InvSlotOutput outputSlot) {
        if (inputSlot.isEmpty()) {
            return false;
        }
        RecipeOutput output = inputSlot.process();
        if (output == null) {
            return false;
        }
        return outputSlot.canAdd(output.items);
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerInduction(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiInduction(new ContainerInduction(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }
}

