/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.ContainerPump;
import ic2.core.block.machine.gui.GuiPump;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.item.IUpgradeItem;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityPump
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock {
    private int Fluidid;
    public final int defaultTier;
    public int energyConsume = 1;
    public int operationsPerTick;
    public final int defaultEnergyStorage;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    private AudioSource audioSource;
    private int lastX;
    private int lastY;
    private int lastZ;
    private TileEntityMiner miner = null;
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 0, 1);
    public final InvSlotConsumableLiquid containerSlot = new InvSlotConsumableLiquid(this, "containerSlot", 1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, "output", 2, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
    public short progress = 0;
    public int operationLength = 20;
    public float serverProgress;

    public TileEntityPump() {
        super(20, 1, 1, 8);
        this.defaultEnergyConsume = 1;
        this.defaultOperationLength = 20;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 1 * this.operationLength;
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        this.miner = null;
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        MutableObject output;
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.canoperate() && this.energy >= (double)(this.energyConsume * this.operationLength)) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
                this.energy -= (double)this.energyConsume;
            } else {
                this.progress = 0;
                this.operate(false);
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    @Override
    public String func_145825_b() {
        return "Pump";
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.miner == null || this.miner.func_145837_r()) {
            this.miner = null;
            for (Direction dir : Direction.values()) {
                TileEntity te;
                if (dir == Direction.YP || !((te = dir.applyToTileEntity(this)) instanceof TileEntityMiner)) continue;
                this.miner = (TileEntityMiner)te;
                break;
            }
        }
        FluidStack liquid = null;
        if (this.miner != null) {
            if (this.miner.canProvideLiquid) {
                liquid = this.pump(this.miner.liquidX, this.miner.liquidY, this.miner.liquidZ, sim);
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                liquid = this.pump(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, sim);
                if (liquid != null) break;
            }
        }
        if (liquid != null && this.getFluidTank().fill(liquid, false) > 0) {
            if (!sim) {
                this.getFluidTank().fill(liquid, true);
                this.clearLastBlock();
            }
            return true;
        }
        return false;
    }

    public void clearLastBlock() {
        this.field_145850_b.func_147468_f(this.lastX, this.lastY, this.lastZ);
    }

    public FluidStack pump(int x, int y, int z, boolean sim) {
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        FluidStack ret = null;
        if (block instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)block;
            if (liquid.canDrain(this.field_145850_b, x, y, z)) {
                ret = !sim ? liquid.drain(this.field_145850_b, x, y, z, true) : new FluidStack(liquid.getFluid(), 1000);
            }
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            if (this.field_145850_b.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new FluidStack(FluidRegistry.WATER, 1000);
        } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            if (this.field_145850_b.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            extraProcessTime += upgrade.getExtraProcessTime(stack, this) * stack.field_77994_a;
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(stack, this), stack.field_77994_a);
            extraEnergyDemand += upgrade.getExtraEnergyDemand(stack, this) * stack.field_77994_a;
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(stack, this), stack.field_77994_a);
            extraEnergyStorage += upgrade.getExtraEnergyStorage(stack, this) * stack.field_77994_a;
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(stack, this), stack.field_77994_a);
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
        }
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)extraProcessTime) * 64.0 * processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityPump.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.setTier(TileEntityPump.applyModifier(this.defaultTier, extraTier, 1.0));
        this.maxEnergy = TileEntityPump.applyModifier(this.defaultEnergyStorage, extraEnergyStorage + this.operationLength * this.energyConsume, energyStorageMultiplier);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public int getOutputSize() {
        return this.outputSlot.size();
    }

    @Override
    public ItemStack getOutput(int index) {
        return this.outputSlot.get(index);
    }

    @Override
    public void setOutput(int index, ItemStack stack) {
        this.outputSlot.put(index, stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public float getProgress() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setProgress(float progress1) {
        assert (!IC2.platform.isSimulating());
        this.serverProgress = progress1;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPump(new ContainerPump(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public int getFluidid() {
        return this.Fluidid;
    }

    public void setFluidid(int fluidid) {
        this.Fluidid = fluidid;
    }
}

