/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IPatternStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.ContainerReplicator;
import ic2.core.block.machine.gui.GuiReplicator;
import ic2.core.item.IUpgradeItem;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityReplicator
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock,
INetworkClientTileEntityEventListener {
    public int baseeuinjektion = 512;
    public short baseuuinjektion = 1;
    public double energyConsume = this.baseeuinjektion;
    public short uuinjektion = this.baseuuinjektion;
    public short progressUU = 0;
    public short progressEU = 0;
    private boolean init = true;
    public int BufferAmountUU = -1;
    public int BufferAmountEU = -1;
    public int RecipeAmountUU = -1;
    public int RecipeAmountEU = -1;
    public IPatternStorage Storage = null;
    public short index = 0;
    public short mode = 0;
    public ItemStack InfoItem = null;
    public final InvSlotConsumableLiquid fluidSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluid", 0, 1, IC2.fluidUuMatter);
    public final InvSlotOutput cellSlot = new InvSlotOutput(this, "cell", 0, 1);
    public final InvSlotOutput Output = new InvSlotOutput(this, "output", 0, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
    private static final Direction[] directions = Direction.values();

    public TileEntityReplicator() {
        super(2000000, 4, 0, 16);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.needsFluid()) {
            this.gainFluid();
        }
        if (this.Storage == null) {
            this.scanforPatternStorage();
        }
        if (this.init && this.Storage != null && this.Storage.getPatternCount() > 0) {
            this.refreshPattern(true);
            this.init = false;
        }
        if (this.mode == 0) {
            if (this.getActive()) {
                this.setActive(false);
            }
            if (this.progressUU != 0) {
                this.progressUU = 0;
            }
            if (this.progressEU != 0) {
                this.progressEU = 0;
            }
            if (this.BufferAmountUU != 0) {
                this.BufferAmountUU = 0;
            }
            if (this.BufferAmountEU != 0) {
                this.BufferAmountEU = 0;
            }
            if (this.isRedstonePowered() && this.InfoItem != null && this.energy >= this.energyConsume) {
                this.mode = 1;
            }
        } else if ((this.mode == 1 || this.mode == 2) && this.InfoItem != null && this.energy >= this.energyConsume) {
            if (!this.Output.canAdd(StackUtil.copyWithSize(this.InfoItem, 1))) {
                this.mode = 0;
            } else if (this.BufferAmountUU >= this.RecipeAmountUU && this.BufferAmountEU >= this.RecipeAmountEU) {
                this.replicateItem();
            } else {
                if (this.BufferAmountUU < this.RecipeAmountUU && this.fluidTank.getFluidAmount() >= this.uuinjektion) {
                    this.BufferAmountUU += this.fluidTank.drain((int)this.uuinjektion, (boolean)true).amount;
                    this.progressUU = (short)(this.BufferAmountUU * 100 / this.RecipeAmountUU);
                }
                if (this.BufferAmountEU < this.RecipeAmountEU) {
                    this.energy -= this.energyConsume;
                    this.BufferAmountEU += this.baseeuinjektion;
                    this.progressEU = (short)(this.BufferAmountEU * 100 / this.RecipeAmountEU);
                }
                if (this.BufferAmountEU > this.RecipeAmountEU) {
                    this.energy += (double)(this.BufferAmountEU - this.RecipeAmountEU);
                    this.BufferAmountEU = this.RecipeAmountEU;
                    this.progressEU = (short)(this.BufferAmountEU * 100 / this.RecipeAmountEU);
                }
            }
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    private void replicateItem() {
        this.Output.add(StackUtil.copyWithSize(this.InfoItem, 1));
        this.BufferAmountUU = 0;
        this.BufferAmountEU = 0;
        if (this.mode == 1) {
            this.mode = 0;
        } else {
            if (this.progressUU != 0) {
                this.progressUU = 0;
            }
            if (this.progressEU != 0) {
                this.progressEU = 0;
            }
        }
    }

    public void setUpgradestat() {
        double processTimeMultiplier = 1.0;
        double energyDemandMultiplier = 1.0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            processTimeMultiplier += (double)stack.field_77994_a;
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(stack, this), stack.field_77994_a);
        }
        this.uuinjektion = (short)TileEntityReplicator.applyModifier(this.baseuuinjektion, 0, processTimeMultiplier);
        this.energyConsume = TileEntityReplicator.applyModifier(this.baseeuinjektion, 0, energyDemandMultiplier);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiReplicator(new ContainerReplicator(entityPlayer, this));
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerReplicator(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public boolean gainFluid() {
        boolean ret = false;
        MutableObject output = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.cellSlot.canAdd((ItemStack)output.getValue()))) {
            ret = this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.cellSlot.add((ItemStack)output.getValue());
            }
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.index = nbttagcompound.func_74765_d("index");
        this.mode = nbttagcompound.func_74765_d("mode");
        this.progressUU = nbttagcompound.func_74765_d("progressUU");
        this.progressEU = nbttagcompound.func_74765_d("progressEU");
        this.BufferAmountEU = nbttagcompound.func_74762_e("BufferAmountEU");
        this.BufferAmountUU = nbttagcompound.func_74762_e("BufferAmountUU");
        NBTTagCompound contentTag = new NBTTagCompound();
        contentTag = nbttagcompound.func_74775_l("recordedStack");
        this.InfoItem = ItemStack.func_77949_a((NBTTagCompound)contentTag);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("index", this.index);
        nbttagcompound.func_74777_a("mode", this.mode);
        nbttagcompound.func_74777_a("progressUU", this.progressUU);
        nbttagcompound.func_74777_a("progressEU", this.progressEU);
        nbttagcompound.func_74768_a("BufferAmountUU", this.BufferAmountUU);
        nbttagcompound.func_74768_a("BufferAmountEU", this.BufferAmountEU);
        if (this.InfoItem != null) {
            NBTTagCompound contentTag = new NBTTagCompound();
            contentTag = nbttagcompound.func_74775_l("recordedStack");
            new ItemStack(this.InfoItem.func_77973_b(), 1).func_77955_b(contentTag);
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (this.Storage != null) {
            switch (event) {
                case 0: {
                    if (this.mode != 0) break;
                    this.index = (short)(this.index - 1);
                    if (this.index < 0) {
                        this.index = this.Storage.getPatternCount();
                    }
                    this.refreshPattern(false);
                    break;
                }
                case 1: {
                    if (this.mode != 0) break;
                    this.index = (short)(this.index + 1);
                    if (this.index > this.Storage.getPatternCount()) {
                        this.index = 0;
                    }
                    this.refreshPattern(false);
                    break;
                }
                case 3: {
                    if (this.mode == 0) break;
                    this.mode = 0;
                    break;
                }
                case 4: {
                    if (this.mode == 1) break;
                    this.mode = 1;
                    break;
                }
                case 5: {
                    if (this.mode == 2) break;
                    this.mode = (short)2;
                }
            }
        }
    }

    public void refreshPattern(boolean intit) {
        int[] Values2;
        this.InfoItem = this.Storage.getPatternItemstack(this.index);
        IC2.network.get().updateTileEntityField(this, "InfoItem");
        if (this.InfoItem != null && (Values2 = this.Storage.getPatternvalus(this.InfoItem)) != null) {
            this.RecipeAmountUU = Values2[0];
            this.RecipeAmountEU = Values2[1];
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>();
        ret.add("InfoItem");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public void scanforPatternStorage() {
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IPatternStorage)) continue;
            this.Storage = (IPatternStorage)target;
            break;
        }
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return IC2.fluidUuMatter.getID() == fluid.getID();
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_145825_b() {
        return "Replicator";
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public int getOutputSize() {
        return this.Output.size();
    }

    @Override
    public ItemStack getOutput(int index1) {
        return this.Output.get(index1);
    }

    @Override
    public void setOutput(int index1, ItemStack stack) {
        this.Output.put(index1, stack);
    }
}

