/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.personal.ContainerPersonalChest;
import ic2.core.block.personal.GuiPersonalChest;
import ic2.core.block.personal.IPersonalBlock;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileEntityPersonalChest
extends TileEntityInventory
implements IPersonalBlock,
IHasGui {
    private int ticksSinceSync;
    private int numUsingPlayers;
    public float lidAngle;
    public float prevLidAngle;
    public String owner = "null";
    public final InvSlot contentSlot = new InvSlot(this, "content", 0, InvSlot.Access.NONE, 54);

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
    }

    @Override
    public String func_145825_b() {
        return "Personal Safe";
    }

    @Override
    public boolean enableUpdateEntity() {
        return true;
    }

    public void func_145845_h() {
        double var4;
        if (++this.ticksSinceSync % 20 * 4 == 0 && IC2.platform.isSimulating()) {
            this.syncNumUsingPlayers();
        }
        this.prevLidAngle = this.lidAngle;
        float var1 = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double var2 = (double)this.field_145851_c + 0.5;
            var4 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(var2, (double)this.field_145848_d + 0.5, var4, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float var3;
            float var8 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += var1) : (this.lidAngle -= var1);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (var3 = 0.5f) && var8 >= var3) {
                var4 = (double)this.field_145851_c + 0.5;
                double var6 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(var4, (double)this.field_145848_d + 0.5, var6, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    @Override
    public void func_70305_f() {
        --this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public boolean func_145842_c(int event, int data) {
        if (event == 1) {
            this.numUsingPlayers = data;
            return true;
        }
        return false;
    }

    private void syncNumUsingPlayers() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("owner");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        if (!this.permitsAccess(entityPlayer)) {
            return false;
        }
        if (!this.contentSlot.isEmpty()) {
            IC2.platform.messagePlayer(entityPlayer, "Can't wrench non-empty safe", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean permitsAccess(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.owner.equals("null")) {
            this.owner = player.func_146103_bH().getId();
            IC2.network.get().updateTileEntityField(this, "owner");
            return true;
        }
        if (IC2.platform.isSimulating()) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (player.func_146103_bH().getId().equals(server.func_71214_G()) || server.func_71203_ab().func_72353_e(player.func_146103_bH().getId())) {
                return true;
            }
        }
        if (this.owner.equalsIgnoreCase(player.func_146103_bH().getId())) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            IC2.platform.messagePlayer(player, "This safe is owned by " + this.owner, new Object[0]);
        }
        return false;
    }

    @Override
    public boolean permitsAccess(String username) {
        return this.owner.equals(username);
    }

    @Override
    public String getUsername() {
        return this.owner;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPersonalChest(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPersonalChest(new ContainerPersonalChest(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

