/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import cpw.mods.fml.common.registry.GameData;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputFluidContainer;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import ic2.core.AdvCraftingRecipeManager;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import ic2.core.util.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Rezepte {
    public static void registerCraftingRecipes() {
        Recipes.advRecipes = new AdvCraftingRecipeManager();
        Config shapedRecipes = new Config("shaped recipes");
        Config shapelessRecipes = new Config("shapeless recipes");
        try {
            shapedRecipes.load(Rezepte.class.getResourceAsStream("/assets/ic2/config/shaped_recipes.ini"));
            shapelessRecipes.load(Rezepte.class.getResourceAsStream("/assets/ic2/config/shapeless_recipes.ini"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Rezepte.loadRecipes(shapedRecipes, true);
        Rezepte.loadRecipes(shapelessRecipes, false);
    }

    private static void loadRecipes(Config config, boolean shaped) {
        Iterator<Config.Value> it = config.valueIterator();
        while (it.hasNext()) {
            Config.Value value = it.next();
            try {
                for (String majorPart : value.getString().split("\\s*,\\s*")) {
                    boolean first = true;
                    ArrayList<Object> inputs = new ArrayList<Object>();
                    int count = 1;
                    boolean hidden = false;
                    for (String part : Rezepte.splitWhitespace(majorPart)) {
                        if (part.startsWith("@")) {
                            if (part.startsWith("@count:")) {
                                count = Integer.parseInt(part.substring(7));
                                continue;
                            }
                            if (part.equals("@hidden")) {
                                hidden = true;
                                continue;
                            }
                            throw new RuntimeException("invalid attribute: " + part);
                        }
                        if (shaped && first) {
                            first = false;
                            if (part.startsWith("\"")) {
                                if (!part.endsWith("\"")) {
                                    throw new RuntimeException("missing end quote: " + part);
                                }
                                part = part.substring(1, part.length() - 1);
                            }
                            String[] rows = part.split("\\|");
                            inputs.addAll(Arrays.asList(rows));
                            continue;
                        }
                        ArrayList<IRecipeInput> input = new ArrayList<IRecipeInput>();
                        boolean first2 = true;
                        String[] arr$ = part.split("\\s*\\|\\s*");
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            IRecipeInput cInput;
                            String subPart;
                            String ingredient = subPart = arr$[i$];
                            if (shaped && first2) {
                                first2 = false;
                                int pos = ingredient.indexOf(":");
                                if (pos != 1) {
                                    throw new RuntimeException("no valid pattern index character found: " + part);
                                }
                                inputs.add(Character.valueOf(ingredient.charAt(0)));
                                ingredient = ingredient.substring(2);
                            }
                            if ((cInput = Rezepte.getIngredient(ingredient)) == null) {
                                throw new RuntimeException("can't find ingredient for " + ingredient);
                            }
                            input.add(cInput);
                        }
                        if (input.size() == 1) {
                            inputs.add(input.get(0));
                            continue;
                        }
                        inputs.add(input);
                    }
                    ItemStack output = Rezepte.getStack(value.name, count);
                    if (output == null) {
                        throw new RuntimeException("invalid output specified: " + value.name);
                    }
                    if (hidden) {
                        inputs.add(hidden);
                    }
                    if (shaped) {
                        AdvRecipe.addAndRegister(output, inputs.toArray());
                        continue;
                    }
                    AdvShapelessRecipe.addAndRegister(output, inputs.toArray());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error parsing " + value.name + " = " + value.getString(), e);
            }
        }
    }

    private static List<String> splitWhitespace(String str) {
        String dummy = str.replaceAll("\\\\.", "xx");
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = dummy.charAt(i);
            if (c == '\"') {
                quoted = !quoted;
            }
            boolean split = false;
            if (!quoted && Character.isWhitespace(c)) {
                split = true;
            }
            if (split) {
                if (current.length() <= 0) continue;
                ret.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(str.charAt(i));
        }
        if (current.length() > 0) {
            ret.add(current.toString());
        }
        return ret;
    }

    private static ItemStack getStack(String str, int size) {
        int pos = str.indexOf(64);
        String itemName = pos == -1 ? str : str.substring(0, pos);
        Item item = (Item)GameData.itemRegistry.func_82594_a(itemName);
        if (item == null) {
            return null;
        }
        if (pos == -1) {
            return new ItemStack(item, size);
        }
        return new ItemStack(item, size, Integer.parseInt(str.substring(pos + 1)));
    }

    private static IRecipeInput getIngredient(String str) {
        String domain;
        int pos = str.indexOf(64);
        String itemName = str;
        Integer meta = null;
        if (pos != -1) {
            itemName = str.substring(0, pos);
            String metaStr = str.substring(pos + 1);
            meta = metaStr.equals("*") ? Integer.valueOf(Short.MAX_VALUE) : Integer.valueOf(Integer.parseInt(metaStr));
        }
        if ((domain = itemName.substring(0, pos = itemName.indexOf(58))).equals("OreDict")) {
            String name = itemName.substring(pos + 1);
            if (name.isEmpty()) {
                throw new RuntimeException("invalid ore dictionary specification: " + str);
            }
            return new RecipeInputOreDict(name, 1, meta);
        }
        if (domain.equals("Fluid")) {
            Fluid fluid = FluidRegistry.getFluid((String)itemName.substring(pos + 1));
            if (fluid == null) {
                return null;
            }
            return new RecipeInputFluidContainer(fluid);
        }
        Item item = (Item)GameData.itemRegistry.func_82594_a(itemName);
        if (item == null) {
            return null;
        }
        return new RecipeInputItemStack(new ItemStack(item, 1, meta == null ? 0 : meta));
    }
}

