/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorUtility;
import ic2.core.util.StackUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemArmorJetpack
extends ItemArmorUtility
implements IItemHudInfo {
    public static AudioSource audioSource;
    private static boolean lastJetpackUsed;

    public ItemArmorJetpack(InternalName internalName) {
        super(internalName, InternalName.jetpack, 1);
        this.func_77656_e(18002);
    }

    public int getCharge(ItemStack itemStack) {
        int ret = this.getMaxCharge(itemStack) - itemStack.func_77960_j() - 1;
        return ret > 0 ? ret : 0;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return itemStack.func_77958_k() - 2;
    }

    @Override
    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add("Fuel: " + this.getCharge(itemStack) * 100 / this.getMaxCharge(itemStack) + " %");
        return info;
    }

    public void use(ItemStack itemStack, int amount) {
        int newCharge = this.getCharge(itemStack) - amount;
        if (newCharge < 0) {
            newCharge = 0;
        }
        itemStack.func_77964_b(1 + itemStack.func_77958_k() - newCharge);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) == 0) {
            return false;
        }
        boolean electric = jetpack.func_77973_b() != Ic2Items.jetpack.func_77973_b();
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (electric) {
            power = 0.7f;
            dropPercentage = 0.05f;
        }
        if ((float)this.getCharge(jetpack) / (float)this.getMaxCharge(jetpack) <= dropPercentage) {
            power *= (float)this.getCharge(jetpack) / ((float)this.getMaxCharge(jetpack) * dropPercentage);
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        int worldHeight = IC2.getWorldHeight(player.field_70170_p);
        double y = player.field_70163_u;
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.1f;
            if (electric && IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 9;
        if (hoverMode) {
            consume = 6;
        }
        if (electric) {
            consume -= 2;
        }
        this.use(jetpack, consume);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.field_71071_by.field_70460_b[2] != itemStack) {
            return;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                }
            }
        }
        if (IC2.keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < (double)-0.35f) {
            jetpackUsed = this.useJetpack(player, hoverMode);
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource(player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(new ItemStack((Item)this, 1, 1));
    }

    static {
        lastJetpackUsed = false;
    }
}

