/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMetaData;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockScaffold
extends BlockMetaData {
    public static final int standardStrength = 2;
    public static final int standardIronStrength = 5;
    public static final int reinforcedStrength = 5;
    public static final int reinforcedIronStrength = 12;
    public static final int tickDelay = 1;
    private static final int textureIndexNormal = 0;
    private static final int textureIndexReinforced = 1;

    public BlockScaffold(InternalName internalName1) {
        super(internalName1, internalName1 == InternalName.blockIronScaffold ? Material.field_151573_f : Material.field_151575_d, ItemBlockIC2.class);
        if (internalName1 == InternalName.blockIronScaffold) {
            this.func_149711_c(0.8f);
            this.func_149752_b(10.0f);
            this.func_149672_a(field_149777_j);
            Ic2Items.ironScaffold = new ItemStack((Block)this);
        } else {
            this.func_149711_c(0.5f);
            this.func_149752_b(0.2f);
            this.func_149672_a(field_149766_f);
            Ic2Items.scaffold = new ItemStack((Block)this);
        }
    }

    @Override
    public String getTextureName(int index) {
        if (index == 0) {
            return this.func_149739_a();
        }
        if (index == 1) {
            return this.func_149739_a() + "." + InternalName.reinforced.name();
        }
        return null;
    }

    @Override
    public int getTextureIndex(int meta) {
        if (meta == this.getReinforcedStrength()) {
            return 1;
        }
        return 0;
    }

    public int getStandardStrength() {
        if (this.field_149764_J == Material.field_151573_f) {
            return 5;
        }
        return 2;
    }

    public int getReinforcedStrength() {
        if (this.field_149764_J == Material.field_151573_f) {
            return 12;
        }
        return 5;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int i, int j, int k) {
        return false;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.field_70143_R = 0.0f;
            if (player.field_70181_x < -0.15) {
                player.field_70181_x = -0.15;
            }
            if (IC2.keyboard.isForwardKeyDown(player) && player.field_70181_x < 0.2) {
                player.field_70181_x = 0.2;
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        float factor = 1.0f;
        float f = factor / 16.0f;
        return AxisAlignedBB.func_72330_a((double)((float)i + f), (double)j, (double)((float)k + f), (double)((float)i + factor - f), (double)((float)j + factor), (double)((float)k + factor - f));
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return side == 0 || side == 1;
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int meta, int fortune) {
        ArrayList<ItemStack> tr = new ArrayList<ItemStack>();
        tr.add(new ItemStack((Block)this, 1));
        if (meta == this.getReinforcedStrength()) {
            if (this.field_149764_J == Material.field_151573_f) {
                tr.add(new ItemStack(Ic2Items.ironFence.func_77973_b(), 1));
            }
            if (this.field_149764_J == Material.field_151575_d) {
                tr.add(new ItemStack(Items.field_151055_y, 2));
            }
        }
        return tr;
    }

    @Override
    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        ItemStack sticks = entityplayer.field_71071_by.func_70448_g();
        if (sticks == null || this.field_149764_J == Material.field_151575_d && (sticks.func_77973_b() != Items.field_151055_y || sticks.field_77994_a < 2) || this.field_149764_J == Material.field_151573_f && sticks.func_77973_b() != Ic2Items.ironFence.func_77973_b()) {
            return false;
        }
        if (world.func_72805_g(i, j, k) == this.getReinforcedStrength() || !this.isPillar(world, i, j, k)) {
            return false;
        }
        sticks.field_77994_a = this.field_149764_J == Material.field_151575_d ? (sticks.field_77994_a -= 2) : --sticks.field_77994_a;
        if (entityplayer.func_71045_bC().field_77994_a <= 0) {
            entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = null;
        }
        world.func_72921_c(i, j, k, this.getReinforcedStrength(), 7);
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (player.func_71045_bC() != null && StackUtil.equals(this, player.func_71045_bC())) {
            while (world.func_147439_a(x, y, z) == this) {
                ++y;
            }
            if (this.func_149742_c(world, x, y, z) && y < IC2.getWorldHeight(world)) {
                world.func_147465_d(x, y, z, (Block)this, 0, 7);
                this.func_149714_e(world, x, y, z, 0);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                    if (player.func_71045_bC().field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
            }
        }
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        if (this.getStrengthFrom(world, i, j, k) <= -1) {
            return false;
        }
        return super.func_149742_c(world, i, j, k);
    }

    public boolean isPillar(World world, int i, int j, int k) {
        while (world.func_147439_a(i, j, k) == this) {
            --j;
        }
        return world.func_147445_c(i, j, k, false);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.updateSupportStatus(world, x, y, z);
    }

    public void func_149714_e(World world, int i, int j, int k, int l) {
        this.func_149674_a(world, i, j, k, null);
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        int ownStrength = world.func_72805_g(i, j, k);
        if (ownStrength >= this.getReinforcedStrength()) {
            if (!this.isPillar(world, i, j, k)) {
                ownStrength = this.getStrengthFrom(world, i, j, k);
                ItemStack drop = new ItemStack(Items.field_151055_y, 2);
                if (this.field_149764_J == Material.field_151573_f) {
                    drop = new ItemStack(Ic2Items.ironFence.func_77973_b());
                }
                this.func_149642_a(world, i, j, k, drop);
            }
        } else {
            ownStrength = this.getStrengthFrom(world, i, j, k);
        }
        if (ownStrength <= -1) {
            world.func_147468_f(i, j, k);
            this.func_149642_a(world, i, j, k, new ItemStack((Block)this));
        } else if (ownStrength != world.func_72805_g(i, j, k)) {
            world.func_72921_c(i, j, k, ownStrength, 7);
            world.func_147458_c(i, j, k, i, j, k);
        }
    }

    public int getStrengthFrom(World world, int i, int j, int k) {
        int strength = 0;
        if (this.isPillar(world, i, j - 1, k)) {
            strength = this.getStandardStrength() + 1;
        }
        strength = this.compareStrengthTo(world, i, j - 1, k, strength);
        strength = this.compareStrengthTo(world, i + 1, j, k, strength);
        strength = this.compareStrengthTo(world, i - 1, j, k, strength);
        strength = this.compareStrengthTo(world, i, j, k + 1, strength);
        strength = this.compareStrengthTo(world, i, j, k - 1, strength);
        return strength - 1;
    }

    public int compareStrengthTo(World world, int i, int j, int k, int strength) {
        int s = 0;
        if (world.func_147439_a(i, j, k) == this && (s = world.func_72805_g(i, j, k)) > this.getReinforcedStrength()) {
            s = this.getReinforcedStrength();
        }
        if (s > strength) {
            return s;
        }
        return strength;
    }

    public void updateSupportStatus(World world, int i, int j, int k) {
        world.func_147464_a(i, j, k, (Block)this, 1);
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (StackUtil.equals(this, Ic2Items.scaffold)) {
            return 8;
        }
        return super.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (StackUtil.equals(this, Ic2Items.scaffold)) {
            return 20;
        }
        return super.getFlammability(world, x, y, z, face);
    }
}

