/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.crop.IC2Crops;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.item.ItemCropSeed;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityCrop
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
ICropTile {
    public short id = (short)-1;
    public byte size = 0;
    public byte statGrowth = 0;
    public byte statGain = 0;
    public byte statResistance = 0;
    public byte scanLevel = 0;
    public NBTTagCompound customData = new NBTTagCompound();
    public int nutrientStorage = 0;
    public int waterStorage = 0;
    public int exStorage = 0;
    public int growthPoints = 0;
    public boolean upgraded = false;
    public char ticker = (char)IC2.random.nextInt(tickRate);
    public boolean dirty = true;
    public static char tickRate = (char)256;
    public byte humidity = (byte)-1;
    public byte nutrients = (byte)-1;
    public byte airQuality = (byte)-1;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.id = nbttagcompound.func_74765_d("cropid");
        this.size = nbttagcompound.func_74771_c("size");
        this.statGrowth = nbttagcompound.func_74771_c("statGrowth");
        this.statGain = nbttagcompound.func_74771_c("statGain");
        this.statResistance = nbttagcompound.func_74771_c("statResistance");
        if (nbttagcompound.func_74764_b("data0")) {
            for (int x = 0; x < 16; ++x) {
                this.customData.func_74777_a("legacy" + x, nbttagcompound.func_74765_d("data" + x));
            }
        } else if (nbttagcompound.func_74764_b("customData")) {
            this.customData = nbttagcompound.func_74775_l("customData");
        }
        this.growthPoints = nbttagcompound.func_74762_e("growthPoints");
        try {
            this.nutrientStorage = nbttagcompound.func_74762_e("nutrientStorage");
            this.waterStorage = nbttagcompound.func_74762_e("waterStorage");
        }
        catch (Throwable e) {
            this.nutrientStorage = nbttagcompound.func_74771_c("nutrientStorage");
            this.waterStorage = nbttagcompound.func_74771_c("waterStorage");
        }
        this.upgraded = nbttagcompound.func_74767_n("upgraded");
        this.scanLevel = nbttagcompound.func_74771_c("scanLevel");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("cropid", this.id);
        nbttagcompound.func_74774_a("size", this.size);
        nbttagcompound.func_74774_a("statGrowth", this.statGrowth);
        nbttagcompound.func_74774_a("statGain", this.statGain);
        nbttagcompound.func_74774_a("statResistance", this.statResistance);
        nbttagcompound.func_74782_a("customData", (NBTBase)this.customData);
        nbttagcompound.func_74768_a("growthPoints", this.growthPoints);
        nbttagcompound.func_74768_a("nutrientStorage", this.nutrientStorage);
        nbttagcompound.func_74768_a("waterStorage", this.waterStorage);
        nbttagcompound.func_74757_a("upgraded", this.upgraded);
        nbttagcompound.func_74774_a("scanLevel", this.scanLevel);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.ticker = (char)(this.ticker + '\u0001');
        if (this.ticker % tickRate == 0) {
            this.tick();
        }
        if (this.dirty) {
            this.dirty = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (IC2.platform.isSimulating() && !IC2.platform.isRendering()) {
                for (String field : this.getNetworkedFields()) {
                    IC2.network.get().updateTileEntityField(this, field);
                }
            }
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> ret = new ArrayList<String>(4);
        ret.add("id");
        ret.add("size");
        ret.add("upgraded");
        ret.add("customData");
        return ret;
    }

    public void tick() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.ticker % (tickRate << 2) == 0) {
            this.humidity = this.updateHumidity();
        }
        if ((this.ticker + tickRate) % (tickRate << 2) == 0) {
            this.nutrients = this.updateNutrients();
        }
        if ((this.ticker + tickRate * 2) % (tickRate << 2) == 0) {
            this.airQuality = this.updateAirQuality();
        }
        if (!(this.id >= 0 || this.upgraded && this.attemptCrossing())) {
            if (IC2.random.nextInt(100) == 0 && !this.hasEx()) {
                this.reset();
                this.id = (short)IC2Crops.weed.getId();
                this.size = 1;
            } else {
                if (this.exStorage > 0 && IC2.random.nextInt(10) == 0) {
                    --this.exStorage;
                }
                return;
            }
        }
        this.crop().tick(this);
        if (this.crop().canGrow(this)) {
            this.growthPoints += this.calcGrowthRate();
            if (this.id > -1 && this.growthPoints >= this.crop().growthDuration(this)) {
                this.growthPoints = 0;
                this.size = (byte)(this.size + 1);
                this.dirty = true;
            }
        }
        if (this.nutrientStorage > 0) {
            --this.nutrientStorage;
        }
        if (this.waterStorage > 0) {
            --this.waterStorage;
        }
        if (this.id > -1 && this.crop().isWeed(this) && IC2.random.nextInt(50) - this.statGrowth <= 2) {
            this.generateWeed();
        }
    }

    public void generateWeed() {
        Block block;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        switch (IC2.random.nextInt(4)) {
            case 0: {
                ++x;
            }
            case 1: {
                --x;
            }
            case 2: {
                ++z;
            }
            case 3: {
                --z;
            }
        }
        if (this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)this.field_145850_b.func_147438_o(x, y, z);
            if (crop.id == -1 || !crop.crop().isWeed(crop) && IC2.random.nextInt(32) >= crop.statResistance && !crop.hasEx()) {
                byte newGrowth = this.statGrowth;
                if (crop.statGrowth > newGrowth) {
                    newGrowth = crop.statGrowth;
                }
                if (newGrowth < 31 && IC2.random.nextBoolean()) {
                    newGrowth = (byte)(newGrowth + 1);
                }
                crop.reset();
                crop.id = 0;
                crop.size = 1;
                crop.statGrowth = newGrowth;
            }
        } else if (this.field_145850_b.func_147437_c(x, y, z) && ((block = this.field_145850_b.func_147439_a(x, y - 1, z)) == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak)) {
            this.field_145850_b.func_147465_d(x, y - 1, z, (Block)Blocks.field_150349_c, 0, 7);
            this.field_145850_b.func_147465_d(x, y, z, (Block)Blocks.field_150329_H, 1, 7);
        }
    }

    public boolean hasEx() {
        if (this.exStorage > 0) {
            this.exStorage -= 5;
            return true;
        }
        return false;
    }

    public boolean attemptCrossing() {
        int i;
        if (IC2.random.nextInt(3) != 0) {
            return false;
        }
        LinkedList<TileEntityCrop> crops = new LinkedList<TileEntityCrop>();
        this.askCropJoinCross(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, crops);
        this.askCropJoinCross(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, crops);
        this.askCropJoinCross(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, crops);
        this.askCropJoinCross(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, crops);
        if (crops.size() < 2) {
            return false;
        }
        int[] ratios = new int[256];
        for (int i2 = 1; i2 < ratios.length; ++i2) {
            CropCard crop = Crops.instance.getCropList()[i2];
            if (crop == null || !crop.canGrow(this)) continue;
            for (int j = 0; j < crops.size(); ++j) {
                int n = i2;
                ratios[n] = ratios[n] + this.calculateRatioFor(crop, crops.get(j).crop());
            }
        }
        int total = 0;
        for (i = 0; i < ratios.length; ++i) {
            total += ratios[i];
        }
        total = IC2.random.nextInt(total);
        for (i = 0; i < ratios.length; ++i) {
            if (ratios[i] > 0 && ratios[i] > total) {
                total = i;
                break;
            }
            total -= ratios[i];
        }
        this.upgraded = false;
        this.id = (short)total;
        this.dirty = true;
        this.size = 1;
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        for (i = 0; i < crops.size(); ++i) {
            this.statGrowth = (byte)(this.statGrowth + crops.get((int)i).statGrowth);
            this.statResistance = (byte)(this.statResistance + crops.get((int)i).statResistance);
            this.statGain = (byte)(this.statGain + crops.get((int)i).statGain);
        }
        int count = crops.size();
        this.statGrowth = (byte)(this.statGrowth / count);
        this.statResistance = (byte)(this.statResistance / count);
        this.statGain = (byte)(this.statGain / count);
        this.statGrowth = (byte)(this.statGrowth + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGrowth < 0) {
            this.statGrowth = 0;
        }
        if (this.statGrowth > 31) {
            this.statGrowth = (byte)31;
        }
        this.statGain = (byte)(this.statGain + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGain < 0) {
            this.statGain = 0;
        }
        if (this.statGain > 31) {
            this.statGain = (byte)31;
        }
        this.statResistance = (byte)(this.statResistance + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statResistance < 0) {
            this.statResistance = 0;
        }
        if (this.statResistance > 31) {
            this.statResistance = (byte)31;
        }
        return true;
    }

    public int calculateRatioFor(CropCard a, CropCard b) {
        int i;
        if (a == b) {
            return 500;
        }
        int value = 0;
        for (i = 0; i < 5; ++i) {
            int c = a.stat(i) - b.stat(i);
            if (c < 0) {
                c *= -1;
            }
            switch (c) {
                default: {
                    --value;
                }
                case 0: {
                    value += 2;
                }
                case 1: {
                    ++value;
                }
                case 2: 
            }
        }
        for (i = 0; i < a.attributes().length; ++i) {
            for (int j = 0; j < b.attributes().length; ++j) {
                if (!a.attributes()[i].equalsIgnoreCase(b.attributes()[j])) continue;
                value += 5;
            }
        }
        if (b.tier() < a.tier() - 1) {
            value -= 2 * (a.tier() - b.tier());
        }
        if (b.tier() - 3 > a.tier()) {
            value -= b.tier() - a.tier();
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public void askCropJoinCross(int x, int y, int z, LinkedList<TileEntityCrop> crops) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityCrop)) {
            return;
        }
        TileEntityCrop sidecrop = (TileEntityCrop)this.field_145850_b.func_147438_o(x, y, z);
        if (sidecrop.id <= 0) {
            return;
        }
        if (!sidecrop.crop().canGrow(this) || !sidecrop.crop().canCross(sidecrop)) {
            return;
        }
        int base = 4;
        if (sidecrop.statGrowth >= 16) {
            ++base;
        }
        if (sidecrop.statGrowth >= 30) {
            ++base;
        }
        if (sidecrop.statResistance >= 28) {
            base += 27 - sidecrop.statResistance;
        }
        if (base >= IC2.random.nextInt(20)) {
            crops.add(sidecrop);
        }
    }

    public boolean leftclick(EntityPlayer player) {
        if (this.id < 0) {
            if (this.upgraded) {
                this.upgraded = false;
                this.dirty = true;
                if (IC2.platform.isSimulating()) {
                    StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(Ic2Items.crop.func_77973_b()));
                }
                return true;
            }
            return false;
        }
        return this.crop().leftclick(this, player);
    }

    @Override
    public boolean pick(boolean manual) {
        int i;
        if (this.id < 0) {
            return false;
        }
        boolean bonus = this.harvest(false);
        float firstchance = this.crop().dropSeedChance(this);
        for (int i2 = 0; i2 < this.statResistance; ++i2) {
            firstchance *= 1.1f;
        }
        int drop = 0;
        if (bonus) {
            if (IC2.random.nextFloat() <= (firstchance + 1.0f) * 0.8f) {
                ++drop;
            }
            float chance = this.crop().dropSeedChance(this) + (float)this.statGrowth / 100.0f;
            if (!manual) {
                chance *= 0.8f;
            }
            for (i = 23; i < this.statGain; ++i) {
                chance *= 0.95f;
            }
            if (IC2.random.nextFloat() <= chance) {
                ++drop;
            }
        } else if (IC2.random.nextFloat() <= firstchance * 1.5f) {
            ++drop;
        }
        ItemStack[] re = new ItemStack[drop];
        for (i = 0; i < drop; ++i) {
            re[i] = this.crop().getSeeds(this);
        }
        this.reset();
        if (IC2.platform.isSimulating() && re.length > 0) {
            for (int x = 0; x < re.length; ++x) {
                if (re[x].func_77973_b() != Ic2Items.cropSeed.func_77973_b()) {
                    re[x].field_77990_d = null;
                }
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, re[x]);
            }
        }
        return true;
    }

    public boolean rightclick(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            if (this.id < 0) {
                if (current.func_77973_b() == Ic2Items.crop.func_77973_b() && !this.upgraded) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --current.field_77994_a;
                        if (current.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                    }
                    this.upgraded = true;
                    this.dirty = true;
                    return true;
                }
                if (this.applyBaseSeed(player)) {
                    return true;
                }
            } else if (current.func_77973_b() == Ic2Items.cropnalyzer.func_77973_b()) {
                if (IC2.platform.isSimulating()) {
                    String desc = this.getScanned();
                    if (desc == null) {
                        desc = "Unknown Crop";
                    }
                    IC2.platform.messagePlayer(player, desc, new Object[0]);
                }
                return true;
            }
            if (current.func_77973_b() == Items.field_151131_as || current.func_77973_b() == Ic2Items.waterCell.func_77973_b()) {
                if (this.waterStorage < 10) {
                    this.waterStorage = 10;
                    return true;
                }
                return current.func_77973_b() == Items.field_151131_as;
            }
            if (current.func_77973_b() == Items.field_151014_N) {
                if (this.nutrientStorage <= 50) {
                    this.nutrientStorage += 25;
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Items.field_151100_aR && current.func_77960_j() == 15 || current.func_77973_b() == Ic2Items.fertilizer.func_77973_b()) {
                if (this.applyFertilizer(true)) {
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Ic2Items.hydratingCell.func_77973_b()) {
                if (this.applyHydration(true, current)) {
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Ic2Items.weedEx.func_77973_b() && this.applyWeedEx(true)) {
                current.func_77972_a(1, (EntityLivingBase)player);
                if (current.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                return true;
            }
        }
        if (this.id < 0) {
            return false;
        }
        return this.crop().rightclick(this, player);
    }

    public boolean applyBaseSeed(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        BaseSeed seed = Crops.instance.getBaseSeed(current);
        if (seed != null) {
            if (current.field_77994_a < seed.stackSize) {
                return false;
            }
            if (this.tryPlantIn(seed.id, seed.size, seed.statGrowth, seed.statGain, seed.statResistance, 1)) {
                if (current.func_77973_b().hasContainerItem(current)) {
                    if (current.field_77994_a > 1) {
                        return false;
                    }
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = current.func_77973_b().getContainerItem(current);
                } else {
                    current.field_77994_a -= seed.stackSize;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryPlantIn(int i, int si, int statGr, int statGa, int statRe, int scan) {
        if (this.id > -1 || i <= 0 || this.upgraded) {
            return false;
        }
        if (!Crops.instance.getCropList()[i].canGrow(this)) {
            return false;
        }
        this.reset();
        this.id = (short)i;
        this.size = (byte)si;
        this.statGrowth = (byte)statGr;
        this.statGain = (byte)statGa;
        this.statResistance = (byte)statRe;
        this.scanLevel = (byte)scan;
        return true;
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.nutrientStorage >= 100) {
            return false;
        }
        this.nutrientStorage += manual ? 100 : 90;
        return true;
    }

    public boolean applyHydration(boolean manual, InvSlotConsumable hydrationSlot) {
        if (!manual && this.waterStorage >= 180 || this.waterStorage >= 200) {
            return false;
        }
        int apply = manual ? 200 - this.waterStorage : 180 - this.waterStorage;
        ItemStack affected = hydrationSlot.damage(apply, null);
        apply = affected.field_77994_a * affected.func_77958_k() + affected.func_77960_j();
        this.waterStorage += apply;
        return true;
    }

    public boolean applyHydration(boolean manual, ItemStack itemStack) {
        if (!manual && this.waterStorage >= 180 || this.waterStorage >= 200) {
            return false;
        }
        int apply = manual ? 200 - this.waterStorage : 180 - this.waterStorage;
        if (itemStack.func_96631_a(apply = Math.min(apply, itemStack.func_77958_k() - itemStack.func_77960_j()), new Random())) {
            --itemStack.field_77994_a;
            itemStack.func_77964_b(0);
        }
        this.waterStorage += apply;
        return true;
    }

    public boolean applyWeedEx(boolean manual) {
        boolean trigger;
        if (this.exStorage >= 100 && manual || this.exStorage >= 150) {
            return false;
        }
        this.exStorage += 50;
        boolean bl = trigger = this.field_145850_b.field_73012_v.nextInt(3) == 0;
        if (manual) {
            boolean bl2 = trigger = this.field_145850_b.field_73012_v.nextInt(5) == 0;
        }
        if (this.id > 0 && this.exStorage >= 75 && trigger) {
            switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                case 0: {
                    if (this.statGrowth > 0) {
                        this.statGrowth = (byte)(this.statGrowth - 1);
                    }
                }
                case 1: {
                    if (this.statGain <= 0) break;
                    this.statGain = (byte)(this.statGain - 1);
                }
            }
            if (this.statResistance > 0) {
                this.statResistance = (byte)(this.statResistance - 1);
            }
        }
        return true;
    }

    @Override
    public boolean harvest(boolean manual) {
        if (this.id < 0 || !this.crop().canBeHarvested(this)) {
            return false;
        }
        float chance = this.crop().dropGainChance();
        for (int i = 0; i < this.statGain; ++i) {
            chance *= 1.03f;
        }
        chance -= IC2.random.nextFloat();
        int drop = 0;
        while (chance > 0.0f) {
            ++drop;
            chance -= IC2.random.nextFloat();
        }
        ItemStack[] re = new ItemStack[drop];
        for (int i = 0; i < drop; ++i) {
            re[i] = this.crop().getGain(this);
            if (re[i] == null || IC2.random.nextInt(100) > this.statGain) continue;
            ++re[i].field_77994_a;
        }
        this.size = this.crop().getSizeAfterHarvest(this);
        this.dirty = true;
        if (IC2.platform.isSimulating() && re.length > 0) {
            for (int x = 0; x < re.length; ++x) {
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, re[x]);
            }
        }
        return true;
    }

    public void onNeighbourChange() {
        if (this.id < 0) {
            return;
        }
        this.crop().onNeighbourChange(this);
    }

    public int emitRedstone() {
        if (this.id < 0) {
            return 0;
        }
        return this.crop().emitRedstone(this);
    }

    public void onBlockDestroyed() {
        if (this.id < 0) {
            return;
        }
        this.crop().onBlockDestroyed(this);
    }

    public int getEmittedLight() {
        if (this.id < 0) {
            return 0;
        }
        return this.crop().getEmittedLight(this);
    }

    @Override
    public byte getHumidity() {
        if (this.humidity == -1) {
            this.humidity = this.updateHumidity();
        }
        return this.humidity;
    }

    @Override
    public byte getNutrients() {
        if (this.nutrients == -1) {
            this.nutrients = this.updateNutrients();
        }
        return this.nutrients;
    }

    @Override
    public byte getAirQuality() {
        if (this.airQuality == -1) {
            this.airQuality = this.updateAirQuality();
        }
        return this.airQuality;
    }

    public byte updateHumidity() {
        int value = Crops.instance.getHumidityBiomeBonus(this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e));
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) >= 7) {
            value += 2;
        }
        if (this.waterStorage >= 5) {
            value += 2;
        }
        return (byte)(value += (this.waterStorage + 24) / 25);
    }

    public byte updateNutrients() {
        int value = Crops.instance.getNutrientBiomeBonus(this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e));
        for (int i = 2; i < 5 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e) == Blocks.field_150346_d; ++i) {
            ++value;
        }
        return (byte)(value += (this.nutrientStorage + 19) / 20);
    }

    public byte updateAirQuality() {
        int value = 0;
        int height = (this.field_145848_d - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = this.field_145851_c - 1; x < this.field_145851_c + 1 && fresh > 0; ++x) {
            for (int z = this.field_145849_e - 1; z < this.field_145849_e + 1 && fresh > 0; ++z) {
                if (!this.field_145850_b.func_147445_c(x, this.field_145848_d, z, false) && !(this.field_145850_b.func_147438_o(x, this.field_145848_d, z) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            value += 2;
        }
        return (byte)value;
    }

    public byte updateMultiCulture() {
        LinkedList<CropCard> crops = new LinkedList<CropCard>();
        for (int x = -1; x < 1; ++x) {
            for (int z = -1; z < 1; ++z) {
                if (!(this.field_145850_b.func_147438_o(x + this.field_145851_c, this.field_145848_d, z + this.field_145849_e) instanceof TileEntityCrop)) continue;
                this.addIfNotPresent(((TileEntityCrop)this.field_145850_b.func_147438_o(x + this.field_145851_c, this.field_145848_d, z + this.field_145849_e)).crop(), crops);
            }
        }
        return (byte)(crops.size() - 1);
    }

    public void addIfNotPresent(CropCard crop, LinkedList<CropCard> crops) {
        for (int i = 0; i < crops.size(); ++i) {
            if (crop != crops.get(i)) continue;
            return;
        }
        crops.add(crop);
    }

    public int calcGrowthRate() {
        int have;
        int base = 3 + IC2.random.nextInt(7) + this.statGrowth;
        int need = (this.crop().tier() - 1) * 4 + this.statGrowth + this.statGain + this.statResistance;
        if (need < 0) {
            need = 0;
        }
        if ((have = this.crop().weightInfluences(this, this.getHumidity(), this.getNutrients(), this.getAirQuality()) * 5) >= need) {
            base = base * (100 + (have - need)) / 100;
        } else {
            int neg = (need - have) * 4;
            if (neg > 100 && IC2.random.nextInt(32) > this.statResistance) {
                this.reset();
                base = 0;
            } else if ((base = base * (100 - neg) / 100) < 0) {
                base = 0;
            }
        }
        return base;
    }

    public void calcTrampling() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (IC2.random.nextInt(100) == 0 && IC2.random.nextInt(40) > this.statResistance) {
            this.reset();
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Blocks.field_150346_d, 0, 7);
        }
    }

    public CropCard crop() {
        return Crops.instance.getCropList()[this.id];
    }

    public void onEntityCollision(Entity entity) {
        if (this.id < 0) {
            return;
        }
        if (this.crop().onEntityCollision(this, entity)) {
            this.calcTrampling();
        }
    }

    @Override
    public void reset() {
        this.id = (short)-1;
        this.size = 0;
        this.customData = new NBTTagCompound();
        this.dirty = true;
        this.statGain = 0;
        this.statResistance = 0;
        this.statGrowth = 0;
        this.nutrients = (byte)-1;
        this.airQuality = (byte)-1;
        this.humidity = (byte)-1;
        this.growthPoints = 0;
        this.upgraded = false;
        this.scanLevel = 0;
    }

    @Override
    public void updateState() {
        this.dirty = true;
    }

    public String getScanned() {
        if (this.scanLevel <= 0 || this.id < 0) {
            return null;
        }
        if (this.scanLevel >= 4) {
            return this.crop().name() + " - Gr: " + this.statGrowth + " Ga: " + this.statGain + " Re: " + this.statResistance;
        }
        return this.crop().name();
    }

    @Override
    public boolean isBlockBelow(Block reqBlock) {
        for (int i = 1; i < 4; ++i) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            if (block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - i, this.field_145849_e)) {
                return false;
            }
            if (block != reqBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack generateSeeds(short plant, byte growth, byte gain, byte resis, byte scan) {
        return ItemCropSeed.generateItemStackFromValues(plant, growth, gain, resis, scan);
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.dirty = true;
    }

    @Override
    public short getID() {
        return this.id;
    }

    @Override
    public byte getSize() {
        return this.size;
    }

    @Override
    public byte getGrowth() {
        return this.statGrowth;
    }

    @Override
    public byte getGain() {
        return this.statGain;
    }

    @Override
    public byte getResistance() {
        return this.statResistance;
    }

    @Override
    public byte getScanLevel() {
        return this.scanLevel;
    }

    @Override
    public NBTTagCompound getCustomData() {
        return this.customData;
    }

    @Override
    public int getNutrientStorage() {
        return this.nutrientStorage;
    }

    @Override
    public int getHydrationStorage() {
        return this.waterStorage;
    }

    @Override
    public int getWeedExStorage() {
        return this.exStorage;
    }

    @Override
    public int getLightLevel() {
        return this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void setID(short id1) {
        this.id = id1;
        this.dirty = true;
    }

    @Override
    public void setSize(byte size1) {
        this.size = size1;
        this.dirty = true;
    }

    @Override
    public void setGrowth(byte growth) {
        this.statGrowth = growth;
    }

    @Override
    public void setGain(byte gain) {
        this.statGain = gain;
    }

    @Override
    public void setResistance(byte resistance) {
        this.statResistance = resistance;
    }

    @Override
    public void setScanLevel(byte scanLevel1) {
        this.scanLevel = scanLevel1;
    }

    @Override
    public void setNutrientStorage(int nutrientStorage1) {
        this.nutrientStorage = nutrientStorage1;
    }

    @Override
    public void setHydrationStorage(int hydrationStorage) {
        this.waterStorage = hydrationStorage;
    }

    @Override
    public void setWeedExStorage(int weedExStorage) {
        this.exStorage = weedExStorage;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public ChunkCoordinates getLocation() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

