/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.crop.CropAurelia;
import ic2.core.block.crop.CropCocoa;
import ic2.core.block.crop.CropCoffee;
import ic2.core.block.crop.CropColorFlower;
import ic2.core.block.crop.CropFerru;
import ic2.core.block.crop.CropHops;
import ic2.core.block.crop.CropMelon;
import ic2.core.block.crop.CropNetherWart;
import ic2.core.block.crop.CropPotato;
import ic2.core.block.crop.CropPumpkin;
import ic2.core.block.crop.CropRedWheat;
import ic2.core.block.crop.CropReed;
import ic2.core.block.crop.CropSeedFood;
import ic2.core.block.crop.CropStickReed;
import ic2.core.block.crop.CropTerraWart;
import ic2.core.block.crop.CropVenomilia;
import ic2.core.block.crop.CropWeed;
import ic2.core.block.crop.CropWheat;
import ic2.core.init.Localization;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public class IC2Crops
extends Crops {
    private final Map<BiomeGenBase, Integer> humidityBiomeBonus = new HashMap<BiomeGenBase, Integer>();
    private final Map<BiomeGenBase, Integer> nutrientBiomeBonus = new HashMap<BiomeGenBase, Integer>();
    private final Map<ItemStack, BaseSeed> baseSeeds = new HashMap<ItemStack, BaseSeed>();
    private final CropCard[] crops = new CropCard[256];
    public static CropCard weed = new CropWeed();
    public static CropCard cropWheat = new CropWheat();
    public static CropCard cropPumpkin = new CropPumpkin();
    public static CropCard cropMelon = new CropMelon();
    public static CropCard cropYellowFlower = new CropColorFlower("Dandelion", new String[]{"Yellow", "Flower"}, 11);
    public static CropCard cropRedFlower = new CropColorFlower("Rose", new String[]{"Red", "Flower", "Rose"}, 1);
    public static CropCard cropBlackFlower = new CropColorFlower("Blackthorn", new String[]{"Black", "Flower", "Rose"}, 0);
    public static CropCard cropPurpleFlower = new CropColorFlower("Tulip", new String[]{"Purple", "Flower", "Tulip"}, 5);
    public static CropCard cropBlueFlower = new CropColorFlower("Cyazint", new String[]{"Blue", "Flower"}, 6);
    public static CropCard cropVenomilia = new CropVenomilia();
    public static CropCard cropReed = new CropReed();
    public static CropCard cropStickReed = new CropStickReed();
    public static CropCard cropCocoa = new CropCocoa();
    public static CropCard cropFerru = new CropFerru();
    public static CropCard cropAurelia = new CropAurelia();
    public static CropCard cropRedwheat = new CropRedWheat();
    public static CropCard cropNetherWart = new CropNetherWart();
    public static CropCard cropTerraWart = new CropTerraWart();
    public static CropCard cropCoffee = new CropCoffee();
    public static CropCard cropHops = new CropHops();
    public static CropCard cropCarrots = new CropSeedFood("Carrots", "Orange", new ItemStack(Items.field_151172_bF));
    public static CropCard cropPotato = new CropPotato();

    public static void init() {
        Crops.instance = new IC2Crops();
        IC2Crops.registerCrops();
        IC2Crops.registerBaseSeeds();
    }

    public static void registerCrops() {
        if (!(Crops.instance.registerCrop(weed, 0) && Crops.instance.registerCrop(cropWheat, 1) && Crops.instance.registerCrop(cropPumpkin, 2) && Crops.instance.registerCrop(cropMelon, 3) && Crops.instance.registerCrop(cropYellowFlower, 4) && Crops.instance.registerCrop(cropRedFlower, 5) && Crops.instance.registerCrop(cropBlackFlower, 6) && Crops.instance.registerCrop(cropPurpleFlower, 7) && Crops.instance.registerCrop(cropBlueFlower, 8) && Crops.instance.registerCrop(cropVenomilia, 9) && Crops.instance.registerCrop(cropReed, 10) && Crops.instance.registerCrop(cropStickReed, 11) && Crops.instance.registerCrop(cropCocoa, 12) && Crops.instance.registerCrop(cropFerru, 13) && Crops.instance.registerCrop(cropAurelia, 14) && Crops.instance.registerCrop(cropRedwheat, 15) && Crops.instance.registerCrop(cropNetherWart, 16) && Crops.instance.registerCrop(cropTerraWart, 17) && Crops.instance.registerCrop(cropCoffee, 18) && Crops.instance.registerCrop(cropHops, 19) && Crops.instance.registerCrop(cropCarrots, 20) && Crops.instance.registerCrop(cropPotato, 21))) {
            IC2.platform.displayError("One or more crops have failed to initialize.\nThis could happen due to a crop addon using a crop ID already taken\nby a crop from IndustrialCraft 2.");
        }
    }

    public static void registerBaseSeeds() {
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151014_N, 1, Short.MAX_VALUE), cropWheat.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151080_bb, 1, Short.MAX_VALUE), cropPumpkin.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151081_bc, 1, Short.MAX_VALUE), cropMelon.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151075_bm, 1, Short.MAX_VALUE), cropNetherWart.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Ic2Items.terraWart.func_77973_b(), 1, Short.MAX_VALUE), cropTerraWart.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Ic2Items.coffeeBeans.func_77973_b(), 1, Short.MAX_VALUE), cropCoffee.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151120_aE, 1, Short.MAX_VALUE), cropReed.getId(), 1, 3, 0, 2);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151100_aR, 1, 3), cropCocoa.getId(), 1, 0, 0, 0);
        Crops.instance.registerBaseSeed(new ItemStack((Block)Blocks.field_150328_O, 4, Short.MAX_VALUE), cropRedFlower.getId(), 4, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack((Block)Blocks.field_150327_N, 4, Short.MAX_VALUE), cropYellowFlower.getId(), 4, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151172_bF, 1, Short.MAX_VALUE), cropCarrots.getId(), 1, 1, 1, 1);
        Crops.instance.registerBaseSeed(new ItemStack(Items.field_151174_bG, 1, Short.MAX_VALUE), cropPotato.getId(), 1, 1, 1, 1);
    }

    @Override
    public void addBiomeBonus(BiomeGenBase biome, int humidityBonus, int nutrientsBonus) {
        this.humidityBiomeBonus.put(biome, humidityBonus);
        this.nutrientBiomeBonus.put(biome, nutrientsBonus);
    }

    @Override
    public int getHumidityBiomeBonus(BiomeGenBase biome) {
        return this.humidityBiomeBonus.containsKey(biome) ? this.humidityBiomeBonus.get(biome) : 0;
    }

    @Override
    public int getNutrientBiomeBonus(BiomeGenBase biome) {
        return this.nutrientBiomeBonus.containsKey(biome) ? this.nutrientBiomeBonus.get(biome) : 0;
    }

    @Override
    public CropCard[] getCropList() {
        return this.crops;
    }

    @Override
    public short registerCrop(CropCard crop) {
        for (short x = 0; x < this.crops.length; x = (short)((short)(x + 1))) {
            if (this.crops[x] != null) continue;
            this.registerCrop(crop, x);
            return x;
        }
        return -1;
    }

    @Override
    public boolean registerCrop(CropCard crop, int i) {
        if (i < 0 || i >= this.crops.length) {
            return false;
        }
        if (this.crops[i] == null) {
            this.crops[i] = crop;
            Localization.addLocalization("ic2.cropSeed" + i, crop.name() + " Seeds");
            return true;
        }
        IC2.log.warn("Cannot add crop:" + crop.name() + " on ID #" + i + ", slot already occupied by crop:" + this.crops[i].name());
        return false;
    }

    @Override
    public boolean registerBaseSeed(ItemStack stack, int id, int size, int growth, int gain, int resistance) {
        for (ItemStack key : this.baseSeeds.keySet()) {
            if (key.func_77973_b() != stack.func_77973_b() || key.func_77960_j() != stack.func_77960_j()) continue;
            return false;
        }
        this.baseSeeds.put(stack, new BaseSeed(id, size, growth, gain, resistance, stack.field_77994_a));
        return true;
    }

    @Override
    public BaseSeed getBaseSeed(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, BaseSeed> entry : this.baseSeeds.entrySet()) {
            ItemStack key = entry.getKey();
            if (key.func_77973_b() != stack.func_77973_b() || key.func_77960_j() != Short.MAX_VALUE && key.func_77960_j() != stack.func_77960_j()) continue;
            return this.baseSeeds.get(key);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void startSpriteRegistration(IIconRegister iconRegister) {
        for (CropCard cropCard : this.crops) {
            if (cropCard == null) continue;
            cropCard.registerSprites(iconRegister);
        }
    }

    @Override
    public int getIdFor(CropCard crop) {
        for (int i = 0; i < this.crops.length; ++i) {
            if (this.crops[i] != crop) continue;
            return i;
        }
        return -1;
    }
}

