/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.ContainerCentrifuge;
import ic2.core.block.machine.gui.GuiCentrifuge;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCentrifuge
extends TileEntityStandardMachine {
    public short maxHeat = (short)5000;
    public short heat = 0;
    public short workheat = this.maxHeat;

    public TileEntityCentrifuge() {
        super(48, 500, 3, 2);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.centrifuge);
    }

    public static void init() {
        Recipes.centrifuge = new BasicMachineRecipeManager();
        TileEntityCentrifuge.addRecipe(new ItemStack(Blocks.field_150347_e), 1, 100, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("dustClay", 4, 250, Ic2Items.silicondioxideDust);
        TileEntityCentrifuge.addRecipe(new ItemStack(Items.field_151128_bU), 2, 500, Ic2Items.smallLithiumDust);
        TileEntityCentrifuge.addRecipe("crushedCopper", 1, 500, Ic2Items.smallTinDust, Ic2Items.copperDust, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedTin", 1, 1000, Ic2Items.smallIronDust, Ic2Items.tinDust, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedIron", 1, 1500, Ic2Items.smallGoldDust, Ic2Items.ironDust, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedGold", 1, 2000, Ic2Items.smallSilverDust, Ic2Items.goldDust, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedUranium", 1, 3000, Ic2Items.smallUran235, StackUtil.copyWithSize(Ic2Items.Uran238, 4), Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedLead", 1, 2000, Ic2Items.leadDust, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedSilver", 1, 2000, Ic2Items.silverDust, Ic2Items.stoneDust);
        TileEntityCentrifuge.addRecipe("crushedPurifiedCopper", 1, 500, Ic2Items.smallTinDust, Ic2Items.copperDust);
        TileEntityCentrifuge.addRecipe("crushedPurifiedTin", 1, 1000, Ic2Items.smallIronDust, Ic2Items.tinDust);
        TileEntityCentrifuge.addRecipe("crushedPurifiedIron", 1, 1500, Ic2Items.smallGoldDust, Ic2Items.ironDust);
        TileEntityCentrifuge.addRecipe("crushedPurifiedGold", 1, 2000, Ic2Items.smallSilverDust, Ic2Items.goldDust);
        TileEntityCentrifuge.addRecipe("crushedPurifiedUranium", 1, 3000, StackUtil.copyWithSize(Ic2Items.smallUran235, 2), StackUtil.copyWithSize(Ic2Items.Uran238, 5));
        TileEntityCentrifuge.addRecipe("crushedPurifiedLead", 1, 2000, Ic2Items.smallCopperDust, Ic2Items.leadDust);
        TileEntityCentrifuge.addRecipe("crushedPurifiedSilver", 1, 1000, Ic2Items.smallLeadDust, Ic2Items.silverDust);
        TileEntityCentrifuge.addRecipe(Ic2Items.reactorDepletedUraniumSimple, 1, 4000, Ic2Items.smallPlutonium, StackUtil.copyWithSize(Ic2Items.Uran238, 4), StackUtil.copyWithSize(Ic2Items.ironDust, 1));
        TileEntityCentrifuge.addRecipe(Ic2Items.reactorDepletedUraniumDual, 1, 4000, StackUtil.copyWithSize(Ic2Items.smallPlutonium, 2), StackUtil.copyWithSize(Ic2Items.Uran238, 8), StackUtil.copyWithSize(Ic2Items.ironDust, 3));
        TileEntityCentrifuge.addRecipe(Ic2Items.reactorDepletedUraniumQuad, 1, 4000, StackUtil.copyWithSize(Ic2Items.smallPlutonium, 4), StackUtil.copyWithSize(Ic2Items.Uran238, 16), StackUtil.copyWithSize(Ic2Items.ironDust, 6));
        TileEntityCentrifuge.addRecipe(Ic2Items.reactorDepletedMOXSimple, 1, 5000, Ic2Items.smallPlutonium, StackUtil.copyWithSize(Ic2Items.Plutonium, 3), StackUtil.copyWithSize(Ic2Items.ironDust, 1));
        TileEntityCentrifuge.addRecipe(Ic2Items.reactorDepletedMOXDual, 1, 5000, StackUtil.copyWithSize(Ic2Items.smallPlutonium, 2), StackUtil.copyWithSize(Ic2Items.Plutonium, 6), StackUtil.copyWithSize(Ic2Items.ironDust, 3));
        TileEntityCentrifuge.addRecipe(Ic2Items.reactorDepletedMOXQuad, 1, 5000, StackUtil.copyWithSize(Ic2Items.smallPlutonium, 4), StackUtil.copyWithSize(Ic2Items.Plutonium, 12), StackUtil.copyWithSize(Ic2Items.ironDust, 6));
        TileEntityCentrifuge.addRecipe(Ic2Items.RTGPellets, 1, 5000, StackUtil.copyWithSize(Ic2Items.Plutonium, 3), StackUtil.copyWithSize(Ic2Items.ironDust, 54));
    }

    public static void addRecipe(ItemStack input, int amount, int minHeat, ItemStack ... output) {
        TileEntityCentrifuge.addRecipe(new RecipeInputItemStack(input, amount), minHeat, output);
    }

    public static void addRecipe(String input, int amount, int minHeat, ItemStack ... output) {
        TileEntityCentrifuge.addRecipe(new RecipeInputOreDict(input, amount), minHeat, output);
    }

    public static void addRecipe(IRecipeInput input, int minHeat, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("minHeat", minHeat);
        Recipes.centrifuge.addRecipe(input, metadata, output);
    }

    @Override
    public String func_145825_b() {
        if (IC2.platform.isRendering()) {
            return "Thermal  Centrifuge";
        }
        return "ThermalCentrifuge";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74765_d("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("heat", this.heat);
    }

    public int gaugeHeatScaled(int i) {
        return i * this.heat / this.workheat;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean energyPerHeat = true;
        boolean coolingPerTick = true;
        boolean heating = false;
        if (this.energy >= 1.0) {
            int heatRequested = Integer.MIN_VALUE;
            RecipeOutput output = super.getOutput();
            if (output != null) {
                heatRequested = Math.min(this.maxHeat, output.metadata.func_74762_e("minHeat"));
                this.workheat = (short)heatRequested;
            } else if (this.isRedstonePowered() && this.heat < this.maxHeat) {
                heatRequested = this.maxHeat;
                this.workheat = (short)heatRequested;
            }
            if (this.heat - 1 < heatRequested) {
                this.energy -= 1.0;
                heating = true;
            }
        }
        this.heat = heating ? (short)(this.heat + 1) : (short)(this.heat - Math.min(this.heat, 1));
    }

    @Override
    public RecipeOutput getOutput() {
        RecipeOutput ret = super.getOutput();
        if (ret != null) {
            if (ret.metadata == null) {
                return null;
            }
            if (ret.metadata.func_74762_e("minHeat") > this.heat) {
                return null;
            }
        }
        return ret;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCentrifuge(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiCentrifuge(new ContainerCentrifuge(entityPlayer, this));
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }
}

