/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.Ic2Player;
import ic2.core.InvSlotConsumableBlock;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.machine.ContainerMiner;
import ic2.core.block.machine.gui.GuiMiner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityMiner
extends TileEntityElectricMachine
implements IHasGui {
    private Mode lastMode = Mode.None;
    public int progress = 0;
    private int scannedLevel = -1;
    private int scanRange = 0;
    private int lastX;
    private int lastZ;
    public boolean pumpMode = false;
    public boolean canProvideLiquid = false;
    public int liquidX;
    public int liquidY;
    public int liquidZ;
    private AudioSource audioSource;
    public final InvSlotConsumableId drillSlot = new InvSlotConsumableId((TileEntityInventory)this, "drill", 3, InvSlot.Access.IO, 1, InvSlot.InvSide.TOP, Ic2Items.miningDrill.func_77973_b(), Ic2Items.diamondDrill.func_77973_b());
    public final InvSlotConsumableBlock pipeSlot = new InvSlotConsumableBlock(this, "pipe", 2, InvSlot.Access.IO, 1, InvSlot.InvSide.SIDE);
    public final InvSlotConsumableId scannerSlot = new InvSlotConsumableId((TileEntityInventory)this, "scanner", 1, InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.odScanner.func_77973_b(), Ic2Items.ovScanner.func_77973_b());

    public TileEntityMiner() {
        super(1000, IC2.enableMinerLapotron ? 4 : 1, 0);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.scannedLevel = -1;
        this.lastX = this.field_145851_c;
        this.lastZ = this.field_145849_e;
        this.canProvideLiquid = false;
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.lastMode = Mode.values()[nbtTagCompound.func_74762_e("lastMode")];
        this.progress = nbtTagCompound.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("lastMode", this.lastMode.ordinal());
        nbtTagCompound.func_74768_a("progress", this.progress);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.chargeTools();
        if (this.work()) {
            this.func_70296_d();
            this.setActive(true);
        } else {
            this.setActive(false);
        }
    }

    private void chargeTools() {
        if (!this.scannerSlot.isEmpty()) {
            this.energy -= (double)ElectricItem.manager.charge(this.scannerSlot.get(), (int)this.energy, 2, false, false);
        }
        if (!this.drillSlot.isEmpty()) {
            this.energy -= (double)ElectricItem.manager.charge(this.drillSlot.get(), (int)this.energy, 1, false, false);
        }
    }

    private boolean work() {
        int operationHeight = this.getOperationHeight();
        if (this.drillSlot.isEmpty()) {
            return this.withDrawPipe(operationHeight);
        }
        if (operationHeight >= 0) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, operationHeight, this.field_145849_e);
            if (!StackUtil.equals(block, Ic2Items.miningPipeTip)) {
                if (operationHeight > 0) {
                    return this.digDown(operationHeight, false);
                }
                return false;
            }
            MineResult result = this.mineLevel(operationHeight);
            if (result == MineResult.Done) {
                return this.digDown(operationHeight - 1, true);
            }
            return result == MineResult.Working;
        }
        return false;
    }

    private int getOperationHeight() {
        for (int y = this.field_145848_d - 1; y >= 0; --y) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
            if (StackUtil.equals(block, Ic2Items.miningPipe)) continue;
            return y;
        }
        return -1;
    }

    private boolean withDrawPipe(int y) {
        if (this.lastMode != Mode.Withdraw) {
            this.lastMode = Mode.Withdraw;
            this.progress = 0;
        }
        if (y < 0 || !StackUtil.equals(this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e), Ic2Items.miningPipeTip)) {
            ++y;
        }
        if (y != this.field_145848_d && this.energy >= 3.0) {
            if (this.progress < 20) {
                this.energy -= 3.0;
                ++this.progress;
            } else {
                this.progress = 0;
                this.removePipe(y);
            }
            return true;
        }
        return false;
    }

    private void removePipe(int y) {
        ItemStack filler;
        Item fillerItem;
        this.field_145850_b.func_147468_f(this.field_145851_c, y, this.field_145849_e);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(Ic2Items.miningPipe.func_77946_l());
        StackUtil.distributeDrop(this, drops);
        if (!this.pipeSlot.isEmpty() && this.pipeSlot.get().func_77973_b() != Ic2Items.miningPipe.func_77973_b() && (fillerItem = (filler = this.pipeSlot.consume(1)).func_77973_b()) instanceof ItemBlock) {
            ((ItemBlock)fillerItem).func_77648_a(filler, (EntityPlayer)new Ic2Player(this.field_145850_b), this.field_145850_b, this.field_145851_c, y + 1, this.field_145849_e, 0, 0.0f, 0.0f, 0.0f);
        }
    }

    private boolean digDown(int y, boolean removeTipAbove) {
        if (this.pipeSlot.isEmpty() || this.pipeSlot.get().func_77973_b() != Ic2Items.miningPipe.func_77973_b()) {
            return false;
        }
        if (y < 0) {
            if (removeTipAbove) {
                this.field_145850_b.func_147449_b(this.field_145851_c, y + 1, this.field_145849_e, StackUtil.getBlock(Ic2Items.miningPipe));
            }
            return false;
        }
        MineResult result = this.mineBlock(this.field_145851_c, y, this.field_145849_e);
        if (result == MineResult.Failed_Temp || result == MineResult.Failed_Perm) {
            if (removeTipAbove) {
                this.field_145850_b.func_147449_b(this.field_145851_c, y + 1, this.field_145849_e, StackUtil.getBlock(Ic2Items.miningPipe));
            }
            return false;
        }
        if (result == MineResult.Done) {
            if (removeTipAbove) {
                this.field_145850_b.func_147449_b(this.field_145851_c, y + 1, this.field_145849_e, StackUtil.getBlock(Ic2Items.miningPipe));
            }
            this.pipeSlot.consume(1);
            this.field_145850_b.func_147449_b(this.field_145851_c, y, this.field_145849_e, StackUtil.getBlock(Ic2Items.miningPipeTip));
        }
        return true;
    }

    private MineResult mineLevel(int y) {
        if (this.scannerSlot.isEmpty()) {
            return MineResult.Done;
        }
        if (this.scannedLevel != y) {
            this.scanRange = ((ItemScanner)this.scannerSlot.get().func_77973_b()).startLayerScan(this.scannerSlot.get());
        }
        if (this.scanRange > 0) {
            this.scannedLevel = y;
            for (int x = this.field_145851_c - this.scanRange; x <= this.field_145851_c + this.scanRange; ++x) {
                for (int z = this.field_145849_e - this.scanRange; z <= this.field_145849_e + this.scanRange; ++z) {
                    LiquidUtil.LiquidData liquid;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    int meta = this.field_145850_b.func_72805_g(x, y, z);
                    boolean isValidTarget = false;
                    if (ItemScanner.isValuable(block, meta) && this.canMine(x, y, z)) {
                        isValidTarget = true;
                    } else if (this.pumpMode && (liquid = LiquidUtil.getLiquid(this.field_145850_b, x, y, z)) != null && this.canPump(x, y, z)) {
                        isValidTarget = true;
                    }
                    if (!isValidTarget) continue;
                    MineResult result = this.mineTowards(x, y, z);
                    if (result == MineResult.Done) {
                        return MineResult.Working;
                    }
                    if (result == MineResult.Failed_Perm) continue;
                    return result;
                }
            }
            return MineResult.Done;
        }
        return MineResult.Failed_Temp;
    }

    private MineResult mineTowards(int x, int y, int z) {
        int dx = Math.abs(x - this.field_145851_c);
        int sx = this.field_145851_c < x ? 1 : -1;
        int dz = -Math.abs(z - this.field_145849_e);
        int sz = this.field_145849_e < z ? 1 : -1;
        int err = dx + dz;
        int cx = this.field_145851_c;
        int cz = this.field_145849_e;
        while (cx != x || cz != z) {
            boolean isCurrentPos = cx == this.lastX && cz == this.lastZ;
            int e2 = 2 * err;
            if (e2 > dz) {
                err += dz;
                cx += sx;
            } else if (e2 < dx) {
                err += dx;
                cz += sz;
            }
            boolean isBlocking = false;
            if (isCurrentPos) {
                isBlocking = true;
            } else {
                LiquidUtil.LiquidData liquid;
                Block block = this.field_145850_b.func_147439_a(cx, y, cz);
                if (!block.isAir((IBlockAccess)this.field_145850_b, cx, y, cz) && ((liquid = LiquidUtil.getLiquid(this.field_145850_b, cx, y, cz)) == null || liquid.isSource || this.pumpMode && this.canPump(x, y, z))) {
                    isBlocking = true;
                }
            }
            if (!isBlocking) continue;
            MineResult result = this.mineBlock(cx, y, cz);
            if (result == MineResult.Done) {
                this.lastX = cx;
                this.lastZ = cz;
            }
            return result;
        }
        this.lastX = this.field_145851_c;
        this.lastZ = this.field_145849_e;
        return MineResult.Done;
    }

    private MineResult mineBlock(int x, int y, int z) {
        int duration;
        int energyPerTick;
        Mode mode;
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        boolean isAirBlock = true;
        if (!block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            isAirBlock = false;
            LiquidUtil.LiquidData liquidData = LiquidUtil.getLiquid(this.field_145850_b, x, y, z);
            if (liquidData != null) {
                if (liquidData.isSource || this.pumpMode && this.canPump(x, y, z)) {
                    this.liquidX = x;
                    this.liquidY = y;
                    this.liquidZ = z;
                    this.canProvideLiquid = true;
                    return this.pumpMode ? MineResult.Failed_Temp : MineResult.Failed_Perm;
                }
            } else if (!this.canMine(x, y, z)) {
                return MineResult.Failed_Perm;
            }
        }
        this.canProvideLiquid = false;
        if (isAirBlock) {
            mode = Mode.MineAir;
            energyPerTick = 3;
            duration = 20;
        } else if (this.drillSlot.get().func_77973_b() == Ic2Items.miningDrill.func_77973_b()) {
            mode = Mode.MineDrill;
            energyPerTick = 6;
            duration = 200;
        } else if (this.drillSlot.get().func_77973_b() == Ic2Items.diamondDrill.func_77973_b()) {
            mode = Mode.MineDDrill;
            energyPerTick = 20;
            duration = 50;
        } else {
            throw new IllegalStateException("invalid drill: " + this.drillSlot.get());
        }
        if (this.lastMode != mode) {
            this.lastMode = mode;
            this.progress = 0;
        }
        if (this.progress < duration) {
            if (this.energy >= (double)energyPerTick) {
                this.energy -= (double)energyPerTick;
                ++this.progress;
                return MineResult.Working;
            }
        } else if (isAirBlock || this.harvestBlock(x, y, z, block)) {
            this.progress = 0;
            return MineResult.Done;
        }
        return MineResult.Failed_Temp;
    }

    private boolean harvestBlock(int x, int y, int z, Block block) {
        int energyCost = 2 * (this.field_145848_d - y);
        if (this.energy >= (double)energyCost) {
            if (this.drillSlot.get().func_77973_b() == Ic2Items.miningDrill.func_77973_b()) {
                if (!ElectricItem.manager.use(this.drillSlot.get(), 50, null)) {
                    return false;
                }
            } else if (this.drillSlot.get().func_77973_b() == Ic2Items.diamondDrill.func_77973_b()) {
                if (!ElectricItem.manager.use(this.drillSlot.get(), 80, null)) {
                    return false;
                }
            } else {
                throw new IllegalStateException("invalid drill: " + this.drillSlot.get());
            }
            this.energy -= (double)energyCost;
            StackUtil.distributeDrop(this, block.getDrops(this.field_145850_b, x, y, z, this.field_145850_b.func_72805_g(x, y, z), 0));
            this.field_145850_b.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public boolean canPump(int x, int y, int z) {
        return false;
    }

    public boolean canMine(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            return true;
        }
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (StackUtil.equals(block, Ic2Items.miningPipe) || StackUtil.equals(block, Ic2Items.miningPipeTip) || block == Blocks.field_150486_ae) {
            return false;
        }
        if (block instanceof IFluidBlock && this.isPumpConnected(x, y, z)) {
            return true;
        }
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k) && this.isPumpConnected(x, y, z)) {
            return true;
        }
        if (block.func_149712_f(this.field_145850_b, x, y, z) < 0.0f) {
            return false;
        }
        if (block.func_149678_a(meta, false) && block.func_149688_o().func_76229_l()) {
            return true;
        }
        if (block == Blocks.field_150321_G) {
            return true;
        }
        if (!this.drillSlot.isEmpty() && this.drillSlot.get().func_77973_b() instanceof ItemTool) {
            return ((ItemTool)this.drillSlot.get().func_77973_b()).canHarvestBlock(block, this.drillSlot.get());
        }
        return false;
    }

    public boolean isPumpConnected(int x, int y, int z) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).pump(x, y, z, true) != null) {
            return true;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).pump(x, y, z, true) != null;
    }

    public boolean isAnyPumpConnected() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump;
    }

    @Override
    public String func_145825_b() {
        return "Miner";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMiner(new ContainerMiner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    static enum MineResult {
        Working,
        Done,
        Failed_Temp,
        Failed_Perm;

    }

    static enum Mode {
        None,
        Withdraw,
        MineAir,
        MineDrill,
        MineDDrill;

    }
}

