/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricItemManager
implements IElectricItemManager {
    @Override
    public int charge(ItemStack stack, int charge, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        assert (item.getMaxCharge(stack) > 0);
        if (charge < 0 || stack.field_77994_a > 1 || item.getTier(stack) > tier) {
            return 0;
        }
        if (!ignoreTransferLimit && charge > item.getTransferLimit(stack)) {
            charge = item.getTransferLimit(stack);
        }
        NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(stack);
        int newCharge = tNBT.func_74762_e("charge");
        if (charge > item.getMaxCharge(stack) - newCharge) {
            charge = item.getMaxCharge(stack) - newCharge;
        }
        if (!simulate) {
            if ((newCharge += charge) > 0) {
                tNBT.func_74768_a("charge", newCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            stack.func_150996_a(newCharge > 0 ? item.getChargedItem(stack) : item.getEmptyItem(stack));
            if (stack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)stack.func_77973_b();
                if (stack.func_77958_k() > 2) {
                    stack.func_77964_b((int)(1L + ((long)item.getMaxCharge(stack) - (long)newCharge) * ((long)stack.func_77958_k() - 2L) / (long)item.getMaxCharge(stack)));
                } else {
                    stack.func_77964_b(0);
                }
            } else {
                stack.func_77964_b(0);
            }
        }
        return charge;
    }

    @Override
    public int discharge(ItemStack stack, int charge, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tNBT;
        int newCharge;
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        assert (item.getMaxCharge(stack) > 0);
        if (charge < 0 || stack.field_77994_a > 1 || item.getTier(stack) > tier) {
            return 0;
        }
        if (!ignoreTransferLimit && charge > item.getTransferLimit(stack)) {
            charge = item.getTransferLimit(stack);
        }
        if (charge > (newCharge = (tNBT = StackUtil.getOrCreateNbtData(stack)).func_74762_e("charge"))) {
            charge = newCharge;
        }
        if (!simulate) {
            if ((newCharge -= charge) > 0) {
                tNBT.func_74768_a("charge", newCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            stack.func_150996_a(newCharge > 0 ? item.getChargedItem(stack) : item.getEmptyItem(stack));
            if (stack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)stack.func_77973_b();
                if (stack.func_77958_k() > 2) {
                    stack.func_77964_b((int)(1L + ((long)item.getMaxCharge(stack) - (long)newCharge) * ((long)stack.func_77958_k() - 2L) / (long)item.getMaxCharge(stack)));
                } else {
                    stack.func_77964_b(0);
                }
            } else {
                stack.func_77964_b(0);
            }
        }
        return charge;
    }

    @Override
    public int getCharge(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return ElectricItem.manager.getCharge(itemStack) >= amount;
    }

    @Override
    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        ElectricItem.manager.chargeFromArmor(itemStack, entity);
        int transfer = ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, true);
        if (transfer == amount) {
            ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false);
            ElectricItem.manager.chargeFromArmor(itemStack, entity);
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        boolean inventoryChanged = false;
        for (int i = 0; i < 4; ++i) {
            IElectricItem armorItem;
            ItemStack armorItemStack = entity.func_71124_b(i + 1);
            if (armorItemStack == null || !(armorItemStack.func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) continue;
            int transfer = ElectricItem.manager.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            if ((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, false)) <= 0) continue;
            ElectricItem.manager.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        return ElectricItem.manager.getCharge(itemStack) + "/" + item.getMaxCharge(itemStack) + " EU";
    }
}

