/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.core.AdvRecipe;
import ic2.core.util.StackUtil;
import ic2.core.uu.IRecipeResolver;
import ic2.core.uu.RecipeTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;

public class VanillaCraftingResolver
implements IRecipeResolver {
    @Override
    public List<RecipeTransformation> getTransformations(ItemStack output) {
        assert (output.field_77994_a == 1) : output;
        ArrayList<RecipeTransformation> ret = new ArrayList<RecipeTransformation>();
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            ShapedRecipes recipe;
            if (irecipe instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)irecipe;
                if (!VanillaCraftingResolver.matches(recipe.func_77571_b(), output)) continue;
                ret.add(new RecipeTransformation(VanillaCraftingResolver.fixSize(AdvRecipe.expandArray(recipe.field_77574_d)), recipe.func_77571_b()));
                continue;
            }
            if (!(irecipe instanceof ShapelessRecipes) || !VanillaCraftingResolver.matches((recipe = (ShapelessRecipes)irecipe).func_77571_b(), output)) continue;
            ret.add(new RecipeTransformation(VanillaCraftingResolver.fixSize(AdvRecipe.expandArray(recipe.field_77579_b.toArray())), recipe.func_77571_b()));
        }
        return ret;
    }

    private static boolean matches(ItemStack offer, ItemStack requirement) {
        return offer.func_77973_b() == requirement.func_77973_b() && (requirement.func_77960_j() == Short.MAX_VALUE || offer.func_77960_j() == requirement.func_77960_j());
    }

    private static List<List<ItemStack>> fixSize(List<ItemStack>[] x) {
        ArrayList[] ret = new ArrayList[x.length];
        for (int i = 0; i < x.length; ++i) {
            ret[i] = new ArrayList();
            for (ItemStack stack : x[i]) {
                if (stack.field_77994_a == 1) {
                    ret[i].add(stack);
                    continue;
                }
                ret[i].add(StackUtil.copyWithSize(stack, 1));
            }
        }
        return Arrays.asList(ret);
    }
}

