/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import yalter.mousetweaks.Logger;

public class Config {
    private String fileName;
    private HashMap<String, Integer> Properties = new HashMap();

    public Config(String fileName) {
        this.fileName = fileName;
    }

    public boolean readConfig() {
        this.Properties.clear();
        try {
            File config = new File(this.fileName);
            if (!config.exists()) {
                return false;
            }
            FileReader fr = new FileReader(config);
            BufferedReader br = new BufferedReader(fr);
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                String[] strKeyValue = strLine.split("=");
                int l = strKeyValue.length;
                if (l < 2) continue;
                strKeyValue[0] = strKeyValue[0].trim();
                strKeyValue[1] = strKeyValue[1].trim();
                if (this.Properties.containsKey(strKeyValue[0])) {
                    Logger.Log("Duplicate property \"" + strKeyValue[0] + "\" in the config file, using the last value present");
                }
                this.Properties.put(strKeyValue[0], Integer.parseInt(strKeyValue[1]));
            }
            br.close();
            fr.close();
            int size = this.Properties.size();
            return size != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void saveConfig() {
        try {
            int size;
            File config = new File(this.fileName);
            if (!config.exists()) {
                config.getParentFile().mkdirs();
                config.createNewFile();
            }
            if ((size = this.Properties.size()) == 0) {
                return;
            }
            FileWriter fw = new FileWriter(config);
            BufferedWriter bw = new BufferedWriter(fw);
            for (String key : this.Properties.keySet()) {
                bw.write(key + " = " + this.Properties.get(key) + "\n");
            }
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            Logger.Log("Failed to write the config file: " + this.fileName);
            e.printStackTrace();
        }
    }

    public int getOrCreatePropertyValue(String name, int defaultValue) {
        if (this.Properties.containsKey(name)) {
            return this.Properties.get(name);
        }
        this.setPropertyValue(name, defaultValue);
        return defaultValue;
    }

    public int getPropertyValue(String name) {
        if (this.Properties.containsKey(name)) {
            return this.Properties.get(name);
        }
        return 0;
    }

    public void setPropertyValue(String name, int value) {
        this.Properties.put(name, value);
    }
}

