/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.crystalix.block;

import com.techshroom.crystalix.CCommonProxy;
import com.techshroom.crystalix.CrystalixMain;
import com.techshroom.crystalix.Util;
import com.techshroom.crystalix.tile.CrystalixMutatorTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrystalixMutator
extends BlockContainer {
    private final Random dropRand = new Random();
    private static final String base_name = "crystalix_mutate_";
    private static final String[] SIDECONS = new String[]{Util.createTextureString("minecraft", "iron_block"), Util.createTextureString("crystalix", "crystalix_mutate_top"), Util.createTextureString("crystalix", "crystalix_mutate_side"), Util.createTextureString("crystalix", "crystalix_mutate_side"), Util.createTextureString("crystalix", "crystalix_mutate_side"), Util.createTextureString("crystalix", "crystalix_mutate_side"), Util.createTextureString("crystalix", "crystalix_mutate_front")};
    private static final int FRONT = 6;
    public static CrystalixMutator m_ON;
    public static CrystalixMutator m_OFF;
    private static boolean blockMoving;
    private IIcon[] thisIconSet = null;
    private boolean burner = false;

    public CrystalixMutator(boolean burner) {
        super(Material.field_151573_f);
        if (!burner) {
            this.func_149647_a(CrystalixMain.tabBlocks);
        }
        this.burner = burner;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase base, ItemStack stack) {
        w.func_72921_c(x, y, z, Util.getMetadataForBlockOnlySided(base), 2);
        if (stack.func_82837_s()) {
            ((CrystalixMutatorTile)w.func_147438_o(x, y, z)).setInventoryName(stack.func_82833_r());
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xdist, float ydist, float zdist) {
        player.openGui((Object)CrystalixMain.instance, CCommonProxy.GUINDEX_MUTATOR, world, x, y, z);
        return true;
    }

    public static void setBurnState(boolean mutating, World w, int x, int y, int z, CrystalixMutatorTile cmt) {
        int meta = cmt.func_145832_p();
        blockMoving = true;
        if (mutating) {
            w.func_147465_d(x, y, z, (Block)m_ON, meta, 2);
        } else {
            w.func_147465_d(x, y, z, (Block)m_OFF, meta, 2);
        }
        blockMoving = false;
        cmt.func_145829_t();
        cmt.func_145836_u();
        w.func_147455_a(x, y, z, (TileEntity)cmt);
    }

    public TileEntity func_149915_a(World w, int meta) {
        return new CrystalixMutatorTile();
    }

    public IIcon func_149673_e(IBlockAccess ba, int x, int y, int z, int side) {
        CrystalixMutatorTile cmt = (CrystalixMutatorTile)ba.func_147438_o(x, y, z);
        if (cmt.func_145832_p() == side) {
            return this.thisIconSet[6];
        }
        return this.thisIconSet[side];
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 4) {
            return this.thisIconSet[6];
        }
        if (side == meta && meta != 0 && meta != 1) {
            return this.thisIconSet[6];
        }
        return this.thisIconSet[side];
    }

    public void func_149651_a(IIconRegister reg) {
        this.thisIconSet = new IIcon[7];
        String extend = this.burner ? "_on" : "_off";
        for (int i = 0; i < 7; ++i) {
            String base = SIDECONS[i];
            this.thisIconSet[i] = base.startsWith("crystalix") ? reg.func_94245_a(base + extend) : reg.func_94245_a(base);
        }
        super.func_149651_a(reg);
    }

    public void func_149749_a(World w, int x, int y, int z, Block b, int meta) {
        if (!blockMoving) {
            CrystalixMutatorTile cmt = (CrystalixMutatorTile)w.func_147438_o(x, y, z);
            int size = cmt.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack itemstack = cmt.func_70304_b(i);
                if (itemstack != null) {
                    float f = this.dropRand.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.dropRand.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.dropRand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int j1 = this.dropRand.nextInt(21) + 10;
                        if (j1 > itemstack.field_77994_a) {
                            j1 = itemstack.field_77994_a;
                        }
                        itemstack.field_77994_a -= j1;
                        EntityItem entityitem = new EntityItem(w, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                        if (itemstack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                        }
                        float f3 = 0.05f;
                        entityitem.field_70159_w = (float)this.dropRand.nextGaussian() * f3;
                        entityitem.field_70181_x = (float)this.dropRand.nextGaussian() * f3 + 0.2f;
                        entityitem.field_70179_y = (float)this.dropRand.nextGaussian() * f3;
                        w.func_72838_d((Entity)entityitem);
                    }
                }
                w.func_147453_f(x, y, z, b);
            }
        }
        super.func_149749_a(w, x, y, z, b, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random r) {
        if (((CrystalixMutatorTile)w.func_147438_o(x, y, z)).isPowdered()) {
            int meta = w.func_72805_g(x, y, z);
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + r.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = r.nextFloat() * 0.6f - 0.3f;
            String str = "iconcrack_" + Item.func_150891_b((Item)CrystalixMain.crystalixPowder) + "_0";
            if (meta == 4) {
                w.func_72869_a(str, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (meta == 5) {
                w.func_72869_a(str, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (meta == 2) {
                w.func_72869_a(str, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (meta == 3) {
                w.func_72869_a(str, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return Item.func_150898_a((Block)m_OFF);
    }

    static {
        blockMoving = false;
    }
}

