/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.crystalix.tile;

import com.techshroom.crystalix.CrystalixMain;
import com.techshroom.crystalix.Util;
import com.techshroom.crystalix.block.CrystalixGenerator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class CrystalixGeneratorTile
extends TileEntity
implements ISidedInventory {
    public static final int POWDER_TIME = Util.Time.secondsAsTicks(15);
    public static final int POWDER_TO_TIME_RATIO = 2;
    public static final int INPUTS = 2;
    public static final int INV_SIZE = 2;
    public static final int POWDER = 0;
    private String customName;
    private List<ItemStack> allSlots = null;
    private static final int[][] accessibleSlotsForSides = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]};
    public int genPowderTime;

    private void recreateList(int size) {
        this.allSlots = new ArrayList<ItemStack>(size);
        while (this.allSlots.size() < size) {
            this.allSlots.add(null);
        }
    }

    public CrystalixGeneratorTile() {
        this.recreateList(2);
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = null;
        ItemStack slotStack = this.allSlots.get(slot);
        if (slotStack != null) {
            if (slotStack.field_77994_a <= amt) {
                stack = slotStack;
                this.allSlots.set(slot, null);
                return stack;
            }
            stack = slotStack.func_77979_a(amt);
            if (slotStack.field_77994_a <= 0) {
                this.allSlots.set(slot, null);
            }
            return stack;
        }
        return null;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.crystalixGen";
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this.allSlots.get(slot);
    }

    public ItemStack func_70304_b(int slot) {
        if (this.allSlots.get(slot) != null) {
            ItemStack itemstack = this.allSlots.get(slot);
            this.allSlots.set(slot, null);
            return itemstack;
        }
        return null;
    }

    public int getPowderScaled(int i) {
        return this.genPowderTime * i / POWDER_TIME;
    }

    public boolean isPowdered() {
        return this.genPowderTime > 0;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() == CrystalixMain.crystalixPowder;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.allSlots.set(slot, stack);
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145845_h() {
        boolean needsSave = false;
        int tPlus = 2;
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean bl = flag = this.genPowderTime > 0;
            if (this.genPowderTime != 0 || this.canStart()) {
                // empty if block
            }
            if (this.canGen()) {
                this.genPowderTime += tPlus;
                if (this.genPowderTime >= this.genTime()) {
                    this.genPowderTime = 0;
                    this.useItem();
                }
                needsSave = true;
            } else if (!this.canGen()) {
                this.genPowderTime = 0;
            }
            if (flag != (this.genPowderTime > 0 || this.canStart())) {
                needsSave = true;
                CrystalixGenerator.setBurnState(this.genPowderTime > 0 || this.canStart(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
            }
        }
        if (needsSave) {
            this.func_70296_d();
        }
    }

    private int genTime() {
        return POWDER_TIME;
    }

    private void useItem() {
        if (this.canGen()) {
            ItemStack last = this.func_70301_a(0);
            last = new ItemStack(last.func_77973_b(), last.field_77994_a - 1, last.func_77960_j());
            if (last.field_77994_a == 0) {
                last = null;
            }
            this.func_70299_a(0, last);
        }
    }

    private boolean canStart() {
        return this.canGen();
    }

    private boolean canGen() {
        return this.allSlots.get(0) != null && this.allSlots.get(0).func_77973_b() == CrystalixMain.crystalixPowder;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.recreateList(this.func_70302_i_());
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.allSlots.size()) continue;
            this.allSlots.set(b0, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.genPowderTime = nbt.func_74765_d("powdertime");
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("powdertime", (short)this.genPowderTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.allSlots.size(); ++i) {
            ItemStack is = this.allSlots.get(i);
            if (is == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            is.func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    public int[] func_94128_d(int side) {
        return accessibleSlotsForSides[side];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        int[] slots;
        for (int s : slots = this.func_94128_d(side)) {
            if (s != slot) continue;
            return this.func_94041_b(s, item);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        int[] slots;
        for (int s : slots = this.func_94128_d(side)) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    static {
        CrystalixGeneratorTile.accessibleSlotsForSides[0] = new int[]{0};
    }
}

