/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.crystalix.tile;

import com.techshroom.crystalix.CrystalixMain;
import com.techshroom.crystalix.Util;
import com.techshroom.crystalix.block.CrystalixMutator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;

public class CrystalixMutatorTile
extends TileEntity
implements ISidedInventory {
    private static final int MUTATE_TIME_DYE = Util.Time.secondsAsTicks(100);
    public static final int MAX_SUNLIGHTS = 15;
    public static final int POWDER_TIME = Util.Time.secondsAsTicks(15);
    public static final int SUNLIGHT_TO_TIME_RATIO = 2;
    public static final double POWDER_EFFICIENCY = 2.0;
    public static final int MIN_SUNLIGHTS = 7;
    public static final int INPUTS = 2;
    public static final int OUTPUTS = 16;
    public static final int INV_SIZE = 18;
    public static final int DYE = 0;
    public static final int POWDER = 1;
    private static final Random rand = new Random();
    private String customName;
    private List<ItemStack> allSlots = null;
    private static final int[] right_access = new int[16];
    private static final int[][] accessibleSlotsForSides = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]};
    public int mutatorMutateTime;
    public int mutatorSunlights;
    public int mutatorPowderTime;

    private void recreateList(int size) {
        this.allSlots = new ArrayList<ItemStack>(size);
        while (this.allSlots.size() < size) {
            this.allSlots.add(null);
        }
    }

    public CrystalixMutatorTile() {
        this.recreateList(18);
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = null;
        ItemStack slotStack = this.allSlots.get(slot);
        if (slotStack != null) {
            if (slotStack.field_77994_a <= amt) {
                stack = slotStack;
                this.allSlots.set(slot, null);
                return stack;
            }
            stack = slotStack.func_77979_a(amt);
            if (slotStack.field_77994_a <= 0) {
                this.allSlots.set(slot, null);
            }
            return stack;
        }
        return null;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.crystalixMut";
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return 18;
    }

    public ItemStack func_70301_a(int slot) {
        return this.allSlots.get(slot);
    }

    public ItemStack func_70304_b(int slot) {
        if (this.allSlots.get(slot) != null) {
            ItemStack itemstack = this.allSlots.get(slot);
            this.allSlots.set(slot, null);
            return itemstack;
        }
        return null;
    }

    public int getSunlightsScaled(int i) {
        return (this.mutatorSunlights - 7) * i / 8;
    }

    public int getMutateProgressScaled(int i) {
        return this.mutatorMutateTime * i / this.mutateTime();
    }

    public int getPowderScaled(int i) {
        return this.mutatorPowderTime * i / POWDER_TIME;
    }

    public boolean hasSunlights() {
        return this.mutatorSunlights > 7;
    }

    public boolean isPowdered() {
        return this.mutatorPowderTime > 0;
    }

    public boolean mutating() {
        return this.mutatorMutateTime > 0;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 1 ? stack.func_77973_b() == CrystalixMain.crystalixIngot : (slot == 0 ? stack.func_77973_b() == Items.field_151100_aR : false);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.allSlots.set(slot, stack);
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145845_h() {
        int tPlus;
        boolean needsSave = false;
        if (!this.field_145850_b.field_73011_w.field_76576_e) {
            int currSunlights = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) - this.field_145850_b.field_73008_k;
            float celestiasRadians = this.field_145850_b.func_72929_e(1.0f);
            celestiasRadians = celestiasRadians < (float)Math.PI ? (celestiasRadians += (0.0f - celestiasRadians) * 0.2f) : (celestiasRadians += ((float)Math.PI * 2 - celestiasRadians) * 0.2f);
            currSunlights = Math.round((float)currSunlights * MathHelper.func_76134_b((float)celestiasRadians));
            if (currSunlights < 0) {
                currSunlights = 0;
            }
            if (currSunlights > 15) {
                currSunlights = 15;
            }
            this.mutatorSunlights = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e).func_149662_c() ? currSunlights : 0;
        }
        int n = tPlus = this.mutatorSunlights >= 7 ? (this.mutatorSunlights - 7 + 1) * 2 : 0;
        if (this.func_70301_a(1) != null && !this.isPowdered()) {
            this.func_70298_a(1, 1);
            this.mutatorPowderTime = POWDER_TIME + 1;
        }
        if (this.isPowdered()) {
            tPlus = (int)((double)tPlus * 2.0);
            --this.mutatorPowderTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean bl = flag = this.mutatorMutateTime > 0;
            if (this.mutatorMutateTime != 0 || this.canStart()) {
                // empty if block
            }
            if (this.hasSunlights() && this.canMutate()) {
                this.mutatorMutateTime += tPlus;
                if (this.mutatorMutateTime >= this.mutateTime()) {
                    this.mutatorMutateTime = 0;
                    this.mutateItem();
                }
                needsSave = true;
            } else if (!this.canMutate()) {
                this.mutatorMutateTime = 0;
            }
            if (flag != (this.mutatorMutateTime > 0 || this.canStart())) {
                needsSave = true;
                CrystalixMutator.setBurnState(this.mutatorMutateTime > 0 || this.canStart(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
            }
        }
        if (needsSave) {
            this.func_70296_d();
        }
    }

    private int mutateTime() {
        return MUTATE_TIME_DYE;
    }

    private void mutateItem() {
        if (this.canMutate()) {
            int slot_n_meta = rand.nextInt(16);
            int count = 1;
            ItemStack currentStack = this.func_70301_a(slot_n_meta + 2);
            if (currentStack != null) {
                count += currentStack.field_77994_a;
            }
            ItemStack last = this.func_70301_a(0);
            ItemStack nis = new ItemStack(last.func_77973_b(), count, slot_n_meta);
            last = new ItemStack(last.func_77973_b(), last.field_77994_a - 1, last.func_77960_j());
            if (last.field_77994_a == 0) {
                last = null;
            }
            this.func_70299_a(0, last);
            this.func_70299_a(slot_n_meta + 2, nis);
        }
    }

    private boolean canStart() {
        return this.canMutate();
    }

    private boolean canMutate() {
        return this.allSlots.get(0) != null && this.allSlots.get(0).func_77973_b() == Items.field_151100_aR;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.recreateList(this.func_70302_i_());
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.allSlots.size()) continue;
            this.allSlots.set(b0, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.mutatorMutateTime = nbt.func_74765_d("mutatetime");
        this.mutatorPowderTime = nbt.func_74765_d("powdertime");
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mutatetime", (short)this.mutatorMutateTime);
        nbt.func_74777_a("powdertime", (short)this.mutatorPowderTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.allSlots.size(); ++i) {
            ItemStack is = this.allSlots.get(i);
            if (is == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            is.func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    public int[] func_94128_d(int side) {
        if (side == 1 || side == 0) {
            return accessibleSlotsForSides[side];
        }
        return right_access;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        int[] slots;
        for (int s : slots = this.func_94128_d(side)) {
            if (s != slot) continue;
            return this.func_94041_b(s, item);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        int[] slots;
        for (int s : slots = this.func_94128_d(side)) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    static {
        CrystalixMutatorTile.accessibleSlotsForSides[1] = new int[]{0};
        CrystalixMutatorTile.accessibleSlotsForSides[0] = new int[]{1};
        for (int i = 0; i < right_access.length; ++i) {
            CrystalixMutatorTile.right_access[i] = i + 2;
        }
    }
}

