/*
 * Decompiled with CFR 0.152.
 */
package rpgInventory.block.te;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import rpgInventory.block.BlockForge;
import rpgInventory.block.te.MoldRecipes;
import rpgInventory.item.ItemMold;
import rpgInventory.item.armor.ItemRpgInvArmor;

public class TEMold
extends TileEntity
implements IInventory {
    private static Map<Item, Integer> toBurn = new HashMap<Item, Integer>();
    private static Map<Block, Integer> BlocktoBurn = new HashMap<Block, Integer>();
    private ItemStack[] moldforgeItemStacks = new ItemStack[5];
    public int goldBurnTime = 0;
    private boolean isActive;
    public int goldItemBurnTime = 0;
    public int goldCookTime = 0;
    public int front;
    private int smeltTime = 800;

    public static void addFuelBlock(Block b, int time) {
        for (Block c : BlocktoBurn.keySet()) {
            if (!BlocktoBurn.containsKey(c)) continue;
            return;
        }
        BlocktoBurn.put(b, time);
    }

    public static void addFuelItem(Item i, int time) {
        for (Item c : toBurn.keySet()) {
            if (!toBurn.containsKey(i)) continue;
            return;
        }
        toBurn.put(i, time);
    }

    public static int getItemTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        Item var1 = Items.field_151034_e;
        if (par0ItemStack.func_77973_b() != null) {
            var1 = par0ItemStack.func_77973_b();
        }
        for (Item i : toBurn.keySet()) {
            if (var1 != i) continue;
            return toBurn.get(i);
        }
        for (Block b : BlocktoBurn.keySet()) {
            if (var1 != Item.func_150898_a((Block)b)) continue;
            return toBurn.get(b);
        }
        return 0;
    }

    public static boolean isGoldBlock(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150340_R;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TEMold.getItemTime(stack) > 0;
    }

    public static boolean isMineral(ItemStack stack) {
        if (stack.func_77973_b() != null) {
            if (stack.func_77973_b().equals(Items.field_151166_bC)) {
                return true;
            }
            if (stack.func_77973_b().equals(Items.field_151045_i)) {
                return true;
            }
            if (stack.func_77973_b().equals(Items.field_151043_k)) {
                return true;
            }
            if (stack.func_77973_b() instanceof ItemDye && stack.func_77960_j() == 4) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMold(ItemStack stack) {
        return stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemMold;
    }

    private boolean canSmelt() {
        if (this.moldforgeItemStacks[0] == null && this.moldforgeItemStacks[1] == null) {
            return false;
        }
        ItemStack result = null;
        ItemStack mineral = null;
        ItemStack mold = null;
        ItemStack block = null;
        if (this.moldforgeItemStacks[1] != null) {
            if (this.moldforgeItemStacks[2] != null && this.moldforgeItemStacks[3] != null && this.moldforgeItemStacks[1] != null) {
                mold = this.moldforgeItemStacks[2];
                mineral = this.moldforgeItemStacks[3];
                block = this.moldforgeItemStacks[1];
                if (mineral != null) {
                    if (mineral.func_77973_b() instanceof ItemDye) {
                        if (mineral.func_77960_j() == 4) {
                            result = MoldRecipes.getSmeltingResult(mineral.func_77973_b(), mold.func_77973_b(), Block.func_149634_a((Item)block.func_77973_b()));
                        }
                    } else {
                        result = MoldRecipes.getSmeltingResult(mineral.func_77973_b(), mold.func_77973_b(), Block.func_149634_a((Item)block.func_77973_b()));
                    }
                }
            }
            if (result == null && this.moldforgeItemStacks[2] != null && this.moldforgeItemStacks[3] != null && this.moldforgeItemStacks[1] != null) {
                mold = this.moldforgeItemStacks[2];
                mineral = this.moldforgeItemStacks[3];
                block = this.moldforgeItemStacks[1];
                if (mineral != null) {
                    if (mineral.func_77973_b() instanceof ItemDye) {
                        if (mineral.func_77960_j() == 4) {
                            result = MoldRecipes.getSmeltingResult(mineral.func_77973_b(), mold.func_77973_b(), Block.func_149634_a((Item)block.func_77973_b()));
                        }
                    } else {
                        result = MoldRecipes.getSmeltingResult(mineral.func_77973_b(), mold.func_77973_b(), Block.func_149634_a((Item)block.func_77973_b()));
                    }
                }
            }
        }
        if (result == null) {
            return false;
        }
        if (this.moldforgeItemStacks[4] == null) {
            return true;
        }
        if (!this.moldforgeItemStacks[4].func_77969_a(result)) {
            return false;
        }
        if (this.moldforgeItemStacks[4].field_77994_a < this.func_70297_j_() && this.moldforgeItemStacks[4].field_77994_a < this.moldforgeItemStacks[4].func_77976_d()) {
            return true;
        }
        return this.moldforgeItemStacks[4].field_77994_a < result.func_77976_d();
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public int getFrontDirection() {
        return this.front;
    }

    public String func_145825_b() {
        return "Mold Forge";
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getProgressScaled(int i) {
        return this.goldCookTime * i / this.smeltTime;
    }

    public int func_70302_i_() {
        return this.moldforgeItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.moldforgeItemStacks[slot];
    }

    public ItemStack func_70304_b(int slot) {
        if (this.moldforgeItemStacks[slot] != null) {
            ItemStack var2 = this.moldforgeItemStacks[slot];
            this.moldforgeItemStacks[slot] = null;
            return var2;
        }
        return null;
    }

    public int getTimeRemainingScaled(int i) {
        if (this.goldItemBurnTime == 0) {
            this.goldItemBurnTime = 100;
        }
        return this.goldBurnTime * i / this.goldItemBurnTime;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isBurning() {
        return this.goldBurnTime > 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void produceJewel() {
        if (this.canSmelt()) {
            ItemStack stack;
            ItemStack mineral = null;
            ItemStack mold = null;
            ItemStack block = null;
            if (this.moldforgeItemStacks[2] != null && this.moldforgeItemStacks[3] != null && this.moldforgeItemStacks[1] != null) {
                mold = this.moldforgeItemStacks[2];
                mineral = this.moldforgeItemStacks[3];
                block = this.moldforgeItemStacks[1];
            }
            if ((stack = MoldRecipes.getSmeltingResult(mineral.func_77973_b(), mold.func_77973_b(), Block.func_149634_a((Item)block.func_77973_b()))) == null) {
                stack = MoldRecipes.getSmeltingResult(mineral.func_77973_b(), mold.func_77973_b(), Block.func_149634_a((Item)block.func_77973_b()));
            }
            if (this.moldforgeItemStacks[4] == null) {
                this.moldforgeItemStacks[4] = stack.func_77946_l();
            } else if (this.moldforgeItemStacks[4] == stack) {
                ++this.moldforgeItemStacks[4].field_77994_a;
            }
            if (this.moldforgeItemStacks[3].field_77994_a > 1) {
                --this.moldforgeItemStacks[3].field_77994_a;
            } else {
                this.moldforgeItemStacks[3] = null;
            }
            if (this.moldforgeItemStacks[2].field_77994_a > 1) {
                --this.moldforgeItemStacks[2].field_77994_a;
            } else if (!(this.moldforgeItemStacks[2].func_77973_b() instanceof ItemRpgInvArmor)) {
                this.moldforgeItemStacks[2] = null;
            }
            if (this.moldforgeItemStacks[1].field_77994_a > 1) {
                --this.moldforgeItemStacks[1].field_77994_a;
            } else {
                this.moldforgeItemStacks[1] = null;
            }
            if (this.moldforgeItemStacks[0] != null && this.moldforgeItemStacks[0].field_77994_a == 0) {
                Item i = this.moldforgeItemStacks[0].func_77973_b().func_77668_q();
                this.moldforgeItemStacks[0] = i == null ? null : new ItemStack(i);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.moldforgeItemStacks.length) continue;
            this.moldforgeItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.front = tagCompound.func_74762_e("FrontDirection");
        this.goldBurnTime = tagCompound.func_74765_d("BurnTime");
        this.goldCookTime = tagCompound.func_74765_d("CookTime");
        this.goldItemBurnTime = TEMold.getItemTime(this.moldforgeItemStacks[0]);
    }

    public void setFrontDirection(int f) {
        this.front = f;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.moldforgeItemStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145845_h() {
        Block b;
        boolean var1 = this.goldBurnTime > 0;
        boolean var2 = false;
        if (this.goldBurnTime > 0) {
            --this.goldBurnTime;
        }
        if (this.goldBurnTime == 0 && this.canSmelt()) {
            this.goldItemBurnTime = this.goldBurnTime = TEMold.getItemTime(this.moldforgeItemStacks[0]);
            if (this.goldBurnTime > 0) {
                var2 = true;
                if (this.moldforgeItemStacks[0] != null) {
                    --this.moldforgeItemStacks[0].field_77994_a;
                    if (this.moldforgeItemStacks[0].field_77994_a == 0) {
                        Item var3 = this.moldforgeItemStacks[0].func_77973_b().func_77668_q();
                        ItemStack itemStack = this.moldforgeItemStacks[0] = var3 == null ? null : new ItemStack(var3);
                    }
                }
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.goldCookTime;
            if (this.goldCookTime == this.smeltTime) {
                this.goldCookTime = 0;
                this.produceJewel();
                var2 = true;
            }
        } else {
            this.goldCookTime = 0;
        }
        if (var1 != this.goldBurnTime > 0) {
            var2 = true;
        }
        if (this.isActive() != this.isBurning()) {
            this.isActive = this.isBurning();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (var2) {
            this.func_70296_d();
        }
        if ((b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)) instanceof BlockForge) {
            BlockForge f = (BlockForge)b;
            f.isBurning = this.isBurning();
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.moldforgeItemStacks.length; ++i) {
            ItemStack stack = this.moldforgeItemStacks[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74768_a("FrontDirection", this.front);
        tagCompound.func_74777_a("BurnTime", (short)this.goldBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.goldCookTime);
    }
}

