/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import vazkii.botania.api.internal.DummyMethodHandler;
import vazkii.botania.api.internal.DummySubTile;
import vazkii.botania.api.internal.IInternalMethodHandler;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.api.subtile.SubTileEntity;

public final class BotaniaAPI {
    private static List<LexiconCategory> categories = new ArrayList<LexiconCategory>();
    private static List<LexiconEntry> allEntries = new ArrayList<LexiconEntry>();
    public static List<RecipePetals> petalRecipes = new ArrayList<RecipePetals>();
    public static List<RecipeRuneAltar> runeAltarRecipes = new ArrayList<RecipeRuneAltar>();
    public static List<RecipeManaInfusion> manaInfusionRecipes = new ArrayList<RecipeManaInfusion>();
    private static BiMap<String, Class<? extends SubTileEntity>> subTiles = HashBiMap.create();
    public static Map<String, Integer> oreWeights = new HashMap<String, Integer>();
    public static IInternalMethodHandler internalHandler;

    public static RecipePetals registerPetalRecipe(ItemStack output, Object ... inputs) {
        RecipePetals recipe = new RecipePetals(output, inputs);
        petalRecipes.add(recipe);
        return recipe;
    }

    public static RecipeRuneAltar registerRuneAltarRecipe(ItemStack output, int mana, Object ... inputs) {
        RecipeRuneAltar recipe = new RecipeRuneAltar(output, mana, inputs);
        runeAltarRecipes.add(recipe);
        return recipe;
    }

    public static RecipeManaInfusion registerManaInfusionRecipe(ItemStack output, Object input, int mana) {
        RecipeManaInfusion recipe = new RecipeManaInfusion(output, input, mana);
        manaInfusionRecipes.add(recipe);
        return recipe;
    }

    public static void registerSubTile(String key, Class<? extends SubTileEntity> subtileClass) {
        subTiles.put((Object)key, subtileClass);
    }

    public static void addCategory(LexiconCategory category) {
        categories.add(category);
    }

    public static List<LexiconCategory> getAllCategories() {
        return categories;
    }

    public static void addEntry(LexiconEntry entry, LexiconCategory category) {
        allEntries.add(entry);
        category.entries.add(entry);
    }

    public static void addOreWeight(String ore, int weight) {
        oreWeights.put(ore, weight);
    }

    public static int getOreWeight(String ore) {
        return oreWeights.get(ore);
    }

    public static IRecipe getLatestAddedRecipe() {
        List list = CraftingManager.func_77594_a().func_77592_b();
        return (IRecipe)list.get(list.size() - 1);
    }

    public static List<IRecipe> getLatestAddedRecipes(int x) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> newList = new ArrayList<IRecipe>();
        for (int i = x - 1; i >= 0; --i) {
            newList.add((IRecipe)list.get(list.size() - 1 - i));
        }
        return newList;
    }

    public static Class<? extends SubTileEntity> getSubTileMapping(String key) {
        if (!subTiles.containsKey((Object)key)) {
            key = "";
        }
        return (Class)subTiles.get((Object)key);
    }

    public static String getSubTileStringMapping(Class<? extends SubTileEntity> clazz) {
        return (String)subTiles.inverse().get(clazz);
    }

    static {
        BotaniaAPI.registerSubTile("", DummySubTile.class);
        BotaniaAPI.addOreWeight("oreAluminum", 3940);
        BotaniaAPI.addOreWeight("oreAmber", 2075);
        BotaniaAPI.addOreWeight("oreApatite", 1595);
        BotaniaAPI.addOreWeight("oreBlueTopaz", 3195);
        BotaniaAPI.addOreWeight("oreCassiterite", 1634);
        BotaniaAPI.addOreWeight("oreCertusQuartz", 3975);
        BotaniaAPI.addOreWeight("oreChimerite", 3970);
        BotaniaAPI.addOreWeight("oreCinnabar", 2585);
        BotaniaAPI.addOreWeight("oreCoal", 46525);
        BotaniaAPI.addOreWeight("oreCooperite", 5);
        BotaniaAPI.addOreWeight("oreCopper", 8325);
        BotaniaAPI.addOreWeight("oreDarkIron", 1700);
        BotaniaAPI.addOreWeight("oreDiamond", 1265);
        BotaniaAPI.addOreWeight("oreEmerald", 780);
        BotaniaAPI.addOreWeight("oreEmery", 415);
        BotaniaAPI.addOreWeight("oreGalena", 1000);
        BotaniaAPI.addOreWeight("oreGold", 2970);
        BotaniaAPI.addOreWeight("oreInfusedAir", 925);
        BotaniaAPI.addOreWeight("oreInfusedEarth", 925);
        BotaniaAPI.addOreWeight("oreInfusedEntropy", 925);
        BotaniaAPI.addOreWeight("oreInfusedFire", 925);
        BotaniaAPI.addOreWeight("oreInfusedOrder", 925);
        BotaniaAPI.addOreWeight("oreInfusedWater", 925);
        BotaniaAPI.addOreWeight("oreIridium", 30);
        BotaniaAPI.addOreWeight("oreIron", 20665);
        BotaniaAPI.addOreWeight("oreLapis", 1285);
        BotaniaAPI.addOreWeight("oreLead", 7985);
        BotaniaAPI.addOreWeight("oreMCropsEssence", 3085);
        BotaniaAPI.addOreWeight("oreNickel", 2275);
        BotaniaAPI.addOreWeight("oreOlivine", 1100);
        BotaniaAPI.addOreWeight("oreRedstone", 6885);
        BotaniaAPI.addOreWeight("oreRuby", 1100);
        BotaniaAPI.addOreWeight("oreSapphire", 1100);
        BotaniaAPI.addOreWeight("oreSilver", 6300);
        BotaniaAPI.addOreWeight("oreSphalerite", 25);
        BotaniaAPI.addOreWeight("oreSulfur", 1105);
        BotaniaAPI.addOreWeight("oreTetrahedrite", 4040);
        BotaniaAPI.addOreWeight("oreTin", 9450);
        BotaniaAPI.addOreWeight("oreTungstate", 20);
        BotaniaAPI.addOreWeight("oreUranium", 1337);
        BotaniaAPI.addOreWeight("oreVinteum", 5925);
        BotaniaAPI.addOreWeight("oreYellorite", 3520);
        internalHandler = new DummyMethodHandler();
    }
}

