/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.GuiLexiconEntry;
import vazkii.botania.common.lexicon.page.PageText;

public class PageRecipe
extends LexiconPage {
    int relativeMouseX;
    int relativeMouseY;
    ItemStack tooltipStack;
    ItemStack tooltipContainerStack;
    boolean tooltipEntry;

    public PageRecipe(String unlocalizedName) {
        super(unlocalizedName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        this.relativeMouseX = mx;
        this.relativeMouseY = my;
        this.renderRecipe(gui, mx, my);
        int width = gui.getWidth() - 30;
        int height = gui.getHeight();
        int x = gui.getLeft() + 16;
        int y = gui.getTop() + height - 40;
        PageText.renderText(x, y, width, height, this.getUnlocalizedName());
        if (this.tooltipStack != null) {
            List tooltipData = this.tooltipStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            RenderHelper.renderTooltip(mx, my, tooltipData);
            int tooltipY = 8 + tooltipData.size() * 11;
            if (this.tooltipEntry) {
                RenderHelper.renderTooltipOrange(mx, my + tooltipY, Arrays.asList(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"botaniamisc.clickToRecipe")));
                tooltipY += 18;
            }
            if (this.tooltipContainerStack != null) {
                RenderHelper.renderTooltipGreen(mx, my + tooltipY, Arrays.asList(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"botaniamisc.craftingContainer"), this.tooltipContainerStack.func_82833_r()));
            }
        }
        this.tooltipContainerStack = null;
        this.tooltipStack = null;
        this.tooltipEntry = false;
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtAngle(IGuiLexiconEntry gui, int angle, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if ((stack = stack.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        int radius = 32;
        double xPos = (double)gui.getLeft() + Math.cos((double)(angle -= 90) * Math.PI / 180.0) * (double)radius + (double)(gui.getWidth() / 2) - 8.0;
        double yPos = (double)gui.getTop() + Math.sin((double)angle * Math.PI / 180.0) * (double)radius + 53.0;
        ItemStack stack1 = stack.func_77946_l();
        if (stack1.func_77960_j() == -1) {
            stack1.func_77964_b(0);
        }
        this.renderItem(gui, (int)xPos, (int)yPos, stack1, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtGridPos(IGuiLexiconEntry gui, int x, int y, ItemStack stack, boolean accountForContainer) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if ((stack = stack.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        int xPos = gui.getLeft() + x * 29 + 7 + (y == 0 && x == 3 ? 10 : 0);
        int yPos = gui.getTop() + y * 29 + 24 - (y == 0 ? 7 : 0);
        ItemStack stack1 = stack.func_77946_l();
        if (stack1.func_77960_j() == -1) {
            stack1.func_77964_b(0);
        }
        this.renderItem(gui, xPos, yPos, stack1, accountForContainer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IGuiLexiconEntry gui, int xPos, int yPos, ItemStack stack, boolean accountForContainer) {
        RenderItem render = new RenderItem();
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
        if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)new RenderBlocks(), (TextureManager)renderEngine, (ItemStack)stack, (boolean)render.field_77024_a, (float)gui.getZLevel(), (float)xPos, (float)yPos)) {
            render.func_77015_a(fontRenderer, renderEngine, stack, xPos, yPos);
        }
        render.func_77021_b(fontRenderer, renderEngine, stack, xPos, yPos);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        if (this.relativeMouseX >= xPos && this.relativeMouseY >= yPos && this.relativeMouseX <= xPos + 16 && this.relativeMouseY <= yPos + 16) {
            ItemStack containerStack;
            this.tooltipStack = stack;
            LexiconRecipeMappings.EntryData data = LexiconRecipeMappings.getDataForStack(this.tooltipStack);
            if (data != null && (data.entry != gui.getEntry() || data.page != gui.getPageOn())) {
                this.tooltipEntry = true;
                if (Mouse.isButtonDown((int)0) && GuiScreen.func_146272_n()) {
                    GuiLexiconEntry newGui = new GuiLexiconEntry(data.entry, (GuiScreen)gui);
                    newGui.page = data.page;
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)newGui);
                }
            }
            if (accountForContainer && (containerStack = stack.func_77973_b().getContainerItem(stack)) != null && containerStack.func_77973_b() != null) {
                this.tooltipContainerStack = containerStack;
            }
        }
        GL11.glDisable((int)2896);
    }
}

