/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.ITileBound;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.common.block.tile.TileMod;

public class TileSpecialFlower
extends TileMod
implements ITileBound {
    private static final String TAG_SUBTILE_NAME = "subTileName";
    private static final String TAG_SUBTILE_CMP = "subTileCmp";
    public String subTileName = "";
    SubTileEntity subTile;

    public void setSubTile(String name) {
        this.subTileName = name;
        this.provideSubTile(this.subTileName);
    }

    public void setSubTile(SubTileEntity tile) {
        this.subTile = tile;
        this.subTile.setSupertile(this);
    }

    private void provideSubTile(String name) {
        this.subTileName = name;
        Class<? extends SubTileEntity> tileClass = BotaniaAPI.getSubTileMapping(name);
        try {
            SubTileEntity tile = tileClass.newInstance();
            this.setSubTile(tile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_145845_h() {
        if (this.subTile != null) {
            this.subTile.onUpdate();
        }
    }

    public boolean canUpdate() {
        return this.subTile == null || this.subTile.canUpdate();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        super.writeCustomNBT(cmp);
        cmp.func_74778_a(TAG_SUBTILE_NAME, this.subTileName);
        NBTTagCompound subCmp = new NBTTagCompound();
        cmp.func_74782_a(TAG_SUBTILE_CMP, (NBTBase)subCmp);
        this.subTile.writeToPacketNBT(subCmp);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        super.readCustomNBT(cmp);
        this.subTileName = cmp.func_74779_i(TAG_SUBTILE_NAME);
        NBTTagCompound subCmp = cmp.func_74775_l(TAG_SUBTILE_CMP);
        if (this.subTile == null || !BotaniaAPI.getSubTileStringMapping(this.subTile.getClass()).equals(this.subTileName)) {
            this.provideSubTile(this.subTileName);
        }
        this.subTile.readFromPacketNBT(subCmp);
    }

    public IIcon getIcon() {
        return this.subTile == null ? Blocks.field_150328_O.func_149691_a(0, 0) : this.subTile.getIcon();
    }

    public LexiconEntry getEntry() {
        return this.subTile.getEntry();
    }

    public boolean onWanded(ItemStack wand, EntityPlayer player) {
        return this.subTile.onWanded(player, wand);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        if (this.subTile != null) {
            this.subTile.renderHUD(mc, res);
        }
    }

    @Override
    public ChunkCoordinates getBinding() {
        if (this.subTile == null) {
            return null;
        }
        return this.subTile.getBinding();
    }
}

