/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigHandler {
    private static Configuration config;
    public static boolean lexiconRotatingItems;
    public static boolean subtlePowerSystem;
    public static boolean staticWandBeam;
    public static boolean boundBlockWireframe;
    public static boolean lexicon3dModel;
    public static int flowerQuantity;
    public static int flowerDensity;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        Property lexiconRotatingItemsProp = config.get("general", "lexicon.enable.rotatingItems", true);
        lexiconRotatingItemsProp.comment = "Set to false to disable the rotating items in the petal and rune entries in the Lexica Botania.";
        lexiconRotatingItems = lexiconRotatingItemsProp.getBoolean(true);
        Property subtlePowerSystemProp = config.get("general", "powerSystem.subtle", false);
        subtlePowerSystemProp.comment = "Set to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.";
        subtlePowerSystem = subtlePowerSystemProp.getBoolean(false);
        Property staticWandBeamProp = config.get("general", "wandBeam.static", false);
        staticWandBeamProp.comment = "Set to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old botania versions. Warning: Disabled by default because it may be laggy.";
        staticWandBeam = staticWandBeamProp.getBoolean(false);
        Property boundBlockWireframeProp = config.get("general", "boundBlock.wireframe.enabled", true);
        boundBlockWireframeProp.comment = "Set to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).";
        boundBlockWireframe = boundBlockWireframeProp.getBoolean(true);
        Property lexicon3dModelProp = config.get("general", "lexicon.render.3D", true);
        lexicon3dModelProp.comment = "Set to false to disabled the animated 3D render for the lexica botania";
        lexicon3dModel = lexicon3dModelProp.getBoolean(true);
        Property propFlowerQuantity = config.get("general", "worldgen.flower.quantity", 3);
        flowerQuantity = propFlowerQuantity.getInt(3);
        Property propFlowerDensity = config.get("general", "worldgen.flower.density", 32);
        flowerDensity = propFlowerDensity.getInt(32);
        config.save();
    }

    static {
        lexiconRotatingItems = true;
        subtlePowerSystem = false;
        staticWandBeam = false;
        boundBlockWireframe = true;
        lexicon3dModel = true;
        flowerQuantity = 3;
        flowerDensity = 32;
    }
}

