/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import vazkii.botania.common.block.ModBlocks;

public class WorldTreeGenerator {
    World world;
    int srcx;
    int srcy;
    int srcz;
    int x;
    int y;
    int z;
    int blocksPlaced;

    public WorldTreeGenerator(World world, int srcx, int srcy, int srcz) {
        this.world = world;
        this.srcx = srcx;
        this.srcy = srcy;
        this.srcz = srcz;
    }

    public void generate() {
        for (int i = 0; i < 116; ++i) {
            this.generateRing(i, (int)Math.sqrt(256 - (Math.min(i, 64) - 5) * 2));
        }
        System.out.println("Blocks Placed: " + this.blocksPlaced);
    }

    public void generateRing(int yoff, int radius) {
        int angle;
        int meta;
        int j;
        int i;
        Block block = ModBlocks.livingwood;
        this.y = yoff;
        for (int i2 = 0; i2 < 360; ++i2) {
            if (i2 % 90 == 0) continue;
            int meta2 = this.world.field_73012_v.nextInt(200) == 0 ? 5 : 0;
            this.generateRingVal(radius, i2, block, meta2);
        }
        int mul = 4;
        for (i = 0; i < mul; ++i) {
            for (j = 0; j < mul; ++j) {
                meta = this.world.field_73012_v.nextInt(4) == 0 ? 5 : 0;
                angle = (this.y - j) * mul % 360;
                this.generateRingVal(radius - i - 3, angle, block, meta);
                this.generateRingVal(radius - i - 3, angle + 180, block, meta);
            }
        }
        mul = 3;
        for (i = 0; i < mul; ++i) {
            for (j = 0; j < mul; ++j) {
                meta = this.world.field_73012_v.nextInt(20) == 0 ? 5 : 0;
                angle = (this.y - j) * mul % 360;
                this.generateRingVal(radius + i - 1, angle + 90, block, meta);
                this.generateRingVal(radius + i - 1, angle + 270, block, meta);
            }
        }
    }

    public void generateRingVal(int radius, int angle, Block block, int meta) {
        int nx = (int)(Math.cos((double)angle * Math.PI / 180.0) * (double)radius);
        int nz = (int)(Math.sin((double)angle * Math.PI / 180.0) * (double)radius);
        if (this.x != nx || this.z != nz) {
            this.x = nx;
            this.z = nz;
            this.place(this.srcx + this.x, this.srcy + this.y, this.srcz + this.z, block, meta);
        }
    }

    public void place(int x, int y, int z, Block block, int meta) {
        this.world.func_147465_d(x, y, z, block, meta, 2);
        ++this.blocksPlaced;
    }
}

