/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica;

import com.github.lunatrius.schematica.SchematicWorld;
import com.github.lunatrius.schematica.client.gui.GuiSchematicControl;
import com.github.lunatrius.schematica.client.gui.GuiSchematicLoad;
import com.github.lunatrius.schematica.client.gui.GuiSchematicSave;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunk;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.vector.Vector3f;

public class Settings {
    private static final Settings instance = new Settings();
    public boolean enableAlpha = false;
    public float alpha = 1.0f;
    public boolean highlight = true;
    public boolean highlightAir = true;
    public float blockDelta = 0.005f;
    public int placeDelay = 1;
    public boolean placeInstantly = false;
    public boolean placeAdjacent = true;
    public boolean drawQuads = true;
    public boolean drawLines = true;
    public KeyBinding[] keyBindings = new KeyBinding[]{new KeyBinding("schematica.key.load", 181, "schematica.key.category"), new KeyBinding("schematica.key.save", 55, "schematica.key.category"), new KeyBinding("schematica.key.control", 74, "schematica.key.category")};
    public static final String sbcDisablePrinter = "\u00a70\u00a72\u00a70\u00a70\u00a7e\u00a7f";
    public static final String sbcDisableSave = "\u00a70\u00a72\u00a71\u00a70\u00a7e\u00a7f";
    public static final String sbcDisableLoad = "\u00a70\u00a72\u00a71\u00a71\u00a7e\u00a7f";
    public static final File schematicDirectory = new File(Minecraft.func_71410_x().field_71412_D, "/schematics/");
    public static final File textureDirectory = new File(Minecraft.func_71410_x().field_71412_D, "/resources/mod/schematica/");
    public static Logger logger;
    public static final RenderItem renderItem;
    public static final ItemStack defaultIcon;
    private final Vector3f translationVector = new Vector3f();
    public Minecraft minecraft = Minecraft.func_71410_x();
    public ChunkCache mcWorldCache = null;
    public SchematicWorld schematic = null;
    public Vector3f playerPosition = new Vector3f();
    public RendererSchematicChunk[][][] rendererSchematicChunk = null;
    public final List<RendererSchematicChunk> sortedRendererSchematicChunk = new ArrayList<RendererSchematicChunk>();
    public RenderBlocks renderBlocks = null;
    public Vector3f pointA = new Vector3f();
    public Vector3f pointB = new Vector3f();
    public Vector3f pointMin = new Vector3f();
    public Vector3f pointMax = new Vector3f();
    public int rotationRender = 0;
    public int orientation = 0;
    public Vector3f offset = new Vector3f();
    public boolean isRenderingSchematic = false;
    public int renderingLayer = -1;
    public boolean isRenderingGuide = false;
    public int chatLines = 0;
    public boolean isPrinterEnabled = true;
    public boolean isSaveEnabled = true;
    public boolean isLoadEnabled = true;
    public boolean isPrinting = false;
    public int[] increments = new int[]{1, 5, 15, 50, 250};

    private Settings() {
    }

    public static Settings instance() {
        return instance;
    }

    public void reset() {
        this.chatLines = 0;
        this.isPrinterEnabled = true;
        this.isSaveEnabled = true;
        this.isLoadEnabled = true;
        this.isRenderingSchematic = false;
        this.isRenderingGuide = false;
        this.schematic = null;
        this.renderBlocks = null;
        this.rendererSchematicChunk = null;
        this.mcWorldCache = null;
    }

    public void keyboardEvent(KeyBinding keybinding) {
        if (this.minecraft.field_71462_r == null) {
            for (int i = 0; i < this.keyBindings.length; ++i) {
                if (keybinding != this.keyBindings[i]) continue;
                this.keyboardEvent(i);
                break;
            }
        }
    }

    public void keyboardEvent(int key) {
        switch (key) {
            case 0: {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicLoad(this.minecraft.field_71462_r));
                break;
            }
            case 1: {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicSave(this.minecraft.field_71462_r));
                break;
            }
            case 2: {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicControl(this.minecraft.field_71462_r));
            }
        }
    }

    public void createRendererSchematicChunk() {
        int width = (this.schematic.width() - 1) / 16 + 1;
        int height = (this.schematic.height() - 1) / 16 + 1;
        int length = (this.schematic.length() - 1) / 16 + 1;
        this.rendererSchematicChunk = new RendererSchematicChunk[width][height][length];
        while (this.sortedRendererSchematicChunk.size() > 0) {
            this.sortedRendererSchematicChunk.remove(0).delete();
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    RendererSchematicChunk rendererSchematicChunk = new RendererSchematicChunk(this.schematic, x, y, z);
                    this.rendererSchematicChunk[x][y][z] = rendererSchematicChunk;
                    this.sortedRendererSchematicChunk.add(rendererSchematicChunk);
                }
            }
        }
    }

    public boolean loadSchematic(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            if (tagCompound != null) {
                this.schematic = new SchematicWorld();
                this.schematic.readFromNBT(tagCompound);
                logger.info(String.format("Loaded %s [w:%d,h:%d,l:%d]", filename, this.schematic.width(), this.schematic.height(), this.schematic.length()));
                this.renderBlocks = new RenderBlocks((IBlockAccess)this.schematic);
                this.createRendererSchematicChunk();
                this.isRenderingSchematic = true;
            }
        }
        catch (Exception e) {
            logger.fatal("Failed to load schematic!", (Throwable)e);
            this.reset();
            return false;
        }
        return true;
    }

    public boolean saveSchematic(File directory, String filename, Vector3f from, Vector3f to) {
        try {
            NBTTagCompound tagCompound = new NBTTagCompound();
            int minX = (int)Math.min(from.x, to.x);
            int maxX = (int)Math.max(from.x, to.x);
            int minY = (int)Math.min(from.y, to.y);
            int maxY = (int)Math.max(from.y, to.y);
            int minZ = (int)Math.min(from.z, to.z);
            int maxZ = (int)Math.max(from.z, to.z);
            short width = (short)(Math.abs(maxX - minX) + 1);
            short height = (short)(Math.abs(maxY - minY) + 1);
            short length = (short)(Math.abs(maxZ - minZ) + 1);
            int[][][] blocks = new int[width][height][length];
            int[][][] metadata = new int[width][height][length];
            ArrayList<TileEntity> tileEntities = new ArrayList<TileEntity>();
            TileEntity tileEntity = null;
            NBTTagCompound tileEntityNBT = null;
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        blocks[x - minX][y - minY][z - minZ] = GameData.blockRegistry.getId((Object)this.minecraft.field_71441_e.func_147439_a(x, y, z));
                        metadata[x - minX][y - minY][z - minZ] = this.minecraft.field_71441_e.func_72805_g(x, y, z);
                        tileEntity = this.minecraft.field_71441_e.func_147438_o(x, y, z);
                        if (tileEntity == null) continue;
                        tileEntityNBT = new NBTTagCompound();
                        tileEntity.func_145841_b(tileEntityNBT);
                        tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntityNBT);
                        tileEntity.field_145851_c -= minX;
                        tileEntity.field_145848_d -= minY;
                        tileEntity.field_145849_e -= minZ;
                        tileEntities.add(tileEntity);
                    }
                }
            }
            String icon = GameData.itemRegistry.func_148750_c((Object)defaultIcon.func_77973_b());
            try {
                String[] parts = filename.split(";");
                if (parts.length == 2) {
                    icon = parts[0];
                    filename = parts[1];
                }
            }
            catch (Exception e) {
                logger.error("Failed to parse icon data!", (Throwable)e);
            }
            SchematicWorld schematicOut = new SchematicWorld(icon, blocks, metadata, tileEntities, width, height, length);
            NBTTagCompound tagCompoundSchematic = new NBTTagCompound();
            schematicOut.writeToNBT(tagCompound);
            tagCompound.func_74782_a("Schematic", (NBTBase)tagCompoundSchematic);
            FileOutputStream stream = new FileOutputStream(new File(directory, filename));
            CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)stream);
        }
        catch (Exception e) {
            logger.error("Failed to save schematic!", (Throwable)e);
            return false;
        }
        return true;
    }

    public Vector3f getTranslationVector() {
        Vector3f.sub((Vector3f)this.playerPosition, (Vector3f)this.offset, (Vector3f)this.translationVector);
        return this.translationVector;
    }

    public float getTranslationX() {
        return this.playerPosition.x - this.offset.x;
    }

    public float getTranslationY() {
        return this.playerPosition.y - this.offset.y;
    }

    public float getTranslationZ() {
        return this.playerPosition.z - this.offset.z;
    }

    public void refreshSchematic() {
        for (RendererSchematicChunk renderer : this.sortedRendererSchematicChunk) {
            renderer.setDirty();
        }
    }

    public void updatePoints() {
        this.pointMin.x = Math.min(this.pointA.x, this.pointB.x);
        this.pointMin.y = Math.min(this.pointA.y, this.pointB.y);
        this.pointMin.z = Math.min(this.pointA.z, this.pointB.z);
        this.pointMax.x = Math.max(this.pointA.x, this.pointB.x);
        this.pointMax.y = Math.max(this.pointA.y, this.pointB.y);
        this.pointMax.z = Math.max(this.pointA.z, this.pointB.z);
    }

    public void moveHere(Vector3f point) {
        point.x = (int)Math.floor(this.playerPosition.x);
        point.y = (int)Math.floor(this.playerPosition.y - 1.0f);
        point.z = (int)Math.floor(this.playerPosition.z);
        switch (this.rotationRender) {
            case 0: {
                point.x -= 1.0f;
                point.z += 1.0f;
                break;
            }
            case 1: {
                point.x -= 1.0f;
                point.z -= 1.0f;
                break;
            }
            case 2: {
                point.x += 1.0f;
                point.z -= 1.0f;
                break;
            }
            case 3: {
                point.x += 1.0f;
                point.z += 1.0f;
            }
        }
    }

    public void moveHere() {
        this.offset.x = (int)Math.floor(this.playerPosition.x);
        this.offset.y = (int)Math.floor(this.playerPosition.y) - 1;
        this.offset.z = (int)Math.floor(this.playerPosition.z);
        if (this.schematic != null) {
            switch (this.rotationRender) {
                case 0: {
                    this.offset.x -= (float)this.schematic.width();
                    this.offset.z += 1.0f;
                    break;
                }
                case 1: {
                    this.offset.x -= (float)this.schematic.width();
                    this.offset.z -= (float)this.schematic.length();
                    break;
                }
                case 2: {
                    this.offset.x += 1.0f;
                    this.offset.z -= (float)this.schematic.length();
                    break;
                }
                case 3: {
                    this.offset.x += 1.0f;
                    this.offset.z += 1.0f;
                }
            }
            this.reloadChunkCache();
        }
    }

    public void toggleRendering() {
        this.isRenderingSchematic = !this.isRenderingSchematic && this.schematic != null;
    }

    public void reloadChunkCache() {
        if (this.schematic != null) {
            this.mcWorldCache = new ChunkCache((World)this.minecraft.field_71441_e, (int)this.offset.x - 1, (int)this.offset.y - 1, (int)this.offset.z - 1, (int)this.offset.x + this.schematic.width() + 1, (int)this.offset.y + this.schematic.height() + 1, (int)this.offset.z + this.schematic.length() + 1, 0);
            this.refreshSchematic();
        }
    }

    public void flipWorld() {
        if (this.schematic != null) {
            this.schematic.flip();
            this.createRendererSchematicChunk();
        }
    }

    public void rotateWorld() {
        if (this.schematic != null) {
            this.schematic.rotate();
            this.createRendererSchematicChunk();
        }
    }

    static {
        renderItem = new RenderItem();
        defaultIcon = new ItemStack((Block)Blocks.field_150349_c);
    }
}

