/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.renderer;

import com.github.lunatrius.schematica.Settings;
import com.github.lunatrius.schematica.client.renderer.RenderHelper;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunk;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunkSorter;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.nio.FloatBuffer;
import java.util.Collections;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RendererSchematicGlobal {
    private final Settings settings = Settings.instance();
    private final Profiler profiler;
    private final Frustrum frustrum;
    private final RendererSchematicChunkSorter rendererSchematicChunkSorter;

    public RendererSchematicGlobal() {
        this.profiler = this.settings.minecraft.field_71424_I;
        this.frustrum = new Frustrum();
        this.rendererSchematicChunkSorter = new RendererSchematicChunkSorter();
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        EntityClientPlayerMP player;
        if (this.settings.minecraft != null && (player = this.settings.minecraft.field_71439_g) != null) {
            this.settings.playerPosition.x = (float)(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks);
            this.settings.playerPosition.y = (float)(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks);
            this.settings.playerPosition.z = (float)(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks);
            this.settings.rotationRender = MathHelper.func_76128_c((double)(player.field_70177_z / 90.0f)) & 3;
            this.settings.orientation = this.getOrientation((EntityPlayer)player);
            this.profiler.func_76320_a("schematica");
            if (this.settings.isRenderingSchematic || this.settings.isRenderingGuide) {
                this.render();
            }
            this.profiler.func_76319_b();
        }
    }

    private int getOrientation(EntityPlayer player) {
        if (player.field_70125_A < -45.0f) {
            return 1;
        }
        if (player.field_70125_A > 45.0f) {
            return 0;
        }
        switch (MathHelper.func_76128_c((double)((double)player.field_70177_z / 90.0 + 0.5)) & 3) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    private void render() {
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)(-this.settings.getTranslationX()), (float)(-this.settings.getTranslationY()), (float)(-this.settings.getTranslationZ()));
        this.profiler.func_76320_a("schematic");
        if (this.settings.isRenderingSchematic) {
            this.profiler.func_76320_a("updateFrustrum");
            this.updateFrustrum();
            this.profiler.func_76318_c("sortAndUpdate");
            if (RendererSchematicChunk.getCanUpdate()) {
                this.sortAndUpdate();
            }
            this.profiler.func_76318_c("render");
            for (int pass = 0; pass < 3; ++pass) {
                for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                    renderer.render(pass);
                }
            }
            this.profiler.func_76319_b();
        }
        this.profiler.func_76318_c("guide");
        RenderHelper.createBuffers();
        this.profiler.func_76320_a("dataPrep");
        if (this.settings.isRenderingSchematic) {
            RenderHelper.drawCuboidOutline(RenderHelper.VEC_ZERO, this.settings.schematic.dimensions(), 63, 0.75f, 0.0f, 0.75f, 0.25f);
        }
        if (this.settings.isRenderingGuide) {
            Vector3f start = new Vector3f();
            Vector3f end = new Vector3f();
            Vector3f.sub((Vector3f)this.settings.pointMin, (Vector3f)this.settings.offset, (Vector3f)start);
            Vector3f.sub((Vector3f)this.settings.pointMax, (Vector3f)this.settings.offset, (Vector3f)end);
            end.translate(1.0f, 1.0f, 1.0f);
            RenderHelper.drawCuboidOutline(start, end, 63, 0.0f, 0.75f, 0.0f, 0.25f);
            Vector3f.sub((Vector3f)this.settings.pointA, (Vector3f)this.settings.offset, (Vector3f)start);
            Vector3f.sub((Vector3f)this.settings.pointA, (Vector3f)this.settings.offset, (Vector3f)end);
            end.translate(1.0f, 1.0f, 1.0f);
            RenderHelper.drawCuboidOutline(start, end, 63, 0.75f, 0.0f, 0.0f, 0.25f);
            RenderHelper.drawCuboidSurface(start, end, 63, 0.75f, 0.0f, 0.0f, 0.25f);
            Vector3f.sub((Vector3f)this.settings.pointB, (Vector3f)this.settings.offset, (Vector3f)start);
            Vector3f.sub((Vector3f)this.settings.pointB, (Vector3f)this.settings.offset, (Vector3f)end);
            end.translate(1.0f, 1.0f, 1.0f);
            RenderHelper.drawCuboidOutline(start, end, 63, 0.0f, 0.0f, 0.75f, 0.25f);
            RenderHelper.drawCuboidSurface(start, end, 63, 0.0f, 0.0f, 0.75f, 0.25f);
        }
        int quadCount = RenderHelper.getQuadCount();
        int lineCount = RenderHelper.getLineCount();
        if (quadCount > 0 || lineCount > 0) {
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)1.5f);
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            this.profiler.func_76318_c("quad");
            if (quadCount > 0) {
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getQuadVertexBuffer());
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getQuadColorBuffer());
                GL11.glDrawArrays((int)7, (int)0, (int)quadCount);
            }
            this.profiler.func_76318_c("line");
            if (lineCount > 0) {
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getLineVertexBuffer());
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getLineColorBuffer());
                GL11.glDrawArrays((int)1, (int)0, (int)lineCount);
            }
            this.profiler.func_76319_b();
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32884);
            GL11.glEnable((int)3553);
        }
        this.profiler.func_76319_b();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void updateFrustrum() {
        this.frustrum.func_78547_a((double)this.settings.getTranslationX(), (double)this.settings.getTranslationY(), (double)this.settings.getTranslationZ());
        for (RendererSchematicChunk rendererSchematicChunk : this.settings.sortedRendererSchematicChunk) {
            rendererSchematicChunk.isInFrustrum = this.frustrum.func_78546_a(rendererSchematicChunk.getBoundingBox());
        }
    }

    private void sortAndUpdate() {
        Collections.sort(this.settings.sortedRendererSchematicChunk, this.rendererSchematicChunkSorter);
        for (RendererSchematicChunk rendererSchematicChunk : this.settings.sortedRendererSchematicChunk) {
            if (!rendererSchematicChunk.getDirty()) continue;
            rendererSchematicChunk.updateRenderer();
            break;
        }
    }
}

