/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBattery
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge(this);
    int storage = 0;
    static final int max_storage = 6400;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BATTERY;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.battery_top;
            }
            case DOWN: {
                return BlockIcons.battery_bottom;
            }
        }
        return BlockIcons.battery_side;
    }

    @Override
    public String getInfo() {
        float f = this.storage * 100 / 6400;
        if (Core.dev_environ) {
            return "Storage: " + (int)f + "%\n" + this.storage + "/" + 6400;
        }
        return "Storage: " + (int)f + "%";
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.storage = tag.func_74762_e("storage");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.charge.writeToNBT(tag, "charge");
        tag.func_74768_a("storage", this.storage);
    }

    public static float getFullness(int value) {
        return (float)value / 6400.0f;
    }

    public float getFullness() {
        return TileEntityBattery.getFullness(this.storage);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge.update();
        int val = this.getCharge().getValue();
        int store_delta = 0;
        int charge_delta = 0;
        if (val < 20) {
            charge_delta = Math.min(20, this.storage);
            store_delta = -charge_delta;
        } else if (val > 30) {
            charge_delta = -val;
            int free = 6400 - this.storage;
            store_delta = Math.min(val * 2 / 3, free);
        }
        int tier = this.storage * 32 / 6400;
        if (store_delta != 0) {
            this.charge.addValue(charge_delta);
            this.storage += store_delta;
        }
        if (tier != this.storage * 32 / 6400) {
            this.func_70296_d();
            this.updateMeter();
        }
    }

    void updateMeter() {
        Core.network.broadcastMessage(null, this.getCoord(), NetworkFactorization.MessageType.BatteryLevel, this.storage);
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.BatteryLevel) {
            this.storage = input.readInt();
            this.getCoord().redraw();
            return true;
        }
        return false;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        NBTTagCompound tag = FzUtil.getTag(is);
        this.storage = tag.func_74764_b("storage") ? tag.func_74762_e("storage") : 6400;
    }

    @Override
    protected byte getExtraInfo() {
        float perc = (float)this.storage / 6400.0f;
        byte ret = (byte)(perc * 127.0f);
        return ret;
    }

    @Override
    protected void useExtraInfo(byte b) {
        int new_storage;
        float perc = (float)b / 127.0f;
        this.storage = new_storage = (int)(6400.0f * perc);
    }

    @Override
    public ItemStack getDroppedBlock() {
        ItemStack is = new ItemStack((Item)Core.registry.battery);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("storage", this.storage);
        is.func_77982_d(tag);
        Core.registry.battery.normalizeDamage(is);
        return is;
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        return (int)(this.getFullness() * 15.0f);
    }
}

