/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.ceramics.BlockRenderGreenware;
import factorization.ceramics.ItemRenderGlazeBucket;
import factorization.ceramics.TileEntityGreenware;
import factorization.ceramics.TileEntityGreenwareRender;
import factorization.charge.BatteryItemRender;
import factorization.charge.BlockRenderBattery;
import factorization.charge.BlockRenderHeater;
import factorization.charge.BlockRenderLeydenJar;
import factorization.charge.BlockRenderMirrorStand;
import factorization.charge.BlockRenderSteamTurbine;
import factorization.charge.BlockRenderWire;
import factorization.charge.TileEntityHeater;
import factorization.charge.TileEntityHeaterRenderer;
import factorization.charge.TileEntityLeydenJar;
import factorization.charge.TileEntityLeydenJarRender;
import factorization.charge.TileEntitySteamTurbine;
import factorization.charge.TileEntitySteamTurbineRender;
import factorization.common.ContainerFactorization;
import factorization.common.FactorizationKeyHandler;
import factorization.common.FactorizationProxy;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.crafting.BlockRenderCompressionCrafter;
import factorization.crafting.BlockRenderMixer;
import factorization.crafting.ContainerMixer;
import factorization.crafting.GuiMixer;
import factorization.crafting.GuiStamper;
import factorization.crafting.TileEntityCompressionCrafter;
import factorization.crafting.TileEntityCompressionCrafterRenderer;
import factorization.crafting.TileEntityMixer;
import factorization.crafting.TileEntityMixerRenderer;
import factorization.darkiron.BlockDarkIronOre;
import factorization.darkiron.GlintRenderer;
import factorization.oreprocessing.BlockRenderCrystallizer;
import factorization.oreprocessing.ContainerCrystallizer;
import factorization.oreprocessing.ContainerSlagFurnace;
import factorization.oreprocessing.GuiCrystallizer;
import factorization.oreprocessing.GuiSlag;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntityCrystallizerRender;
import factorization.oreprocessing.TileEntityGrinderRender;
import factorization.servo.BlockRenderServoRail;
import factorization.servo.GuiParasieve;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderDefault;
import factorization.shared.BlockRenderEmpty;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.EmptyRender;
import factorization.shared.FactorizationBlockRender;
import factorization.shared.FactorizationGui;
import factorization.shared.FactorizationRender;
import factorization.shared.ItemRenderCapture;
import factorization.shared.TileEntityFactorization;
import factorization.sockets.BlockRenderSocketBase;
import factorization.sockets.SocketLacerator;
import factorization.sockets.TileEntitySocketRenderer;
import factorization.sockets.fanturpeller.SocketFanturpeller;
import factorization.weird.BlockRenderDayBarrel;
import factorization.weird.ContainerPocket;
import factorization.weird.DayBarrelItemRenderer;
import factorization.weird.GuiPocketTable;
import factorization.weird.TileEntityDayBarrel;
import factorization.weird.TileEntityDayBarrelRenderer;
import factorization.wrath.BlockRenderLamp;
import factorization.wrath.TileEntityWrathLamp;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;

public class FactorizationClientProxy
extends FactorizationProxy {
    public FactorizationKeyHandler keyHandler = new FactorizationKeyHandler();
    int fireParticlesSpawned = 0;
    int fireParticlesMax = 5;

    public FactorizationClientProxy() {
        Core.loadBus(this);
    }

    @Override
    public Profiler getProfiler() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return Minecraft.func_71410_x().field_71424_I;
        }
        return super.getProfiler();
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == FactoryType.POCKETCRAFTGUI.gui) {
            return new GuiPocketTable(new ContainerPocket(player));
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityFactorization)) {
            return null;
        }
        TileEntityFactorization fac = (TileEntityFactorization)te;
        ContainerFactorization cont = ID == FactoryType.SLAGFURNACE.gui ? new ContainerSlagFurnace(player, fac) : (ID == FactoryType.MIXER.gui ? new ContainerMixer(player, fac) : (ID == FactoryType.CRYSTALLIZER.gui ? new ContainerCrystallizer(player, fac) : new ContainerFactorization(player, fac)));
        FactorizationGui gui = null;
        if (ID == FactoryType.STAMPER.gui) {
            gui = new GuiStamper(cont);
        }
        if (ID == FactoryType.SLAGFURNACE.gui) {
            gui = new GuiSlag(cont);
        }
        if (ID == FactoryType.MIXER.gui) {
            gui = new GuiMixer((ContainerMixer)cont);
        }
        if (ID == FactoryType.CRYSTALLIZER.gui) {
            gui = new GuiCrystallizer(cont);
        }
        if (ID == FactoryType.PARASIEVE.gui) {
            gui = new GuiParasieve(cont);
        }
        cont.addSlotsForGui(fac, player.field_71071_by);
        return gui;
    }

    @Override
    public void pokePocketCrafting() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof GuiPocketTable) {
            GuiPocketTable gui = (GuiPocketTable)minecraft.field_71462_r;
            gui.containerPocket.updateCraft();
        }
    }

    @Override
    public void playSoundFX(String src, float volume, float pitch) {
        PositionedSoundRecord sound2 = new PositionedSoundRecord(new ResourceLocation(src), volume, pitch, 0.0f, 0.0f, 0.0f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound2);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private void setTileEntityRendererDispatcher(Class clazz, TileEntitySpecialRenderer r) {
        ClientRegistry.bindTileEntitySpecialRenderer((Class)clazz, (TileEntitySpecialRenderer)r);
    }

    @Override
    public void registerRenderers() {
        this.setTileEntityRendererDispatcher(TileEntityDayBarrel.class, new TileEntityDayBarrelRenderer());
        this.setTileEntityRendererDispatcher(TileEntityGreenware.class, new TileEntityGreenwareRender());
        if (FzConfig.renderTEs) {
            this.setTileEntityRendererDispatcher(TileEntityHeater.class, new TileEntityHeaterRenderer());
            this.setTileEntityRendererDispatcher(TileEntityMixer.class, new TileEntityMixerRenderer());
            this.setTileEntityRendererDispatcher(TileEntityCrystallizer.class, new TileEntityCrystallizerRender());
            this.setTileEntityRendererDispatcher(TileEntitySteamTurbine.class, new TileEntitySteamTurbineRender());
            this.setTileEntityRendererDispatcher(TileEntityLeydenJar.class, new TileEntityLeydenJarRender());
            this.setTileEntityRendererDispatcher(TileEntityCompressionCrafter.class, new TileEntityCompressionCrafterRenderer());
            this.setTileEntityRendererDispatcher(SocketLacerator.class, new TileEntitySocketRenderer());
            this.setTileEntityRendererDispatcher(SocketFanturpeller.class, new TileEntitySocketRenderer());
        }
        RenderingRegistry.registerEntityRenderingHandler(TileEntityWrathLamp.RelightTask.class, (Render)new EmptyRender());
        RenderingRegistry.registerEntityRenderingHandler(ServoMotor.class, (Render)new RenderServoMotor());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FactorizationRender());
        BlockRenderBattery renderBattery = new BlockRenderBattery();
        BlockRenderDayBarrel renderBarrel = new BlockRenderDayBarrel();
        new BlockRenderLeydenJar();
        new BlockRenderDefault();
        new BlockRenderHeater();
        new BlockRenderLamp();
        new BlockRenderMirrorStand();
        new BlockRenderSteamTurbine();
        new BlockRenderWire();
        new BlockRenderMixer();
        new BlockRenderCrystallizer();
        new BlockRenderCompressionCrafter();
        new BlockRenderGreenware().setup();
        new BlockRenderServoRail();
        for (FactoryType ft : new FactoryType[]{FactoryType.SOCKET_EMPTY, FactoryType.SOCKET_LACERATOR, FactoryType.SOCKET_ROBOTHAND, FactoryType.SOCKET_SHIFTER, FactoryType.SOCKET_BLOWER, FactoryType.SOCKET_PUMP, FactoryType.SOCKET_BARE_MOTOR}) {
            new BlockRenderSocketBase(ft);
        }
        for (FactoryType ft : new FactoryType[]{FactoryType.STAMPER, FactoryType.PACKAGER, FactoryType.SLAGFURNACE, FactoryType.SOLARBOILER, FactoryType.PARASIEVE, FactoryType.CALIOMETRIC_BURNER}) {
            FactorizationBlockRender.setDefaultRender(ft);
        }
        new BlockRenderEmpty(FactoryType.EXTENDED);
        ItemRenderCapture capture = new ItemRenderCapture();
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Core.registry.factory_block), (IItemRenderer)capture);
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.battery, (IItemRenderer)new BatteryItemRender(renderBattery));
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.glaze_bucket, (IItemRenderer)new ItemRenderGlazeBucket());
        MinecraftForgeClient.registerItemRenderer((Item)Core.registry.daybarrel, (IItemRenderer)new DayBarrelItemRenderer(renderBarrel));
        this.setTileEntityRendererDispatcher(BlockDarkIronOre.Glint.class, new GlintRenderer());
    }

    @Override
    public void texturepackChanged(IIconRegister reg) {
        TileEntityGrinderRender.remakeModel();
        BlockRenderServoRail.registerColoredIcons(reg);
    }

    @Override
    public boolean BlockRenderHelper_has_texture(BlockRenderHelper block, int f) {
        if (block.textures == null) {
            return true;
        }
        return block.textures[f] != null;
    }

    @Override
    public void BlockRenderHelper_clear_texture(BlockRenderHelper block) {
        block.textures = null;
    }

    @Override
    public String getPocketCraftingTableKey() {
        return GameSettings.func_74298_c((int)FactorizationKeyHandler.pocket_key.func_151463_i());
    }

    @Override
    public boolean isClientHoldingShift() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        return Keyboard.isKeyDown((int)42);
    }

    @Override
    public void afterLoad() {
        Core.logInfo("Reloading game settings", new Object[0]);
        Minecraft.func_71410_x().field_71474_y.func_74300_a();
    }
}

