/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import com.google.common.base.Strings;
import factorization.docs.AbstractPage;
import factorization.docs.DocumentationModule;
import factorization.docs.TextWord;
import factorization.docs.Tokenizer;
import factorization.docs.Word;
import factorization.docs.WordPage;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.EnumChatFormatting;

public abstract class AbstractTypesetter {
    final FontRenderer font;
    final int pageWidth;
    final int pageHeight;
    ArrayList<String> topics = new ArrayList();
    protected ArrayList<AbstractPage> pages = new ArrayList();
    private ArrayList<AbstractPage> afterBuffer = new ArrayList();
    protected ArrayList<Word> segmentStart = null;
    WordPage current;

    public AbstractTypesetter(FontRenderer font, int pageWidth, int pageHeight) {
        this.font = font;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
    }

    public void processText(String text) {
        try {
            this.process(text, null, "");
        }
        catch (Throwable t) {
            this.error("Failed to load document.");
            t.printStackTrace();
        }
    }

    void error(String msg) {
        this.process(msg.replace("\\", "\\\\ "), null, "" + EnumChatFormatting.RED + EnumChatFormatting.BOLD);
    }

    String getParameter(String cmdName, Tokenizer tokenizer) {
        if (!tokenizer.nextToken()) {
            this.error("EOF looking for parameter for " + cmdName);
            return null;
        }
        Tokenizer.TokenType cfr_ignored_0 = tokenizer.type;
        if (tokenizer.type != Tokenizer.TokenType.PARAMETER) {
            this.error("Expected parameter for " + cmdName);
            return null;
        }
        return tokenizer.token;
    }

    void append(String text) {
        this.process(text, null, "");
    }

    protected void process(String text, String link, String style) {
        String token;
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        Tokenizer tokenizer = new Tokenizer(text);
        block5: while (tokenizer.nextToken() && !(token = tokenizer.token).isEmpty()) {
            switch (tokenizer.type) {
                default: {
                    this.error(tokenizer.token);
                    continue block5;
                }
                case WORD: {
                    this.emit(style + token, link);
                    continue block5;
                }
                case PARAMETER: {
                    this.process(token, link, style);
                    continue block5;
                }
                case COMMAND: 
            }
            String cmd = token.toLowerCase();
            if (cmd.equals("\\include")) {
                String name2 = this.getParameter(cmd, tokenizer);
                if (name2 == null) {
                    this.error("No page name specified");
                    return;
                }
                String subtext = DocumentationModule.readDocument(name2);
                this.process(subtext, link, style);
                continue;
            }
            if (cmd.equals("\\lmp")) {
                this.process("\\link{lmp}{LMP}", link, style);
                continue;
            }
            this.handleCommand(tokenizer, cmd, link, style);
        }
    }

    protected abstract void handleCommand(Tokenizer var1, String var2, String var3, String var4);

    int width(String word) {
        return this.font.func_78256_a(word);
    }

    void emitWord(Word w) {
        WordPage page = this.getCurrentPage();
        int len = w.getWidth(this.font);
        if (len + page.lineLen > this.pageWidth) {
            page.nl();
        }
        if ((2 + page.text.size()) * page.lineHeight > this.pageHeight) {
            WordPage oldPage = page;
            ArrayList<Word> oldSeg = this.segmentStart;
            page = this.newPage();
            if (oldSeg != null) {
                int n = oldPage.text.lastIndexOf(oldSeg);
                while (oldPage.text.size() > n) {
                    page.text.add(oldPage.text.remove(n));
                }
            }
        }
        page.add(w);
    }

    TextWord emit(String text, String link) {
        TextWord w = new TextWord(text, link);
        this.emitWord(w);
        return w;
    }

    void emptyBuffer() {
        this.pages.addAll(this.afterBuffer);
        this.afterBuffer.clear();
    }

    WordPage newPage() {
        this.emptyBuffer();
        this.current = new WordPage(this.font);
        this.pages.add(this.current);
        this.segmentStart = null;
        return this.current;
    }

    WordPage getCurrentPage() {
        if (this.current == null) {
            return this.newPage();
        }
        return this.current;
    }

    ArrayList<AbstractPage> getPages() {
        this.emptyBuffer();
        return this.pages;
    }
}

