/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class DistributeDocs {
    static HashSet<String> needyPlayers = new HashSet();
    Random rand = new Random();
    static StatBase bookGet = new StatBase("factorization.dropdocbook", (IChatComponent)new ChatComponentTranslation("factorization.dropdocbook", new Object[0])).func_75971_g();

    static boolean givenBook(EntityPlayer player) {
        StatisticsFile statsFile = FzUtil.getStatsFile(player);
        return statsFile != null && statsFile.func_77444_a(bookGet) > 0 || player.getEntityData().func_74764_b("fzDocd");
    }

    static void setGivenBook(EntityPlayer player) {
        needyPlayers.remove(player.func_70005_c_());
        StatisticsFile statsFile = FzUtil.getStatsFile(player);
        if (statsFile != null) {
            statsFile.func_150873_a(player, bookGet, 1);
        }
        player.getEntityData().func_74757_a("fzDocd", true);
    }

    @SubscribeEvent
    public void onPlayerLogon(PlayerEvent.PlayerLoggedInEvent event) {
        if (DistributeDocs.givenBook(event.player)) {
            DistributeDocs.setGivenBook(event.player);
            return;
        }
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        needyPlayers.add(player.func_70005_c_());
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.rand.nextInt(32) != 0 && !Core.dev_environ) {
            return;
        }
        EntityPlayer ply = event.getPlayer();
        if (!(ply instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)ply;
        if (player.field_71134_c.func_73081_b() != WorldSettings.GameType.SURVIVAL) {
            return;
        }
        String name2 = player.func_70005_c_();
        if (!needyPlayers.contains(name2)) {
            return;
        }
        StatisticsFile sfw = FzUtil.getStatsFile((EntityPlayer)player);
        if (!sfw.func_77443_a(AchievementList.field_76016_k)) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (is == null || is.func_77973_b() != Core.registry.docbook) continue;
            Core.logInfo("%s already had an FzDocBook, so won't give another one", new Object[0]);
            DistributeDocs.setGivenBook((EntityPlayer)player);
            return;
        }
        Coord broke = new Coord(event.world, event.x, event.y, event.z);
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            if (fd.offsetY != 0) continue;
            broke.adjust(fd);
            boolean cool = this.isCoolPlace(broke, broke);
            broke.adjust(fd.getOpposite());
            if (!cool) continue;
            Core.logInfo("Giving %s a book", name2);
            broke.adjust(fd);
            this.spawnAt(broke);
            DistributeDocs.setGivenBook((EntityPlayer)player);
            return;
        }
    }

    boolean isCoolPlace(Coord at, Coord orig) {
        if (!at.isSolid()) {
            return false;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Coord c = at.add(dir);
            if (c.isSolid() || c.equals(orig)) continue;
            return false;
        }
        return at.getBlock().isReplaceableOreGen(at.w, at.x, at.y, at.z, Blocks.field_150348_b);
    }

    void spawnAt(Coord at) {
        at.setIdMd(Blocks.field_150409_cd, this.rand.nextInt(6), true);
        FzUtil.FzInv inv = FzUtil.openInventory(at.getTE(IInventory.class), ForgeDirection.UP);
        if (inv == null) {
            return;
        }
        int target = inv.size() / 2;
        inv.set(target, new ItemStack((Item)Core.registry.docbook));
    }
}

