/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.notify.Notice;
import factorization.notify.Style;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public enum PointNetworkHandler {
    INSTANCE;

    String channelName = "fzNotify|point";
    FMLEventChannel channel;
    static final byte COORD = 1;
    static final byte ENTITY = 2;

    void initialize() {
        this.channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(this.channelName);
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void recievePacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBufInputStream input = new ByteBufInputStream(event.packet.payload());
        try {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
            this.handlePoint((DataInput)input, (EntityPlayer)player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handlePoint(DataInput input, EntityPlayer player) throws IOException {
        Notice notice = null;
        switch (input.readByte()) {
            default: {
                return;
            }
            case 1: {
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                String msg = this.buildMessage(player, input);
                Coord at = new Coord(player.field_70170_p, x, y, z);
                notice = new Notice(at, msg, new String[0]);
                break;
            }
            case 2: {
                int entityId = input.readInt();
                String msg = this.buildMessage(player, input);
                Entity ent = player.field_70170_p.func_73045_a(entityId);
                if (ent == null) {
                    return;
                }
                notice = new Notice(ent, msg, new String[0]);
                break;
            }
        }
        notice.withStyle(Style.DRAWFAR, Style.LONG);
        double maxDist = 65025.0;
        for (EntityPlayer viewer : player.field_70170_p.field_73010_i) {
            if (player.func_70068_e((Entity)viewer) > maxDist) continue;
            notice.send(viewer);
        }
    }

    private String buildMessage(EntityPlayer player, DataInput input) throws IOException {
        String base = "<" + player.func_70005_c_() + ">";
        String msg = input.readUTF();
        if (msg == null || msg.length() == 0) {
            return base;
        }
        return base + "\n" + msg;
    }

    @SideOnly(value=Side.CLIENT)
    void pointAtCoord(Coord at, String msg) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        out.writeByte(1);
        out.writeInt(at.x);
        out.writeInt(at.y);
        out.writeInt(at.z);
        out.writeUTF(msg);
        out.close();
        this.send(buf);
    }

    @SideOnly(value=Side.CLIENT)
    void pointAtEntity(Entity ent, String msg) throws IOException {
        if (ent == null) {
            return;
        }
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        out.writeByte(2);
        out.writeInt(ent.func_145782_y());
        out.writeUTF(msg);
        out.close();
        this.send(buf);
    }

    @SideOnly(value=Side.CLIENT)
    void send(ByteBuf out) {
        this.channel.sendToServer(new FMLProxyPacket(out, this.channelName));
    }
}

