/*
 * Decompiled with CFR 0.152.
 */
package factorization.oreprocessing;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.oreprocessing.ItemOreProcessing;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntityGrinder;
import factorization.oreprocessing.TileEntitySlagFurnace;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FactorizationOreProcessingHandler {
    private static final String waterBucket = "fz.waterBucketLike";
    private HashMap<String, ItemStack> bestIngots = new HashMap();
    public static final float GRIND_MULTIPLY = 2.0f;
    public static final float REDUCE_MULTIPLY = 2.5f;
    public static final float CRYSTALLIZE_MULTIPLY = 3.0f;
    public static final float GRIND = 2.0f;
    public static final float WASH = 1.0f;
    public static final float REDUCE = 1.25f;
    public static final float CRYSTALLIZE = 1.2f;

    void smelt(ItemStack is, ItemStack ore, ItemStack ingot) {
        float xp = FurnaceRecipes.func_77602_a().func_151398_b(ore);
        FurnaceRecipes.func_77602_a().func_151394_a(is, ingot, xp);
    }

    void addProcessingFront(ItemOreProcessing.OreType oreType, ItemStack ore, ItemStack ingot) {
        oreType.enable();
        ItemStack dirty = Core.registry.ore_dirty_gravel.makeStack(oreType);
        ItemStack clean = Core.registry.ore_clean_gravel.makeStack(oreType);
        TileEntityGrinder.addRecipe(ore, dirty, 2.0f);
        TileEntitySlagFurnace.SlagRecipes.register(dirty, 1.1f, ingot, 0.2f, Blocks.field_150346_d);
        ItemStack clean8 = clean.func_77946_l();
        clean8.field_77994_a = 8;
        Core.registry.shapelessOreRecipe(clean, waterBucket, dirty);
        Core.registry.shapelessOreRecipe(clean8, waterBucket, dirty, dirty, dirty, dirty, dirty, dirty, dirty, dirty);
        this.smelt(clean, ore, ingot);
        this.smelt(dirty, ore, ingot);
    }

    void addProcessingEnd(ItemOreProcessing.OreType oreType, ItemStack ore, ItemStack ingot) {
        oreType.enable();
        if (oreType.processingResult != null) {
            return;
        }
        oreType.processingResult = ingot;
        ItemStack reduced = Core.registry.ore_reduced.makeStack(oreType);
        ItemStack crystal = Core.registry.ore_crystal.makeStack(oreType);
        TileEntityCrystallizer.addRecipe(reduced, crystal, 1.2f, Core.registry.aqua_regia);
        this.smelt(reduced, ore, ingot);
        this.smelt(crystal, ore, ingot);
    }

    void addStandardReduction(ItemOreProcessing.OreType oreType, ItemStack ore, ItemStack ingot) {
        oreType.enable();
        ItemStack clean = Core.registry.ore_clean_gravel.makeStack(oreType);
        ItemStack reduced = Core.registry.ore_reduced.makeStack(oreType);
        TileEntitySlagFurnace.SlagRecipes.register(ore, 1.2f, ingot, 0.4f, oreType.surounding_medium);
        boolean r = true;
        TileEntitySlagFurnace.SlagRecipes.register(clean, (float)r, reduced, 1.25f - (float)r, reduced);
    }

    void addGalenaReduction(ItemOreProcessing.OreType oreType, ItemStack ore) {
        ItemStack clean_galena = Core.registry.ore_clean_gravel.makeStack(oreType);
        ItemStack reduced_silver = Core.registry.ore_reduced.makeStack(ItemOreProcessing.OreType.SILVER);
        ItemStack reduced_lead = Core.registry.ore_reduced.makeStack(ItemOreProcessing.OreType.LEAD);
        TileEntitySlagFurnace.SlagRecipes.register(clean_galena, 1.25f, reduced_lead, 1.25f, reduced_silver);
    }

    void handleNewOre(String oreClass, ItemStack ore) {
        ItemOreProcessing.OreType oreType = ItemOreProcessing.OreType.fromOreClass(oreClass);
        if (oreType == null) {
            return;
        }
        if (ItemOreProcessing.OD_ores.contains(oreClass)) {
            oreType.enable();
            ItemStack ingot = this.bestIngots.get(oreClass);
            if (ingot == null) {
                ingot = oreType.processingResult;
            }
            if (ingot == null) {
                ingot = FurnaceRecipes.func_77602_a().func_151395_a(ore);
            }
            if (ingot == null) {
                return;
            }
            this.addProcessingFront(oreType, ore, ingot);
            if (oreType == ItemOreProcessing.OreType.GALENA) {
                this.addGalenaReduction(oreType, ore);
                this.addProcessingEnd(ItemOreProcessing.OreType.SILVER, ore, new ItemStack((Item)Core.registry.silver_ingot));
                this.addProcessingEnd(ItemOreProcessing.OreType.LEAD, ore, new ItemStack((Item)Core.registry.lead_ingot));
                TileEntitySlagFurnace.SlagRecipes.register(ore, 1.2f, new ItemStack((Item)Core.registry.lead_ingot), 1.0f, new ItemStack((Item)Core.registry.silver_ingot));
            } else {
                this.addStandardReduction(oreType, ore, ingot);
                this.addProcessingEnd(oreType, ore, ingot);
            }
            oreType.processingResult = ingot;
        }
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        this.handleNewOre(evt.Name, evt.Ore);
    }

    void loadWater() {
        FluidStack h2o = FluidContainerRegistry.getFluidForFilledItem((ItemStack)new ItemStack(Items.field_151131_as));
        if (h2o == null) {
            return;
        }
        for (FluidContainerRegistry.FluidContainerData container : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            FluidStack liq = container.fluid;
            if (!h2o.isFluidEqual(liq) || liq.amount != 1000 || container.filledContainer == null) continue;
            OreDictionary.registerOre((String)waterBucket, (ItemStack)container.filledContainer);
        }
    }

    public void addDictOres() {
        this.loadWater();
        for (ItemOreProcessing.OreType type : ItemOreProcessing.OreType.values()) {
            String oreClass = type.OD_ore;
            String ingotClass = type.OD_ingot;
            if (oreClass == null) continue;
            ItemStack bestIngot = null;
            ArrayList oreList = OreDictionary.getOres((String)oreClass);
            if (oreList == null || !oreList.iterator().hasNext()) continue;
            for (ItemStack ore : oreList) {
                ItemStack smeltsTo = FurnaceRecipes.func_77602_a().func_151395_a(ore);
                if (smeltsTo == null) {
                    Iterator it;
                    if (ingotClass == null) break;
                    ArrayList ingotList = OreDictionary.getOres((String)ingotClass);
                    if (ingotList == null || !(it = ingotList.iterator()).hasNext()) continue;
                    bestIngot = (ItemStack)it.next();
                    break;
                }
                if (bestIngot != null && ore.func_77960_j() == 0) continue;
                bestIngot = smeltsTo;
            }
            if (bestIngot == null) continue;
            this.bestIngots.put(oreClass, bestIngot);
            for (ItemStack ore : oreList) {
                this.handleNewOre(oreClass, ore);
            }
        }
        Core.loadBus(this);
    }
}

