/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerFactionData;

@Command(name="faction", desc="operations about relationship between player and faction")
public class CmdFaction
extends ChMcLogger {
    public String playername;
    public Faction selectedFaction;
    public PlayerData selectedPlayerData;

    public CmdFaction(Object sender) {
        super(sender);
    }

    @SubCommand(desc="Add points", usage="<points>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean add(String[] args) {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("Must be an integer");
            return false;
        }
        int factionid = this.selectedFaction.id;
        PlayerFactionData playerfactiondata = this.selectedPlayerData.factionData;
        playerfactiondata.increasePoints(factionid, points);
        return true;
    }

    @SubCommand(desc="Substract points", usage="<points>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean substract(String[] args) {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("Must be an integer");
            return false;
        }
        int factionid = this.selectedFaction.id;
        PlayerFactionData playerfactiondata = this.selectedPlayerData.factionData;
        playerfactiondata.increasePoints(factionid, -points);
        return true;
    }

    @SubCommand(desc="Reset points to default", usage="", permissions={OpOnly.class})
    public Boolean reset(String[] args) {
        this.selectedPlayerData.factionData.factionData.put(this.selectedFaction.id, this.selectedFaction.defaultPoints);
        return true;
    }

    @SubCommand(desc="Set points", usage="<points>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean set(String[] args) {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            this.sendmessage("Must be an integer");
            return false;
        }
        PlayerFactionData playerfactiondata = this.selectedPlayerData.factionData;
        playerfactiondata.factionData.put(this.selectedFaction.id, points);
        return true;
    }

    @SubCommand(desc="Drop relationship", usage="", permissions={OpOnly.class})
    public Boolean drop(String[] args) {
        this.selectedPlayerData.factionData.factionData.remove(this.selectedFaction.id);
        return true;
    }
}

