/*
 * Decompiled with CFR 0.152.
 */
package foxz.utils;

import foxz.command.CmdTrader;
import foxz.hrformat.HRF;
import foxz.hrformat.Indenter;
import foxz.utils.ErrorMissFormated;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTrader;

public class Market {
    private static String FileNameFormat = "%s/markets/%s.hrf";
    private static final String version = "1.7.2.1";
    private static final String token1 = "trade:[";
    private static final String sold = "sold:{";
    private static final String currency = "currency:{";
    private static final String currency2 = "currency2:{";
    public static Set<EntityNPCInterface> delears = new HashSet<EntityNPCInterface>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public static void save(RoleTrader r, String name) {
        if (r.npc.field_70170_p.field_72995_K) {
            return;
        }
        if ((name = name.toLowerCase().trim()).isEmpty()) {
            return;
        }
        File dir = new File(CustomNpcs.getWorldSaveDirectory(), "markets");
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            FileWriter b = new FileWriter(String.format(FileNameFormat, CustomNpcs.getWorldSaveDirectory(), name));
            Indenter ind = new Indenter();
            b.write("version: \"1.7.2.1\",\ntrade:[\n");
            ind.push();
            for (int n = 0; n < r.inventorySold.func_70302_i_(); ++n) {
                NBTTagCompound tag;
                if (n > 0) {
                    b.write(",\n");
                }
                ItemStack i = r.inventorySold.func_70301_a(n);
                b.write(ind.indent(String.format("%d:{\n", n)));
                ind.push();
                b.write(ind.indent(sold));
                if (i != null) {
                    tag = i.func_77955_b(new NBTTagCompound());
                    b.write(HRF.Tag2HRF(tag, HRF.ItemStackDel));
                }
                b.write("},\n");
                b.write(ind.indent(currency));
                i = r.inventoryCurrency.func_70301_a(n);
                if (i != null) {
                    tag = i.func_77955_b(new NBTTagCompound());
                    b.write(HRF.Tag2HRF(tag, HRF.ItemStackDel));
                }
                b.write("},\n");
                b.write(ind.indent(currency2));
                i = r.inventoryCurrency.func_70301_a(n + 18);
                if (i != null) {
                    tag = i.func_77955_b(new NBTTagCompound());
                    b.write(HRF.Tag2HRF(tag, HRF.ItemStackDel));
                }
                b.write("}\n");
                ind.pop();
                b.write(ind.indent("}"));
            }
            b.write("\n]");
            b.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CmdTrader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void loadinv(RoleTrader r, String hrf, int i) throws ErrorMissFormated {
        block4: {
            String t;
            HRF.HRFParser pars = new HRF.HRFParser();
            pars.parse(hrf);
            do {
                ItemStack itcur;
                NBTTagCompound tag;
                t = pars.gettoken() + pars.gettriger() + pars.skipblank() + pars.gettriger();
                pars.back();
                String bk = pars.getbkblock(true).trim();
                if (t.equals(sold) && (tag = HRF.HRF2Tag(bk)) != null) {
                    ItemStack itsld = ItemStack.func_77949_a((NBTTagCompound)tag);
                    r.inventorySold.items.put(i, itsld);
                }
                if (t.equals(currency) && (tag = HRF.HRF2Tag(bk)) != null) {
                    itcur = ItemStack.func_77949_a((NBTTagCompound)tag);
                    r.inventoryCurrency.items.put(i, itcur);
                }
                if (t.equals(currency2) && (tag = HRF.HRF2Tag(bk)) != null) {
                    itcur = ItemStack.func_77949_a((NBTTagCompound)tag);
                    r.inventoryCurrency.items.put(i + 18, itcur);
                }
                if ((t = pars.gettriger()) == null || t.isEmpty()) break block4;
            } while (t.equals(","));
            throw new ErrorMissFormated("Sold/currency", 0, 0);
        }
    }

    private static void loadlist(RoleTrader r, String hrf) throws ErrorMissFormated {
        int i;
        HRF.HRFParser pars = new HRF.HRFParser();
        pars.parse(hrf);
        while (pars.hasMore() && (i = Integer.valueOf(pars.gettoken()).intValue()) < r.inventorySold.func_70302_i_()) {
            String t = pars.gettriger() + pars.skipblank() + pars.gettriger();
            if (!t.equals(":{")) {
                throw new ErrorMissFormated("list", 0, 0);
            }
            pars.back();
            Market.loadinv(r, pars.getbkblock(true), i);
            t = pars.gettriger();
            if (t == null || t.isEmpty()) {
                return;
            }
            if (t.equals(",")) continue;
            throw new ErrorMissFormated("list", 0, 0);
        }
        throw new ErrorMissFormated("list", 0, 0);
    }

    public static void load(RoleTrader r, String name) throws IOException, ErrorMissFormated {
        if (r.npc.field_70170_p.field_72995_K) {
            return;
        }
        if ((name = name.toLowerCase().trim()).isEmpty()) {
            return;
        }
        String hrf = Market.readFile(String.format(FileNameFormat, CustomNpcs.getWorldSaveDirectory(), name));
        if (hrf == null || hrf.isEmpty()) {
            return;
        }
        HRF.HRFParser pars = new HRF.HRFParser();
        pars.parse(hrf);
        String t = pars.gettoken() + pars.gettriger() + pars.getbkblock(true).trim() + pars.gettriger();
        if (!t.equals("version:1.7.2.1,")) {
            throw new ErrorMissFormated("version ???", 0, 0);
        }
        t = pars.gettoken() + pars.gettriger() + pars.gettriger();
        if (!t.equals(token1)) {
            throw new ErrorMissFormated(token1, 0, 0);
        }
        pars.back();
        Market.loadlist(r, pars.getbkblock(true));
        t = pars.gettriger();
        if (t == null || t.isEmpty()) {
            return;
        }
        throw new ErrorMissFormated("unknow key", 0, 0);
    }

    public static boolean fileexist(String name) {
        if ((name = name.toLowerCase().trim()).isEmpty()) {
            return false;
        }
        File f = new File(String.format(FileNameFormat, CustomNpcs.getWorldSaveDirectory(), name));
        return f.exists();
    }

    public static void setMarket(EntityNPCInterface npc, String marketName) {
        if (!Market.fileexist(marketName)) {
            Market.save((RoleTrader)npc.roleInterface, marketName);
        }
        try {
            Market.load((RoleTrader)npc.roleInterface, marketName);
        }
        catch (Exception ex) {
            Logger.getLogger(CmdTrader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

