/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import foxz.hrformat.HRF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.world.WorldEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.ScriptEntityData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptAnimal;
import noppes.npcs.scripted.ScriptEntity;
import noppes.npcs.scripted.ScriptLiving;
import noppes.npcs.scripted.ScriptLivingBase;
import noppes.npcs.scripted.ScriptMonster;
import noppes.npcs.scripted.ScriptPlayer;
import noppes.npcs.scripted.ScriptWorld;

public class ScriptController {
    public static ScriptController Instance;
    public static boolean HasStart;
    private ScriptEngineManager manager;
    public Map<String, String> languages = new HashMap<String, String>();
    public Map<String, String> scripts = new HashMap<String, String>();
    public long lastLoaded = 0L;
    public File dir;
    public NBTTagCompound compound = new NBTTagCompound();
    private boolean loaded = false;
    public boolean shouldSave = false;

    public ScriptController() {
        Instance = this;
        this.manager = new ScriptEngineManager();
        System.out.println("Script Engings Available:");
        for (ScriptEngineFactory fac : this.manager.getEngineFactories()) {
            if (fac.getExtensions().isEmpty()) continue;
            this.manager.getEngineByName(fac.getLanguageName());
            String ext = "." + fac.getExtensions().get(0).toLowerCase();
            System.out.println(fac.getLanguageName() + ": " + ext);
            this.languages.put(fac.getLanguageName(), ext);
        }
    }

    public void loadCategories() {
        new ScriptWorld(null).clearTempData();
        this.dir = new File(CustomNpcs.getWorldSaveDirectory(), "scripts");
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        this.scripts.clear();
        for (String language : this.languages.keySet()) {
            String ext = this.languages.get(language);
            File scriptDir = new File(this.dir, language.toLowerCase());
            if (!scriptDir.exists()) {
                scriptDir.mkdir();
                continue;
            }
            this.loadDir(scriptDir, "", ext);
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    private void loadDir(File dir, String name, String ext) {
        for (File file : dir.listFiles()) {
            name = name + file.getName().toLowerCase();
            if (file.isDirectory()) {
                this.loadDir(file, name + "/", ext);
                continue;
            }
            if (!name.endsWith(ext)) continue;
            try {
                this.scripts.put(name, this.readFile(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStoredData() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.getSavedFile()));
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
            NBTTagCompound compound = HRF.HRF2Tag(sb.toString());
            if (compound == null) {
                boolean bl = false;
                return bl;
            }
            this.compound = compound;
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.shouldSave = false;
        }
        return true;
    }

    private File getSavedFile() throws IOException {
        File file = new File(this.dir, "saved_data.txt");
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public ScriptEngine getEngineByName(String language) {
        return this.manager.getEngineByName(language);
    }

    public NBTTagList nbtLanguages() {
        NBTTagList list = new NBTTagList();
        for (String language : this.languages.keySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList scripts = new NBTTagList();
            for (String script : this.getScripts(language)) {
                scripts.func_74742_a((NBTBase)new NBTTagString(script));
            }
            compound.func_74782_a("Scripts", (NBTBase)scripts);
            compound.func_74778_a("Language", language);
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    private List<String> getScripts(String language) {
        ArrayList<String> list = new ArrayList<String>();
        String ext = this.languages.get(language);
        if (ext == null) {
            return list;
        }
        for (String script : this.scripts.keySet()) {
            if (!script.endsWith(ext)) continue;
            list.add(script);
        }
        return list;
    }

    public ScriptEntity getScriptForEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).script.dummyNpc;
        }
        ScriptEntityData data = (ScriptEntityData)entity.getExtendedProperties("ScriptedObject");
        if (data != null) {
            return data.base;
        }
        data = entity instanceof EntityPlayerMP ? new ScriptEntityData(new ScriptPlayer((EntityPlayerMP)entity)) : (entity instanceof EntityAnimal ? new ScriptEntityData(new ScriptAnimal((EntityAnimal)entity)) : (entity instanceof EntityMob ? new ScriptEntityData(new ScriptMonster((EntityMob)entity)) : (entity instanceof EntityLiving ? new ScriptEntityData(new ScriptLiving((EntityLiving)entity)) : (entity instanceof EntityLivingBase ? new ScriptEntityData(new ScriptLivingBase((EntityLivingBase)entity)) : new ScriptEntityData(new ScriptEntity(entity))))));
        entity.registerExtendedProperties("ScriptedObject", (IExtendedEntityProperties)data);
        return data.base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void saveWorld(WorldEvent.Save event) {
        if (!this.shouldSave || event.world.field_72995_K || event.world != MinecraftServer.func_71276_C().field_71305_c[0]) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.getSavedFile());
            writer.write(HRF.Tag2HRF(this.compound, HRF.EnchDel));
        }
        catch (IOException e) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
            this.shouldSave = false;
        }
    }

    static {
        HasStart = false;
    }
}

