/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import foxz.commandhelper.permissions.PlayerOnly;
import foxz.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.npcs.client.controllers.CloneController;
import noppes.npcs.entity.EntityNPCInterface;

@Command(name="clone", desc="Clone operation (server side)")
public class CmdClone
extends ChMcLogger {
    public CmdClone(Object sender) {
        super(sender);
    }

    @SubCommand(desc="Add NPC(s) to clone storage", usage="<npc> [newname]", permissions={OpOnly.class, PlayerOnly.class, ParamCheck.class})
    public Boolean add(String[] args) {
        EntityPlayerMP player = (EntityPlayerMP)this.pcParam;
        List<EntityNPCInterface> list = Utils.getNearbeEntityFromPlayer(EntityNPCInterface.class, player, 80);
        for (EntityNPCInterface npc : list) {
            NBTTagCompound compound;
            if (!npc.display.name.equalsIgnoreCase(args[0])) continue;
            String name = npc.display.name;
            if (args.length > 2) {
                name = args[2];
            }
            if (!npc.func_70039_c(compound = new NBTTagCompound())) {
                return false;
            }
            CloneController.cleanTags(compound);
            CloneController.addClone(compound, name, 0);
        }
        return true;
    }

    @SubCommand(desc="List NPC from clone storage", usage="")
    public Boolean list(String[] args) {
        this.sendmessage("--- Stored NPCs --- (server side)");
        for (NBTTagCompound tag : CloneController.getClones()) {
            this.sendmessage(tag.func_74779_i("CloneName"));
        }
        this.sendmessage("------------------------------------");
        return true;
    }

    @SubCommand(desc="Remove NPC from clone storage", usage="[name]")
    public Boolean del(String[] args) {
        if (args.length != 1) {
            this.sendmessage("Needs only one arg");
            return false;
        }
        NBTTagCompound toDelete = null;
        String nametodel = args[0];
        ArrayList<NBTTagCompound> tags = CloneController.getClones();
        for (NBTTagCompound tag : tags) {
            String name = tag.func_74779_i("ClonedName");
            if (!nametodel.equalsIgnoreCase(name)) continue;
            toDelete = tag;
            break;
        }
        if (toDelete == null) {
            this.sendmessage(String.format("Npc '%s' wasn't found", nametodel));
            return false;
        }
        tags.remove(toDelete);
        CloneController.saveClones(tags);
        return true;
    }

    @SubCommand(desc="Spawn cloned NPC", usage="<name> [[world:]x,y,z]] [newname]", permissions={ParamCheck.class})
    public boolean spawn(String[] args) {
        EntityPlayerMP player;
        String[] par;
        ArrayList<NBTTagCompound> clones = CloneController.getClones();
        String name = args[0].replaceAll("%", " ");
        String newname = null;
        NBTTagCompound compound = CloneController.getCompound(clones, name);
        if (compound == null) {
            this.sendmessage("Unknown npc");
            return false;
        }
        World world = null;
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        boolean posInParam = false;
        String location = args[1];
        if (location.contains(":")) {
            par = location.split(":");
            location = par[1];
            world = Utils.getWorld(par[0]);
            if (world == null) {
                this.sendmessage(String.format("'%s' is an unknown world", par[0]));
                return false;
            }
        }
        if (world == null && this.pcParam instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)this.pcParam;
            world = player.func_130014_f_();
        }
        if (location.contains(",")) {
            posInParam = true;
            par = location.split(",");
            if (par.length != 3) {
                this.sendmessage("Location need be x,y,z");
                return false;
            }
            try {
                posX = Integer.parseInt(par[0].trim());
                posY = Integer.parseInt(par[1].trim());
                posZ = Integer.parseInt(par[2].trim());
            }
            catch (NumberFormatException ex) {
                this.sendmessage("Location should be in numbers");
                return false;
            }
            if (args.length > 2) {
                newname = args[2];
            }
        } else {
            newname = location;
        }
        if (!posInParam) {
            if (this.pcParam instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)this.pcParam;
                world = player.func_130014_f_();
                posX = MathHelper.func_76128_c((double)player.field_70165_t);
                posY = MathHelper.func_76128_c((double)player.field_70163_u);
                posZ = MathHelper.func_76128_c((double)player.field_70161_v);
            } else {
                this.sendmessage("Location needed");
                return false;
            }
        }
        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        entity.func_70107_b((double)posX + 0.5, (double)(posY + 1), (double)posZ + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.startPos = new int[]{posX, posY, posZ};
            if (!newname.isEmpty()) {
                npc.display.name = newname.replaceAll("%", " ");
            }
        }
        world.func_72838_d(entity);
        return true;
    }
}

