/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiNpcTextArea
extends GuiNpcTextField {
    public boolean inMenu = true;
    public boolean numbersOnly = false;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private int cursorCounter;
    private FontRenderer fontrenderer;
    private int cursorPosition = 0;
    private int listHeight;
    private float scrolledY = 0.0f;
    private int startClick = -1;
    private boolean clickVerticalBar = false;
    private boolean wrapLine = true;

    public GuiNpcTextArea(int id, GuiScreen guiscreen, FontRenderer fontrenderer, int i, int j, int k, int l, String s) {
        super(id, guiscreen, fontrenderer, i, j, k, l, s);
        this.posX = i;
        this.posY = j;
        this.width = k;
        this.listHeight = this.height = l;
        this.fontrenderer = fontrenderer;
        this.func_146203_f(1500);
        this.func_146180_a(s);
    }

    public void func_146178_a() {
        ++this.cursorCounter;
    }

    @Override
    public boolean func_146201_a(char c, int i) {
        if (this.func_146206_l() && this.canEdit) {
            String originalText = this.func_146179_b();
            this.func_146180_a(originalText);
            if (c == '\r' || c == '\n') {
                this.func_146180_a(originalText.substring(0, this.cursorPosition) + c + originalText.substring(this.cursorPosition));
            }
            this.func_146196_d();
            this.func_146182_d(this.cursorPosition);
            boolean bo = super.func_146201_a(c, i);
            String newText = this.func_146179_b();
            if (i != 211) {
                this.cursorPosition += newText.length() - originalText.length();
            }
            if (i == 203 && this.cursorPosition > 0) {
                --this.cursorPosition;
            }
            if (i == 205 && this.cursorPosition < newText.length()) {
                ++this.cursorPosition;
            }
            return bo;
        }
        return false;
    }

    @Override
    public void func_146192_a(int i, int j, int k) {
        boolean wasFocused = this.func_146206_l();
        super.func_146192_a(i, j, k);
        if (this.hoverVerticalScrollBar(i, j)) {
            this.clickVerticalBar = true;
            this.startClick = -1;
            return;
        }
        if (k != 0 || !this.canEdit) {
            return;
        }
        int x = i - this.posX;
        int y = (j - this.posY - 4) / this.fontrenderer.field_78288_b + this.getStartLineY();
        this.cursorPosition = 0;
        List<String> lines = this.getLines();
        int charCount = 0;
        int lineCount = 0;
        int maxSize = this.width - (this.isScrolling() ? 14 : 4);
        for (int g = 0; g < lines.size(); ++g) {
            String wholeLine = lines.get(g);
            String line = "";
            for (char c : wholeLine.toCharArray()) {
                this.cursorPosition = charCount;
                if (this.fontrenderer.func_78256_a(line + c) > maxSize && this.wrapLine) {
                    line = "";
                    if (y < ++lineCount) break;
                }
                if (lineCount == y && x <= this.fontrenderer.func_78256_a(line + c)) {
                    return;
                }
                ++charCount;
                line = line + c;
            }
            this.cursorPosition = charCount++;
            if (y < ++lineCount) break;
        }
        if (y >= lineCount) {
            this.cursorPosition = this.func_146179_b().length();
        }
    }

    private List<String> getLines() {
        ArrayList<String> list = new ArrayList<String>();
        String line = "";
        for (char c : this.func_146179_b().toCharArray()) {
            if (c == '\r' || c == '\n') {
                list.add(line);
                line = "";
                continue;
            }
            line = line + c;
        }
        list.add(line);
        return list;
    }

    private int getStartLineY() {
        if (!this.isScrolling()) {
            this.scrolledY = 0.0f;
        }
        return MathHelper.func_76143_f((double)(this.scrolledY * (float)this.listHeight / (float)this.fontrenderer.field_78288_b));
    }

    @Override
    public void drawTextBox(int mouseX, int mouseY) {
        GuiNpcTextArea.func_73734_a((int)(this.posX - 1), (int)(this.posY - 1), (int)(this.posX + this.width + 1), (int)(this.posY + this.height + 1), (int)-6250336);
        GuiNpcTextArea.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + this.width), (int)(this.posY + this.height), (int)-16777216);
        int color = 0xE0E0E0;
        boolean flag = this.func_146206_l() && this.cursorCounter / 6 % 2 == 0;
        int startLine = this.getStartLineY();
        int maxLine = this.height / this.fontrenderer.field_78288_b + startLine;
        List<String> lines = this.getLines();
        int charCount = 0;
        int lineCount = 0;
        int maxSize = this.width - (this.isScrolling() ? 14 : 4);
        for (int i = 0; i < lines.size(); ++i) {
            String wholeLine = lines.get(i);
            String line = "";
            for (char c : wholeLine.toCharArray()) {
                if (this.fontrenderer.func_78256_a(line + c) > maxSize && this.wrapLine) {
                    if (lineCount >= startLine && lineCount < maxLine) {
                        this.func_73731_b(this.fontrenderer, line, this.posX + 4, this.posY + 4 + (lineCount - startLine) * this.fontrenderer.field_78288_b, color);
                    }
                    line = "";
                    ++lineCount;
                }
                if (flag && charCount == this.cursorPosition && lineCount >= startLine && lineCount < maxLine && this.canEdit) {
                    int xx = this.posX + this.fontrenderer.func_78256_a(line) + 3;
                    int yy = this.posY + (lineCount - startLine) * this.fontrenderer.field_78288_b + 4;
                    if (this.func_146179_b().length() == this.cursorPosition) {
                        this.fontrenderer.func_78276_b("_", xx, yy, color);
                    } else {
                        this.drawCursorVertical(xx, yy, xx + 1, yy + this.fontrenderer.field_78288_b);
                    }
                }
                ++charCount;
                line = line + c;
            }
            if (lineCount >= startLine && lineCount < maxLine) {
                this.func_73731_b(this.fontrenderer, line, this.posX + 4, this.posY + 4 + (lineCount - startLine) * this.fontrenderer.field_78288_b, color);
                if (flag && charCount == this.cursorPosition && this.canEdit) {
                    int xx = this.posX + this.fontrenderer.func_78256_a(line) + 3;
                    int yy = this.posY + (lineCount - startLine) * this.fontrenderer.field_78288_b + 4;
                    if (this.func_146179_b().length() == this.cursorPosition) {
                        this.fontrenderer.func_78276_b("_", xx, yy, color);
                    } else {
                        this.drawCursorVertical(xx, yy, xx + 1, yy + this.fontrenderer.field_78288_b);
                    }
                }
            }
            ++lineCount;
            ++charCount;
        }
        int k2 = Mouse.getDWheel();
        if (k2 != 0 && this.func_146206_l()) {
            this.addScrollY(k2 < 0 ? -10 : 10);
        }
        if (Mouse.isButtonDown((int)0)) {
            if (this.clickVerticalBar) {
                if (this.startClick >= 0) {
                    this.addScrollY(this.startClick - (mouseY - this.posY));
                }
                if (this.hoverVerticalScrollBar(mouseX, mouseY)) {
                    this.startClick = mouseY - this.posY;
                }
                this.startClick = mouseY - this.posY;
            }
        } else {
            this.clickVerticalBar = false;
        }
        this.listHeight = lineCount * this.fontrenderer.field_78288_b;
        this.drawVerticalScrollBar();
    }

    private boolean isScrolling() {
        return this.listHeight > this.height - 4;
    }

    private void addScrollY(int scrolled) {
        float max;
        this.scrolledY -= 1.0f * (float)scrolled / (float)this.height;
        if (this.scrolledY < 0.0f) {
            this.scrolledY = 0.0f;
        }
        if (this.scrolledY > (max = 1.0f - 1.0f * (float)(this.height + 2) / (float)this.listHeight)) {
            this.scrolledY = max;
        }
    }

    private boolean hoverVerticalScrollBar(int x, int y) {
        if (this.listHeight <= this.height - 4) {
            return false;
        }
        return this.posY < y && this.posY + this.height > y && x < this.posX + this.width && x > this.posX + (this.width - 8);
    }

    private void drawCursorVertical(int p_146188_1_, int p_146188_2_, int p_146188_3_, int p_146188_4_) {
        int i1;
        if (p_146188_1_ < p_146188_3_) {
            i1 = p_146188_1_;
            p_146188_1_ = p_146188_3_;
            p_146188_3_ = i1;
        }
        if (p_146188_2_ < p_146188_4_) {
            i1 = p_146188_2_;
            p_146188_2_ = p_146188_4_;
            p_146188_4_ = i1;
        }
        if (p_146188_3_ > this.posX + this.width) {
            p_146188_3_ = this.posX + this.width;
        }
        if (p_146188_1_ > this.posX + this.width) {
            p_146188_1_ = this.posX + this.width;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_2_, 0.0);
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_2_, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    private int getVerticalBarSize() {
        return (int)(1.0f * (float)this.height / (float)this.listHeight * (float)(this.height - 4));
    }

    private void drawVerticalScrollBar() {
        if (this.listHeight <= this.height - 4) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiCustomScroll.resource);
        int x = this.posX + this.width - 6;
        int y = (int)((float)this.posY + this.scrolledY * (float)this.height) + 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sbSize = this.getVerticalBarSize();
        this.func_73729_b(x, y, this.width, 9, 5, 1);
        for (int k = 0; k < sbSize; ++k) {
            this.func_73729_b(x, y + k, this.width, 10, 5, 1);
        }
        this.func_73729_b(x, y, this.width, 11, 5, 1);
    }
}

