/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class ItemElectricTool
extends ItemTool
implements IElectricItem,
IBoxable,
IItemHudInfo {
    public double operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    public Set<Block> mineableBlocks = new HashSet<Block>();

    public ItemElectricTool(InternalName internalName, Item.ToolMaterial toolmaterial, int aOperationEnergyCost) {
        super(0.0f, toolmaterial, new HashSet());
        this.operationEnergyCost = aOperationEnergyCost;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b(internalName.name());
        this.func_77637_a(IC2.tabIC2);
        GameRegistry.registerItem((Item)this, (String)internalName.name());
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        return super.func_77659_a(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("ic2:" + this.func_77658_a().substring(4));
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(tool, block, meta);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.mineableBlocks.contains(block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block block, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        if ((double)block.func_149712_f(par2World, par4, par5, par6) != 0.0) {
            if (par7EntityLiving != null) {
                ElectricItem.manager.use(par1ItemStack, this.operationEnergyCost, par7EntityLiving);
            } else {
                ElectricItem.manager.discharge(par1ItemStack, this.operationEnergyCost, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(Double.POSITIVE_INFINITY));
        itemList.add(this.getItemStack(0.0));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
    }

    @Override
    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
        return info;
    }

    protected ItemStack getItemStack(double charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    protected ItemTool getRefPick() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return (ItemTool)Items.field_151046_w;
            }
            case GOLD: {
                return (ItemTool)Items.field_151005_D;
            }
            case IRON: {
                return (ItemTool)Items.field_151035_b;
            }
            case STONE: {
                return (ItemTool)Items.field_151050_s;
            }
            case WOOD: {
                return (ItemTool)Items.field_151039_o;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }

    protected ItemTool getRefShovel() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return (ItemTool)Items.field_151047_v;
            }
            case GOLD: {
                return (ItemTool)Items.field_151011_C;
            }
            case IRON: {
                return (ItemTool)Items.field_151037_a;
            }
            case STONE: {
                return (ItemTool)Items.field_151051_r;
            }
            case WOOD: {
                return (ItemTool)Items.field_151038_n;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }

    protected ItemTool getRefAxe() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return (ItemTool)Items.field_151056_x;
            }
            case GOLD: {
                return (ItemTool)Items.field_151006_E;
            }
            case IRON: {
                return (ItemTool)Items.field_151036_c;
            }
            case STONE: {
                return (ItemTool)Items.field_151049_t;
            }
            case WOOD: {
                return (ItemTool)Items.field_151053_p;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }

    protected ItemSword getRefSword() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return (ItemSword)Items.field_151048_u;
            }
            case GOLD: {
                return (ItemSword)Items.field_151010_B;
            }
            case IRON: {
                return (ItemSword)Items.field_151040_l;
            }
            case STONE: {
                return (ItemSword)Items.field_151052_q;
            }
            case WOOD: {
                return (ItemSword)Items.field_151041_m;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }
}

