/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PriorityExecutor
extends ThreadPoolExecutor {
    public PriorityExecutor(int threadCount) {
        super(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(11), new ThreadFactoryImpl());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        int priority = callable instanceof CustomPriority ? ((CustomPriority)((Object)callable)).getPriority() : 0;
        return new PriorityTask<T>(callable, priority);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        int priority = runnable instanceof CustomPriority ? ((CustomPriority)((Object)runnable)).getPriority() : 0;
        return new PriorityTask<T>(runnable, value, priority);
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger number = new AtomicInteger(1);

        ThreadFactoryImpl() {
            this.group = Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, "ic2-poolthread-" + this.number.getAndIncrement(), 0L);
            thread.setDaemon(true);
            thread.setPriority(5);
            return thread;
        }
    }

    public static interface CustomPriority {
        public int getPriority();
    }

    static class PriorityTask<V>
    extends FutureTask<V>
    implements Comparable<PriorityTask<V>> {
        private final int priority;

        public PriorityTask(Callable<V> callable, int priority1) {
            super(callable);
            this.priority = priority1;
        }

        public PriorityTask(Runnable runnable, V result, int priority1) {
            super(runnable, result);
            this.priority = priority1;
        }

        @Override
        public int compareTo(PriorityTask<V> o) {
            return o.priority - this.priority;
        }
    }
}

