/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.forge;

import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import cpw.mods.fml.common.registry.GameData;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHandler {
    private static OreDictionaryHandler instance;

    public static OreDictionaryHandler instance() {
        if (instance == null) {
            instance = new OreDictionaryHandler();
        }
        return instance;
    }

    public boolean generateAndRegisterOreDictionaryTreeDefinitions() {
        if (TCSettings.allowOreDictionaryLookup) {
            TCLog.info("Scanning Ore Dictionary for unregistered tree blocks...", new Object[0]);
            LinkedList<BlockID> leafList = new LinkedList<BlockID>();
            for (String oreName : TCSettings.oreDictionaryLeafStrings.split(",")) {
                if (oreName.trim().isEmpty()) continue;
                for (ItemStack itemStack : OreDictionary.getOres((String)oreName.trim())) {
                    BlockID blockID;
                    Item item = itemStack.func_77973_b();
                    if (!(item instanceof ItemBlock) || leafList.contains(blockID = new BlockID(GameData.itemRegistry.func_148750_c((Object)item)))) continue;
                    leafList.add(blockID);
                }
            }
            boolean didRegisterATree = false;
            for (String oreName : TCSettings.oreDictionaryLogStrings.split(",")) {
                if (oreName.trim().isEmpty()) continue;
                TreeDefinition genericTree = new TreeDefinition();
                for (ItemStack itemStack : OreDictionary.getOres((String)oreName.trim())) {
                    Item item = itemStack.func_77973_b();
                    if (!(item instanceof ItemBlock)) continue;
                    BlockID blockID = new BlockID(GameData.itemRegistry.func_148750_c((Object)item));
                    if (TreeRegistry.instance().isRegistered(blockID) || TreeRegistry.instance().blacklist().contains(blockID)) continue;
                    genericTree.addLogID(blockID);
                }
                if (genericTree.getLogList().isEmpty()) continue;
                for (BlockID blockID : leafList) {
                    genericTree.addLeafID(blockID);
                }
                for (BlockID blockID : TreeRegistry.instance().masterDefinition().getLeafList()) {
                    genericTree.addLeafID(blockID);
                }
                TCLog.info("Registering generic Ore Dictionary tree %s...", oreName.trim());
                TreeRegistry.instance().registerTree(oreName.trim(), genericTree);
                ModConfigRegistry.instance().appendTreeToModConfig("minecraft", oreName.trim(), genericTree);
                didRegisterATree = true;
            }
            TCLog.info("Ore Dictionary processing complete.", new Object[0]);
            return didRegisterATree;
        }
        TCLog.info("Skipping Ore Dictionary processing.", new Object[0]);
        return false;
    }
}

