/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.item;

import airbreather.mods.airbreathercore.item.ItemConfiguration;
import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.item.ItemRegistrar;
import airbreather.mods.airbreathercore.item.ItemRegistry;
import com.google.common.base.Preconditions;
import net.minecraft.item.Item;

public class ItemRegistrarBase
implements ItemRegistrar {
    @Override
    public final void RegisterNewItems(ItemConfiguration configuration, ItemRegistry registry) {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        Preconditions.checkNotNull((Object)registry, (Object)"registry");
        for (ItemDefinition itemDefinition : configuration.GetItemDefinitionsForNewItems()) {
            Item item = this.CreateItem(itemDefinition);
            registry.RegisterNewItem(itemDefinition, item);
        }
    }

    protected Item CreateItemCore(ItemDefinition definition) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition");
        Preconditions.checkArgument((boolean)false, (String)"%s is not a recognized item definition.", (Object[])new Object[]{definition});
        return null;
    }

    private Item CreateItem(ItemDefinition itemDefinition) {
        Preconditions.checkNotNull((Object)itemDefinition, (Object)"itemDefinition");
        Item item = this.CreateItemCore(itemDefinition);
        String itemName = itemDefinition.GetItemName();
        String modID = itemDefinition.GetModID();
        item.func_77655_b(itemName);
        String textureName = String.format("%s:%s", modID, itemName);
        item.func_111206_d(textureName);
        return item;
    }
}

