/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import lotr.client.LOTRClientProxy;
import lotr.client.LOTRKeyHandler;
import lotr.client.fx.LOTREntityDeadMarshFace;
import lotr.client.gui.LOTRGuiAchievementDisplay;
import lotr.client.gui.LOTRGuiCapes;
import lotr.client.render.tileentity.LOTRTileEntityMobSpawnerRenderer;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockLeavesBase;
import lotr.common.entity.animal.LOTREntityCamel;
import lotr.common.entity.item.LOTREntityPortal;
import lotr.common.item.LOTRItemBow;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemSpear;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenDeadMarshes;
import lotr.common.world.biome.LOTRBiomeGenMirkwood;
import lotr.common.world.biome.LOTRBiomeGenMistyMountains;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class LOTRTickHandlerClient {
    private static ResourceLocation portalOverlay = new ResourceLocation("lotr:misc/portal_overlay.png");
    private static ResourceLocation elvenPortalOverlay = new ResourceLocation("lotr:misc/elvenportal_overlay.png");
    private static ResourceLocation morgulPortalOverlay = new ResourceLocation("lotr:misc/morgulportal_overlay.png");
    private static ResourceLocation mistOverlay = new ResourceLocation("lotr:misc/mist_overlay.png");
    private static ResourceLocation frostOverlay = new ResourceLocation("lotr:misc/frost_overlay.png");
    private static ResourceLocation burnOverlay = new ResourceLocation("lotr:misc/burn_overlay.png");
    public static HashMap playersInPortals = new HashMap();
    public static HashMap playersInElvenPortals = new HashMap();
    public static HashMap playersInMorgulPortals = new HashMap();
    private GuiScreen lastGuiOpen;
    private boolean checkedUpdate = false;
    private int mistTick;
    private static final int mistTickMax = 80;
    public static LOTRFaction currentAlignmentFaction = LOTRFaction.HOBBIT;
    private int alignmentXPosBase;
    private int alignmentYPosBase;
    private int alignmentXPosCurrent;
    private int alignmentYPosCurrent;
    private boolean firstAlignmentRender = true;
    public static int alignmentChange;
    public static LOTRGuiAchievementDisplay achievementDisplay;
    public static boolean renderMenuPrompt;
    public static boolean renderAlignmentPrompt;
    private int onscreenPromptTick;
    private int frostTick;
    private static final int frostTickMax = 80;
    private int burnTick;
    private static final int burnTickMax = 40;
    private int drunkennessDirection = 1;

    public LOTRTickHandlerClient() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        achievementDisplay = new LOTRGuiAchievementDisplay();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityClientPlayerMP entityplayer = minecraft.field_71439_g;
        WorldClient world = minecraft.field_71441_e;
        if (event.phase == TickEvent.Phase.END) {
            GuiScreen guiscreen;
            if (alignmentChange > 0) {
                --alignmentChange;
            }
            if (minecraft.field_71462_r == null) {
                this.lastGuiOpen = null;
            }
            if (FMLClientHandler.instance().hasOptifine()) {
                int optifineSetting = 0;
                try {
                    Object field = GameSettings.class.getField("ofTrees").get(minecraft.field_71474_y);
                    if (field instanceof Integer) {
                        optifineSetting = (Integer)field;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean fancyGraphics = optifineSetting == 0 ? minecraft.field_71474_y.field_74347_j : (optifineSetting == 1 ? false : optifineSetting == 2);
                LOTRBlockLeavesBase.setAllGraphicsLevels(fancyGraphics);
            } else {
                LOTRBlockLeavesBase.setAllGraphicsLevels(minecraft.field_71474_y.field_74347_j);
            }
            if (entityplayer != null && world != null) {
                if (!this.checkedUpdate) {
                    try {
                        URL updateURL = new URL("http://dl.dropbox.com/s/sidxw1dicl2nsev/version.txt");
                        HttpURLConnection updateConnection = (HttpURLConnection)updateURL.openConnection();
                        BufferedReader updateReader = new BufferedReader(new InputStreamReader(updateConnection.getInputStream()));
                        String updateVersion = updateReader.readLine();
                        updateReader.close();
                        int i = updateVersion.indexOf("Beta");
                        if (i >= 0) {
                            updateVersion = updateVersion.substring(i);
                            String version = null;
                            for (ModContainer mod : Loader.instance().getModList()) {
                                if (mod.getMod() != LOTRMod.instance) continue;
                                version = mod.getVersion();
                            }
                            if (version != null && !updateVersion.equals(version)) {
                                ChatComponentText component = new ChatComponentText("The Lord of the Rings Mod:");
                                component.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                                entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.update", new Object[]{component, updateVersion}));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.checkedUpdate = true;
                }
                if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRMod.idDimension) && playersInPortals.containsKey(entityplayer)) {
                    int i;
                    List portals = world.func_72872_a(LOTREntityPortal.class, entityplayer.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
                    boolean inPortal = false;
                    for (i = 0; i < portals.size(); ++i) {
                        LOTREntityPortal portal = (LOTREntityPortal)((Object)portals.get(i));
                        if (!portal.field_70121_D.func_72326_a(entityplayer.field_70121_D)) continue;
                        inPortal = true;
                        break;
                    }
                    if (inPortal) {
                        i = (Integer)playersInPortals.get(entityplayer);
                        playersInPortals.put(entityplayer, ++i);
                        if (i >= 100) {
                            minecraft.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("portal.trigger"), (float)(world.field_73012_v.nextFloat() * 0.4f + 0.8f)));
                            playersInPortals.remove(entityplayer);
                        }
                    } else {
                        playersInPortals.remove(entityplayer);
                    }
                }
                this.updatePlayerInPortal((EntityPlayer)entityplayer, playersInElvenPortals, LOTRMod.elvenPortal);
                this.updatePlayerInPortal((EntityPlayer)entityplayer, playersInMorgulPortals, LOTRMod.morgulPortal);
                if (!this.isGamePaused(minecraft)) {
                    int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                    int j = MathHelper.func_76128_c((double)entityplayer.field_70163_u);
                    int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                    BiomeGenBase biome = world.func_72807_a(i, k);
                    if (entityplayer.field_70163_u >= 72.0 && biome instanceof LOTRBiomeGenMistyMountains && biome != LOTRBiome.mistyMountainsFoothills && world.func_72937_j(i, j, k) && world.func_72972_b(EnumSkyBlock.Block, i, j, k) < 7) {
                        if (this.mistTick < 80) {
                            ++this.mistTick;
                        }
                    } else if (this.mistTick > 0) {
                        --this.mistTick;
                    }
                    if (this.frostTick > 0) {
                        --this.frostTick;
                    }
                    if (this.burnTick > 0) {
                        --this.burnTick;
                    }
                    if (minecraft.field_71474_y.field_74362_aa < 2) {
                        this.spawnEnvironmentFX((EntityPlayer)entityplayer, (World)world);
                    }
                    LOTRClientProxy.customEffectRenderer.updateEffects();
                    if (minecraft.field_71451_h.func_82165_m(Potion.field_76431_k.field_76415_H)) {
                        float drunkenness = minecraft.field_71451_h.func_70660_b(Potion.field_76431_k).func_76459_b();
                        if ((drunkenness /= 20.0f) > 100.0f) {
                            drunkenness = 100.0f;
                        }
                        minecraft.field_71451_h.field_70177_z += (float)this.drunkennessDirection * drunkenness / 20.0f;
                        minecraft.field_71451_h.field_70125_A += MathHelper.func_76134_b((float)((float)minecraft.field_71451_h.field_70173_aa / 10.0f)) * drunkenness / 20.0f;
                        if (world.field_73012_v.nextInt(100) == 0) {
                            this.drunkennessDirection *= -1;
                        }
                    }
                }
            }
            if ((guiscreen = minecraft.field_71462_r) != null) {
                if (guiscreen instanceof GuiMainMenu && !(this.lastGuiOpen instanceof GuiMainMenu)) {
                    LOTRLevelData.needsLoad = true;
                }
                this.lastGuiOpen = guiscreen;
            }
            if ((LOTRGuiCapes.playerModelRotation += 2) >= 360) {
                LOTRGuiCapes.playerModelRotation = 0;
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            GuiScreen gui;
            EntityClientPlayerMP entityplayer = minecraft.field_71439_g;
            WorldClient world = minecraft.field_71441_e;
            if (entityplayer != null && world != null && entityplayer.field_70154_o instanceof LOTREntityCamel && ((gui = minecraft.field_71462_r) instanceof GuiInventory || gui instanceof GuiContainerCreative)) {
                entityplayer.func_71053_j();
                ByteBuf data = Unpooled.buffer();
                data.writeInt(entityplayer.func_145782_y());
                data.writeByte((int)((byte)entityplayer.field_71093_bK));
                C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.camelGui", data);
                minecraft.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            LOTRTileEntityMobSpawnerRenderer.onRenderTick();
            if (minecraft.field_71439_g != null && minecraft.field_71441_e != null) {
                if (minecraft.field_71439_g.field_71093_bK == LOTRMod.idDimension || LOTRMod.alwaysShowAlignment) {
                    this.alignmentXPosCurrent = this.alignmentXPosBase;
                    int interval = (int)(((float)this.alignmentYPosBase + 20.0f) / 10.0f);
                    this.alignmentYPosCurrent = minecraft.field_71462_r == null && !minecraft.field_71474_y.field_74321_H.func_151468_f() && !minecraft.field_71474_y.field_74330_P ? (this.alignmentYPosCurrent < this.alignmentYPosBase ? (this.alignmentYPosCurrent += interval) : this.alignmentYPosBase) : (this.alignmentYPosCurrent > -20 ? (this.alignmentYPosCurrent -= interval) : -20);
                    this.renderAlignment(minecraft);
                }
                if (minecraft.field_71439_g.field_71093_bK == LOTRMod.idDimension && minecraft.field_71462_r == null) {
                    ++this.onscreenPromptTick;
                    if (this.onscreenPromptTick >= 150) {
                        this.onscreenPromptTick = 0;
                    }
                    float transparency = 1.0f;
                    if (this.onscreenPromptTick < 50) {
                        transparency = 0.5f + 0.5f * ((float)this.onscreenPromptTick / 50.0f);
                    } else if (this.onscreenPromptTick >= 100) {
                        transparency = 0.5f + 0.5f * ((float)(149 - this.onscreenPromptTick) / 50.0f);
                    }
                    String message = null;
                    if (renderMenuPrompt) {
                        message = StatCollector.func_74837_a((String)"lotr.gui.menuPrompt", (Object[])new Object[]{GameSettings.func_74298_c((int)LOTRKeyHandler.keyBindingMenu.func_151463_i())});
                    } else if (renderAlignmentPrompt) {
                        message = StatCollector.func_74837_a((String)"lotr.gui.alignmentPrompt", (Object[])new Object[]{GameSettings.func_74298_c((int)LOTRKeyHandler.keyBindingAlignmentCycleLeft.func_151463_i()), GameSettings.func_74298_c((int)LOTRKeyHandler.keyBindingAlignmentCycleRight.func_151463_i())});
                    }
                    if (message != null) {
                        ScaledResolution resolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
                        int i = resolution.func_78326_a();
                        int j = resolution.func_78328_b();
                        int x = (i - minecraft.field_71466_p.func_78256_a(message)) / 2;
                        int y = (j - minecraft.field_71466_p.field_78288_b) * 2 / 3;
                        minecraft.field_71466_p.func_78276_b(message, x, y, 0xFFFFFF + ((int)(transparency * 255.0f) << 24));
                    }
                }
            }
            achievementDisplay.updateAchievementWindow();
        }
    }

    private void updatePlayerInPortal(EntityPlayer entityplayer, HashMap players, Block portalBlock) {
        if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRMod.idDimension) && players.containsKey(entityplayer)) {
            boolean inPortal;
            boolean bl = inPortal = entityplayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entityplayer.field_70165_t), MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)entityplayer.field_70161_v)) == portalBlock;
            if (inPortal) {
                int i = (Integer)players.get(entityplayer);
                players.put(entityplayer, ++i);
                if (i >= entityplayer.func_82145_z()) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("portal.trigger"), (float)(entityplayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f)));
                    players.remove(entityplayer);
                }
            } else {
                players.remove(entityplayer);
            }
        }
    }

    private void spawnEnvironmentFX(EntityPlayer entityplayer, World world) {
        world.field_72984_F.func_76320_a("lotrEnvironmentFX");
        int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
        int range = 16;
        for (int l = 0; l < 50; ++l) {
            int k1;
            int j1;
            int i1 = i + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
            if (world.func_147439_a(i1, j1 = j + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range), k1 = k + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range)).func_149688_o() != Material.field_151586_h) continue;
            BiomeGenBase biome = world.func_72807_a(i1, k1);
            if (biome instanceof LOTRBiomeGenMirkwood && ((LOTRBiomeGenMirkwood)biome).corrupted) {
                LOTRMod.proxy.spawnParticle("mirkwoodWater", (double)i1 + (double)world.field_73012_v.nextFloat(), (double)j1 + 0.75, (double)k1 + (double)world.field_73012_v.nextFloat(), 0.0, 0.05, 0.0);
                continue;
            }
            if (!(biome instanceof LOTRBiomeGenDeadMarshes) || world.field_73012_v.nextInt(50) != 0) continue;
            world.func_72838_d((Entity)new LOTREntityDeadMarshFace(world, (double)i1 + (double)world.field_73012_v.nextFloat(), (double)j1 + 0.25 - (double)world.field_73012_v.nextFloat(), (double)k1 + (double)world.field_73012_v.nextFloat()));
        }
        world.field_72984_F.func_76319_b();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world instanceof WorldClient) {
            LOTRClientProxy.customEffectRenderer.clearEffectsAndSetWorld(event.world);
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null && event.type == RenderGameOverlayEvent.ElementType.HELMET) {
            int i;
            if (playersInPortals.containsKey(mc.field_71439_g) && (i = ((Integer)playersInPortals.get(mc.field_71439_g)).intValue()) > 0) {
                this.renderOverlay(0.1f + (float)i / 100.0f * 0.6f, mc, portalOverlay);
            }
            if (playersInElvenPortals.containsKey(mc.field_71439_g) && (i = ((Integer)playersInElvenPortals.get(mc.field_71439_g)).intValue()) > 0) {
                this.renderOverlay(0.1f + (float)i / (float)mc.field_71439_g.func_82145_z() * 0.6f, mc, elvenPortalOverlay);
            }
            if (playersInMorgulPortals.containsKey(mc.field_71439_g) && (i = ((Integer)playersInMorgulPortals.get(mc.field_71439_g)).intValue()) > 0) {
                this.renderOverlay(0.1f + (float)i / (float)mc.field_71439_g.func_82145_z() * 0.6f, mc, morgulPortalOverlay);
            }
            if (this.mistTick > 0) {
                float mistFactor = (float)mc.field_71439_g.field_70163_u / 256.0f;
                this.renderOverlay((float)this.mistTick / 80.0f * (mistFactor *= 0.75f), mc, mistOverlay);
            }
            if (this.frostTick > 0) {
                this.renderOverlay((float)this.frostTick / 80.0f * 0.9f, mc, frostOverlay);
            }
            if (this.burnTick > 0) {
                this.renderOverlay((float)this.burnTick / 40.0f * 0.6f, mc, burnOverlay);
            }
        }
    }

    @SubscribeEvent
    public void onRenderDebugText(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P && mc.field_71441_e != null && mc.field_71439_g != null && mc.field_71439_g.field_71093_bK == LOTRMod.idDimension) {
            int i = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
            int k = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
            BiomeGenBase biome = mc.field_71441_e.func_72807_a(i, k);
            event.left.add(null);
            String color = Integer.toHexString(biome.field_76790_z);
            while (color.length() < 6) {
                color = "0" + color;
            }
            event.left.add("Middle-earth biome: " + ((LOTRBiome)biome).getBiomeDisplayName() + ", ID: " + biome.field_76756_M + ", c: #" + color);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        float f = event.partialTicks;
        mc.field_71460_t.func_78463_b((double)f);
        RenderHelper.func_74518_a();
        LOTRClientProxy.customEffectRenderer.renderParticles((Entity)mc.field_71451_h, f);
        mc.field_71460_t.func_78483_a((double)f);
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayerSP entityplayer = event.entity;
        float fov = event.fov;
        if (entityplayer.func_71039_bw()) {
            ItemStack itemstack = entityplayer.func_71011_bu();
            Item item = itemstack.func_77973_b();
            float maxDrawTime = 0.0f;
            if (item instanceof LOTRItemBow) {
                maxDrawTime = ((LOTRItemBow)item).getMaxDrawTime();
            } else if (item instanceof LOTRItemCrossbow) {
                maxDrawTime = ((LOTRItemCrossbow)item).getMaxDrawTime();
            } else if (item instanceof LOTRItemSpear) {
                maxDrawTime = ((LOTRItemSpear)item).getMaxDrawTime();
            }
            if (maxDrawTime > 0.0f) {
                int i = entityplayer.func_71057_bx();
                float use = (float)i / maxDrawTime;
                use = use > 1.0f ? 1.0f : (use *= use);
                event.newfov = fov *= 1.0f - use * 0.15f;
            }
        }
    }

    private boolean isGamePaused(Minecraft mc) {
        return mc.func_71356_B() && mc.field_71462_r != null && mc.field_71462_r.func_73868_f() && !mc.func_71401_C().func_71344_c();
    }

    private void renderOverlay(float f, Minecraft mc, ResourceLocation texture) {
        if (mc.field_71462_r != null) {
            return;
        }
        if (mc.field_71474_y.field_74321_H.func_151468_f()) {
            return;
        }
        ScaledResolution resolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int i = resolution.func_78326_a();
        int j = resolution.func_78328_b();
        mc.field_71460_t.func_78478_c();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        GL11.glDisable((int)3008);
        mc.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)j, -90.0, 0.0, 256.0);
        tessellator.func_78374_a((double)i, (double)j, -90.0, 0.0, 256.0);
        tessellator.func_78374_a((double)i, 0.0, -90.0, 0.0, 256.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 256.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderAlignment(Minecraft mc) {
        int alignment = LOTRLevelData.getAlignment((EntityPlayer)mc.field_71439_g, currentAlignmentFaction);
        ScaledResolution resolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int i = resolution.func_78326_a();
        int j = resolution.func_78328_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(LOTRClientProxy.alignmentTexture);
        boolean boss = BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0 && LOTRMod.alignmentMoveWhenBoss;
        this.alignmentXPosBase = i / 2 + LOTRMod.alignmentXOffset;
        this.alignmentYPosBase = (boss ? 22 : 2) + LOTRMod.alignmentYOffset;
        if (this.firstAlignmentRender) {
            this.alignmentXPosCurrent = this.alignmentXPosBase;
            this.alignmentYPosCurrent = this.alignmentYPosBase;
            this.firstAlignmentRender = false;
        }
        LOTRTickHandlerClient.drawTexturedModalRect(this.alignmentXPosCurrent - 116, this.alignmentYPosCurrent, 0, 0, 232, 18);
        GL11.glColor4f((float)LOTRTickHandlerClient.currentAlignmentFaction.factionColors[0], (float)LOTRTickHandlerClient.currentAlignmentFaction.factionColors[1], (float)LOTRTickHandlerClient.currentAlignmentFaction.factionColors[2], (float)1.0f);
        LOTRTickHandlerClient.drawTexturedModalRect(this.alignmentXPosCurrent - 116, this.alignmentYPosCurrent, 0, 34, 232, 18);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LOTRTickHandlerClient.drawTexturedModalRect(this.alignmentXPosCurrent - 8 + LOTRTickHandlerClient.calculateAlignmentDisplay(alignment), this.alignmentYPosCurrent + 1, 16 * Math.round(alignmentChange / 3), 18, 16, 16);
        if (this.alignmentYPosCurrent == this.alignmentYPosBase) {
            FontRenderer f = mc.field_71466_p;
            int x = this.alignmentXPosCurrent;
            int y = this.alignmentYPosCurrent + 22;
            String s = currentAlignmentFaction.factionName();
            LOTRTickHandlerClient.drawTextWithShadow(f, x - f.func_78256_a(s) / 2, y, s, 1.0f);
            int max = LOTRTickHandlerClient.calculateMaxDisplayValue(alignment);
            String sMax = "+" + String.valueOf(max);
            String sMin = "-" + String.valueOf(max);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int xMax = this.alignmentXPosCurrent * 2 - 220 - f.func_78256_a(sMax) / 2;
            int xMin = this.alignmentXPosCurrent * 2 + 220 - f.func_78256_a(sMax) / 2;
            LOTRTickHandlerClient.drawTextWithShadow(f, xMax, y *= 2, sMax, 1.0f);
            LOTRTickHandlerClient.drawTextWithShadow(f, xMin, y, sMin, 1.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            y /= 2;
            y += f.field_78288_b + 4;
            s = String.valueOf(alignment);
            if (alignment > 0) {
                s = "+" + s;
            }
            LOTRTickHandlerClient.drawTextWithShadow(f, x - f.func_78256_a(s) / 2, y, s, 1.0f);
        }
    }

    public static int calculateAlignmentDisplay(int alignment) {
        float f = alignment;
        while (MathHelper.func_76135_e((float)f) >= 1.0f) {
            f /= 10.0f;
        }
        f *= 110.0f;
        return Math.round(f *= -1.0f);
    }

    public static int calculateMaxDisplayValue(int alignment) {
        if (alignment == 0) {
            return 10;
        }
        int i = 1;
        float f = alignment;
        while (MathHelper.func_76135_e((float)f) >= 1.0f) {
            f /= 10.0f;
            i *= 10;
        }
        return i;
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), 0.0, (double)((float)(u + 0) * f), (double)((float)(v + height) * f));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(u + width) * f), (double)((float)(v + height) * f));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), 0.0, (double)((float)(u + width) * f), (double)((float)(v + 0) * f));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f));
        tessellator.func_78381_a();
    }

    public static void drawTextWithShadow(FontRenderer f, int x, int y, String s, float transparencyFloat) {
        int transparency = (int)(transparencyFloat * 255.0f) << 24;
        f.func_78276_b(s, x - 1, y - 1, 0 + transparency);
        f.func_78276_b(s, x, y - 1, 0 + transparency);
        f.func_78276_b(s, x + 1, y - 1, 0 + transparency);
        f.func_78276_b(s, x + 1, y, 0 + transparency);
        f.func_78276_b(s, x + 1, y + 1, 0 + transparency);
        f.func_78276_b(s, x, y + 1, 0 + transparency);
        f.func_78276_b(s, x - 1, y + 1, 0 + transparency);
        f.func_78276_b(s, x - 1, y, 0 + transparency);
        f.func_78276_b(s, x, y, 16772620 + transparency);
    }

    public void onFrostDamage() {
        this.frostTick = 80;
    }

    public void onBurnDamage() {
        this.burnTick = 40;
    }

    static {
        renderMenuPrompt = false;
        renderAlignmentPrompt = false;
    }
}

