/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import lotr.client.gui.LOTRGui;
import lotr.client.gui.LOTRGuiButtonAchievements;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LOTRGuiAchievements
extends LOTRGui {
    private static ResourceLocation pageTexture = new ResourceLocation("lotr:gui/achievements/page.png");
    private static ResourceLocation iconsTexture = new ResourceLocation("lotr:gui/achievements/icons.png");
    private static int currentCategoryIndex = 0;
    private LOTRAchievement.Category currentCategory = LOTRAchievement.Category.values()[currentCategoryIndex];
    private ArrayList currentCategoryTakenAchievements = new ArrayList();
    private ArrayList currentCategoryUntakenAchievements = new ArrayList();
    private int currentCategoryTakenCount;
    private int currentCategoryUntakenCount;
    private int totalTakenCount;
    private int totalAvailableCount;
    private float currentScroll = 0.0f;
    private boolean isScrolling = false;
    private boolean wasClicking;

    @Override
    public void func_73866_w_() {
        this.xSize = 220;
        super.func_73866_w_();
        this.field_146292_n.add(new LOTRGuiButtonAchievements(2, true, this.guiLeft + 13, this.guiTop + 13));
        this.field_146292_n.add(new LOTRGuiButtonAchievements(3, false, this.guiLeft + 191, this.guiTop + 13));
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.currentCategory = LOTRAchievement.Category.values()[currentCategoryIndex];
        this.updateAchievementLists();
    }

    public void func_73863_a(int i, int j, float f) {
        boolean isMouseDown = Mouse.isButtonDown((int)0);
        int i1 = this.guiLeft + 201;
        int j1 = this.guiTop + 43;
        int k1 = i1 + 12;
        int l1 = j1 + 200;
        if (!this.wasClicking && isMouseDown && i >= i1 && j >= j1 && i < k1 && j < l1) {
            this.isScrolling = this.hasScrollBar();
        }
        if (!isMouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = isMouseDown;
        if (this.isScrolling) {
            this.currentScroll = ((float)(j - j1) - 8.5f) / ((float)(l1 - j1) - 17.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(pageTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        String s = StatCollector.func_74838_a((String)"lotr.gui.achievements.title");
        s = s + ": (" + this.totalTakenCount + "/" + this.totalAvailableCount + ")";
        this.field_146289_q.func_78276_b(s, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(s) / 2, this.guiTop - 30, 0xFFFFFF);
        String categoryName = this.currentCategory.getDisplayName();
        categoryName = categoryName + " (" + this.currentCategoryTakenCount + "/" + (this.currentCategoryTakenCount + this.currentCategoryUntakenCount) + ")";
        this.field_146289_q.func_78276_b(categoryName, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(categoryName) / 2, this.guiTop + 18, 8019267);
        super.func_73863_a(i, j, f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(iconsTexture);
        if (this.hasScrollBar()) {
            int offset = (int)(this.currentScroll * 181.0f);
            this.func_73729_b(this.guiLeft + 201, this.guiTop + 43 + offset, 190, 0, 10, 17);
        } else {
            this.func_73729_b(this.guiLeft + 201, this.guiTop + 43, 200, 0, 10, 17);
        }
        this.drawAchievements();
    }

    private void drawAchievements() {
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        int size = this.currentCategoryTakenCount + this.currentCategoryUntakenCount;
        int min = 0 + Math.round(this.currentScroll * (float)(size - 4));
        int max = 3 + Math.round(this.currentScroll * (float)(size - 4));
        if (max > size - 1) {
            max = size - 1;
        }
        for (int i = min; i <= max; ++i) {
            boolean hasAchievement;
            LOTRAchievement achievement;
            if (i < this.currentCategoryTakenCount) {
                achievement = (LOTRAchievement)this.currentCategoryTakenAchievements.get(i);
                hasAchievement = true;
            } else {
                achievement = (LOTRAchievement)this.currentCategoryUntakenAchievements.get(i - this.currentCategoryTakenCount);
                hasAchievement = false;
            }
            int offset = 42 + 50 * (i - min);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(iconsTexture);
            this.func_73729_b(this.guiLeft + 9, this.guiTop + offset, 0, hasAchievement ? 0 : 50, 190, 50);
            if (!hasAchievement) {
                float shading = 0.25f;
                GL11.glColor4f((float)shading, (float)shading, (float)shading, (float)1.0f);
                LOTRGuiAchievements.renderItem.field_77024_a = false;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            renderItem.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), achievement.icon, this.guiLeft + 12, this.guiTop + offset + 3);
            GL11.glDisable((int)2896);
            if (!hasAchievement) {
                LOTRGuiAchievements.renderItem.field_77024_a = true;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColour = hasAchievement ? 8019267 : 5652783;
            this.field_146297_k.field_71466_p.func_78276_b(achievement.getTitle(), this.guiLeft + 33, this.guiTop + offset + 3, textColour);
            this.field_146297_k.field_71466_p.func_78279_b(achievement.getDescription(), this.guiLeft + 12, this.guiTop + offset + 23, 184, textColour);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!hasAchievement) continue;
            this.field_146297_k.func_110434_K().func_110577_a(iconsTexture);
            this.func_73729_b(this.guiLeft + 181, this.guiTop + offset + 2, 190, 17, 16, 16);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 2) {
                currentCategoryIndex = currentCategoryIndex == 0 ? LOTRAchievement.Category.values().length - 1 : --currentCategoryIndex;
                this.currentScroll = 0.0f;
            } else if (button.field_146127_k == 3) {
                currentCategoryIndex = currentCategoryIndex == LOTRAchievement.Category.values().length - 1 ? 0 : ++currentCategoryIndex;
                this.currentScroll = 0.0f;
            } else {
                super.func_146284_a(button);
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.hasScrollBar()) {
            int j = this.currentCategoryTakenCount + this.currentCategoryUntakenCount - 4;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    private boolean hasScrollBar() {
        return this.currentCategoryTakenCount + this.currentCategoryUntakenCount > 4;
    }

    private void updateAchievementLists() {
        this.currentCategoryTakenAchievements.clear();
        this.currentCategoryUntakenAchievements.clear();
        for (LOTRAchievement achievement : this.currentCategory.list) {
            if (!achievement.canPlayerEarn((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            if (LOTRLevelData.hasAchievement((EntityPlayer)this.field_146297_k.field_71439_g, achievement)) {
                this.currentCategoryTakenAchievements.add(achievement);
                continue;
            }
            this.currentCategoryUntakenAchievements.add(achievement);
        }
        this.currentCategoryTakenCount = this.currentCategoryTakenAchievements.size();
        this.currentCategoryUntakenCount = this.currentCategoryUntakenAchievements.size();
        this.totalTakenCount = 0;
        for (LOTRAchievement achievement : LOTRLevelData.getPlayerAchievements((EntityPlayer)this.field_146297_k.field_71439_g)) {
            if (!achievement.canPlayerEarn((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            ++this.totalTakenCount;
        }
        this.totalAvailableCount = 0;
        for (LOTRAchievement achievement : LOTRAchievement.allAchievements) {
            if (!achievement.canPlayerEarn((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            ++this.totalAvailableCount;
        }
        Collections.sort(this.currentCategoryTakenAchievements);
        Collections.sort(this.currentCategoryUntakenAchievements);
    }
}

